<?php
$techco_common_meta = 'techco_common_meta';

// Create a metabox
CSF::createMetabox($techco_common_meta, array(
	'title'     => esc_html__('Settings', 'techco-core'),
	'post_type' => array('page', 'post'),
	'data_type' => 'serialize',
));

// Create layout section
CSF::createSection($techco_common_meta, array(
	'title'  => esc_html__('Layout Settings ', 'techco-core'),
	'icon'   => 'fa fa-calculator',
	'fields' => array(

		array(
			'id'      => 'layout_meta',
			'type'    => 'select',
			'title'   => esc_html__('Layout', 'techco-core'),
			'options' => array(
				'default'       => esc_html__('Default', 'techco-core'),
				'left-sidebar'  => esc_html__('Left Sidebar', 'techco-core'),
				'full-width'    => esc_html__('Full Width', 'techco-core'),
				'right-sidebar' => esc_html__('Right Sidebar', 'techco-core'),
			),
			'default' => 'default',
			'desc'    => esc_html__('Select layout', 'techco-core'),
		),

		array(
			'id'         => 'sidebar_meta',
			'type'       => 'select',
			'title'      => esc_html__('Sidebar', 'techco-core'),
			'options'    => 'techco_sidebars',
			'dependency' => array('layout_meta', '!=', 'full-width'),
			'desc'       => esc_html__('Select sidebar you want to show with this page.', 'techco-core'),
		),
	)
));

// Create layout section
CSF::createSection($techco_common_meta, array(
	'title'  => esc_html__('Header Settings ', 'techco-core'),
	'icon'   => 'fa fa-header',
	'fields' => array(

        array(
            'id'       => 'meta_header_type',
            'type'     => 'switcher',
            'title'    => __( 'Header Style', 'techco-plugin' ),
            'text_on'  => __( 'Yes', 'techco-plugin' ),
            'text_off' => __( 'No', 'techco-plugin' ),
            'default'  => false
        ),
        array(
            'id'          => 'meta_header_style',
            'type'        => 'select',
            'chosen'      => true,
            'title'       => __('Select Header Style', 'techco-plugin' ),
            'options'     => Techco_Plugin_Helper::get_header_types(),
            'dependency' => array( 'meta_header_type', '==', 'true' ),
        ),
        array(
            'id'       => 'page_header_disable',
            'type'     => 'switcher',
            'title'    => __( 'DIsable This page Header?', 'techco-plugin' ),
            'text_on'  => __( 'Yes', 'techco-plugin' ),
            'text_off' => __( 'No', 'techco-plugin' ),
            'default'  => false
        ),
	)
));

// Breadcrumb Section
CSF::createSection( $techco_common_meta, array(
    'title'  => 'Page Settings',
    'icon'   => 'fas fa-pager',
    'fields' => array(
        array(
            'type'    => 'subheading',
            'content' => esc_html__( 'Page Color', 'techco-core' ),
        ),

        array(
            'id'     => 'page-bg-color',
            'type'   => 'color',
            'title'  => 'Page Background Color',
            'output' => array( 'background' => 'body', 'background-color' => '.techco-main-wrap', 'background-color' => '.xb-loadding-container' )
        ),
        array(
            'id'                    => 'preloader_earth_img',
            'type'                  => 'background',
            'title'                 => esc_html__( 'Preloader Image', 'techco-core' ),
            'background_origin'     => false,
            'background_clip'       => false,
            'background_blend-mode' => false,
            'background_attachment' => false,
            'background_size' => false,
            'background_position' => false,
            'background_repeat' => false,
            'output'                => '.xb-loadding-inner',
        ),

        array(
            'id'     => 'scroll-top-color',
            'type'   => 'color',
            'title'  => 'Scroll Button BG Color',
            'output' => array( 'background' => '.xb-backtotop .scroll')
        ),
        array(
            'id'     => 'scroll-top-icon-color',
            'type'   => 'color',
            'title'  => 'Scroll Button Icon Color',
            'output' => array( 'color' => '.xb-backtotop .scroll')
        ),
    )
) );

// Create a section
CSF::createSection($techco_common_meta, array(
	'title'  => esc_html__('Banner Settings', 'techco-core'),
	'icon' => 'fa fa-flag-o',
	'fields' => array(
		array(
			'id'       => 'enable_banner',
			'type'     => 'switcher',
			'title'    => esc_html__('Enable Banner', 'techco-core'),
			'default'  => true,
			'text_on'  => esc_html__('Yes', 'techco-core'),
			'text_off' => esc_html__('No', 'techco-core'),
			'desc'     => esc_html__('Enable or disable banner.', 'techco-core'),
		),

		array(
			'id'                    => 'banner_background_meta',
			'type'                  => 'background',
			'title'                 => esc_html__('Banner Background', 'techco-core'),
			'background_origin'     => false,
			'background_clip'       => false,
			'background_blend-mode' => false,
			'background_attachment' => false,
			'background_size'       => false,
			'background_position'   => false,
			'background_repeat'     => false,
			'dependency'            => array('enable_banner', '==', true),
			'output'                => '.breadcrumb.post-banner,.breadcrumb.page-banner',
			'desc'                  => esc_html__('Select banner background color and image', 'techco-core'),
		),

		array(
			'id'         => 'custom_title',
			'type'       => 'text',
			'title'      => esc_html__('Banner Custom Title', 'techco-core'),
			'dependency' => array('enable_banner', '==', true),
			'desc'       => esc_html__('If you want to use custom title write title here.If you don\'t, leave it empty.', 'techco-core')
		),

		array(
			'id'         => 'banner_text_align_meta',
			'type'       => 'select',
			'title'      => esc_html__('Banner Text Align', 'techco-core'),
			'options'    => array(
				'default' => esc_html__('Default', 'techco-core'),
				'left'    => esc_html__('Left', 'techco-core'),
				'center'  => esc_html__('Center', 'techco-core'),
				'right'   => esc_html__('Right', 'techco-core'),
			),
			'default'    => 'default',
			'dependency' => array('enable_banner', '==', true),
			'desc'       => esc_html__('Select page banner text align.', 'techco-core'),
		),

		array(
			'id'          => 'banner_height_meta',
			'type'        => 'slider',
			'title'       => esc_html__('Banner Height', 'techco-core'),
			'min'         => 100,
			'max'         => 800,
			'step'        => 1,
			'unit'        => 'px',
			'output'      => '.breadcrumb.post-banner,.breadcrumb.page-banner',
			'output_mode' => 'height',
			'subtitle'    => esc_html__('Select banner min height.', 'techco-core'),
			'desc'        => esc_html__('Select banner min height.', 'techco-core'),
			'dependency'  => array('enable_banner', '==', true),
		),
	)
));


// Create Footer section
CSF::createSection($techco_common_meta, array(
	'title'  => esc_html__('Footer Options', 'techco-core'),
	'icon' => 'fa fa-wordpress',
	'fields' => array(

        array(
            'id'       => 'meta_footer_type',
            'type'     => 'switcher',
            'title'    => __( 'Footer Style', 'techco-core' ),
            'text_on'  => __( 'Yes', 'techco-core' ),
            'text_off' => __( 'No', 'techco-core' ),
            'default'  => false
        ),
        array(
            'id'          => 'meta_footer_style',
            'type'        => 'select',
            'title'       => __('Select Footer Style', 'techco-core' ),
            'options'     => Techco_Plugin_Helper::get_footer_types(),
            'dependency' => array( 'meta_footer_type', '==', 'true' ),
        ),
        array(
            'id'      => 'page_footer_sticky_disable',
            'title'   => esc_html__( 'Disable Stikcy Footer', 'techco-core' ),
            'type'    => 'switcher',
            'desc'    => esc_html__( 'Disable or Disable Stikcy Footer', 'techco-core' ),
            'default' => false,
        ),
        array(
            'id'       => 'page_footer_disable',
            'type'     => 'switcher',
            'title'    => __( 'DIsable This page Footer?', 'techco-core' ),
            'text_on'  => __( 'Yes', 'techco-core' ),
            'text_off' => __( 'No', 'techco-core' ),
            'default'  => false
        ),

	)
));

/*-------------------------------------
    Page Options
    -------------------------------------*/

