<?php

/**
 * Elementor Single Widget
 * @package techco-core
 * @since 1.0.0
 */

namespace Elementor;

if (!defined('ABSPATH')) exit; // Exit if accessed directly.

class Techco_Testimonial_V2 extends Widget_Base
{

    /**
     * Get widget name.
     *
     * Retrieve Elementor widget name.
     *
     * @return string Widget name.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_name()
    {
        return 'int-testimonial-v2';
    }

    /**
     * Get widget title.
     *
     * Retrieve Elementor widget title.
     *
     * @return string Widget title.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_title()
    {
        return esc_html__('Testimonial V2', 'techco-core');
    }

    /**
     * Get widget icon.
     *
     * Retrieve Elementor widget icon.
     *
     * @return string Widget icon.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_icon()
    {
        return 'techco-custom-icon';
    }

    /**
     * Get widget categories.
     *
     * Retrieve the list of categories the Elementor widget belongs to.
     *
     * @return array Widget categories.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_categories()
    {
        return ['techco_widgets'];
    }


    protected function register_controls()
    {

        $this->start_controls_section(
            'content_option',
            [
                'label' => esc_html__('Content', 'techco-core'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );
        $repeater = new \Elementor\Repeater();

        $repeater->add_control(
            'title',
            [
                'type' => Controls_Manager::TEXT,
                'label' => esc_html__('Title', 'techco-core'),
                'label_block' => true,
            ]
        );
        $repeater->add_control(
            'content',
            [
                'type' => Controls_Manager::TEXT,
                'label' => esc_html__('Content', 'techco-core'),
                'label_block' => true,
            ]
        );
        $repeater->add_control(
            'avatar',
            [
                'label' => esc_html__('Avatar', 'techco-core'),
                'type' => \Elementor\Controls_Manager::MEDIA,
            ]
        );
        $repeater->add_control(
            'name',
            [
                'type' => Controls_Manager::TEXT,
                'label' => esc_html__('Name', 'techco-core'),
                'label_block' => true,
            ]
        );
        $repeater->add_control(
            'desig',
            [
                'type' => Controls_Manager::TEXT,
                'label' => esc_html__('Designation', 'techco-core'),
                'label_block' => true,
            ]
        );
        $repeater->add_control(
            'flag',
            [
                'label' => esc_html__('Country Flag', 'techco-core'),
                'type' => \Elementor\Controls_Manager::MEDIA,
            ]
        );
        $repeater->add_control(
            'country_name',
            [
                'type' => Controls_Manager::TEXT,
                'label' => esc_html__('Country Name', 'techco-core'),
                'label_block' => true,
            ]
        );
        $repeater->add_control(
            'client_logo',
            [
                'label' => esc_html__('Client Logo', 'techco-core'),
                'type' => \Elementor\Controls_Manager::MEDIA,
            ]
        );
        $this->add_control(
            'lists',
            [
                'type' => Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
                'title_field' => '{{{ title }}}',
            ]
        );
        $this->end_controls_section();


        $this->start_controls_section(
            'testimonial_style',
            [
                'label' => esc_html__('Style', 'techco-core'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            'bg-c',
            [
                'label' => esc_html__('Background Color', 'techco-core'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .review_onecol_wrapper' => 'background-color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'padding',
            [
                'label' => esc_html__('Padding', 'techco-core'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em', 'rem', 'custom'],
                'selectors' => [
                    '{{WRAPPER}} .review_onecol_wrapper' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_control(
            'border-radius',
            [
                'label' => esc_html__('Border Radius', 'techco-core'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em', 'rem', 'custom'],
                'selectors' => [
                    '{{WRAPPER}} .review_onecol_wrapper' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_control(
            'title_hr',
            [
                'type' => \Elementor\Controls_Manager::DIVIDER,
            ]
        );
        $this->add_control(
            'title-c',
            [
                'label' => esc_html__('Title Color', 'techco-core'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .review_block_2 .review_title' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'title_typography',
                'selector' => '{{WRAPPER}} .review_block_2 .review_title',
            ]
        );
        $this->add_control(
            'content_hr',
            [
                'type' => \Elementor\Controls_Manager::DIVIDER,
            ]
        );
        $this->add_control(
            'content-c',
            [
                'label' => esc_html__('Content Color', 'techco-core'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .review_block_2 .review_commtent' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'content_typography',
                'selector' => '{{WRAPPER}} .review_block_2 .review_commtent',
            ]
        );
        $this->add_control(
            'name_hr',
            [
                'type' => \Elementor\Controls_Manager::DIVIDER,
            ]
        );
        $this->add_control(
            'name-c',
            [
                'label' => esc_html__('Name Color', 'techco-core'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .review_block_2 .review_admin_name' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'name_typography',
                'selector' => '{{WRAPPER}} .review_block_2 .review_admin_name',
            ]
        );
        $this->add_control(
            'desig_hr',
            [
                'type' => \Elementor\Controls_Manager::DIVIDER,
            ]
        );
        $this->add_control(
            'desig-c',
            [
                'label' => esc_html__('Designation Color', 'techco-core'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .review_block_2 .review_admin_designation' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'desig_typography',
                'selector' => '{{WRAPPER}} .review_block_2 .review_admin_designation',
            ]
        );
        $this->add_control(
            'country_name_hr',
            [
                'type' => \Elementor\Controls_Manager::DIVIDER,
            ]
        );
        $this->add_control(
            'country_name-c',
            [
                'label' => esc_html__('Country Name Color', 'techco-core'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .review_block_2 .country_text' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'country_name_typography',
                'selector' => '{{WRAPPER}} .review_block_2 .country_text',
            ]
        );
        $this->add_control(
            'nav_style',
            [
                'label' => esc_html__('Nav Style', 'techco-core'),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );
        $this->start_controls_tabs(
            'style_tabs'
        );

        $this->start_controls_tab(
            'style_normal_tab',
            [
                'label' => esc_html__('Normal', 'techco-core'),
            ]
        );

        $this->add_control(
            'nav-c',
            [
                'label' => esc_html__('Nav Color', 'techco-core'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .review_onecol_carousel .carousel_arrows_nav button' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'nav_bg-c',
            [
                'label' => esc_html__('Nav BG Color', 'techco-core'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .review_onecol_carousel .carousel_arrows_nav button' => 'background-color: {{VALUE}}',
                ],
            ]
        );

        $this->end_controls_tab();

        $this->start_controls_tab(
            'style_hover_tab',
            [
                'label' => esc_html__('Hover', 'techco-core'),
            ]
        );

        $this->add_control(
            'h_nav-c',
            [
                'label' => esc_html__('Nav Color', 'techco-core'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .review_onecol_carousel .carousel_arrows_nav button:hover' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'h_nav_bg-c',
            [
                'label' => esc_html__('Nav BG Color', 'techco-core'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .review_onecol_carousel .carousel_arrows_nav button:hover' => 'background-color: {{VALUE}}',
                ],
            ]
        );

        $this->end_controls_tab();

        $this->end_controls_tabs();
        $this->end_controls_section();

    }

    protected function render()
    {
        $settings = $this->get_settings_for_display();
        ?>
        <div class="review_onecol_wrapper">
            <div class="review_onecol_carousel swiper">
                <div class="swiper-wrapper">
                    <?php
                    foreach ($settings['lists'] as $list):
                        ?>
                        <div class="swiper-slide">
                            <div class="review_block_2">
                                <?php if (!empty($list['title'])): ?>
                                    <h3 class="review_title"><?php echo esc_html($list['title']); ?></h3>
                                <?php endif; ?>
                                <?php if (!empty($list['content'])): ?>
                                    <p class="review_commtent">
                                        <?php echo wp_kses($list['content'], true); ?>
                                    </p>
                                <?php endif; ?>
                                <div class="d-md-flex justify-content-md-between">
                                    <div class="review_admin">
                                        <?php if (!empty($list['avatar']['id'])): ?>
                                            <div class="review_admin_image">
                                                <?php echo wp_get_attachment_image($list['avatar']['id'], 'full'); ?>
                                            </div>
                                        <?php endif; ?>
                                        <div class="review_admin_info">
                                            <?php if (!empty($list['name'])): ?>
                                                <h4 class="review_admin_name"><?php echo esc_html($list['name']); ?></h4>
                                            <?php endif; ?>
                                            <?php if (!empty($list['desig'])): ?>
                                                <span class="review_admin_designation"><?php echo esc_html($list['desig']); ?></span>
                                            <?php endif; ?>
                                            <div class="review_admin_country">
                                                <?php if (!empty($list['flag']['id'])): ?>
                                                    <span class="country_flag">
                                                <?php echo wp_get_attachment_image($list['flag']['id'], 'full'); ?>
                                              </span>
                                                <?php endif; ?>
                                                <?php if (!empty($list['country_name'])): ?>
                                                    <span class="country_text"><?php echo esc_html($list['country_name']); ?></span>
                                                <?php endif; ?>
                                            </div>
                                        </div>
                                    </div>
                                    <?php if (!empty($list['client_logo']['id'])): ?>
                                        <div class="review_admin_logo">
                                            <?php echo wp_get_attachment_image($list['client_logo']['id'], 'full'); ?>
                                        </div>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>
                    <?php endforeach; ?>
                </div>
                <div class="carousel_arrows_nav">
                    <button type="button" class="r1cc-swiper-button-prev">
                        <i class="fa-solid fa-arrow-left"></i>
                    </button>
                    <button type="button" class="r1cc-swiper-button-next">
                        <i class="fa-solid fa-arrow-right"></i>
                    </button>
                </div>
            </div>
        </div>

        <?php
    }


}


Plugin::instance()->widgets_manager->register(new Techco_Testimonial_V2());