<?php

/**
 * Elementor Single Widget
 * @package techco-core
 * @since 1.0.0
 */

namespace Elementor;

if (!defined('ABSPATH')) exit; // Exit if accessed directly.

class Techco_Story extends Widget_Base
{

    /**
     * Get widget name.
     *
     * Retrieve Elementor widget name.
     *
     * @return string Widget name.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_name()
    {
        return 'int-story';
    }

    /**
     * Get widget title.
     *
     * Retrieve Elementor widget title.
     *
     * @return string Widget title.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_title()
    {
        return esc_html__('Story', 'techco-core');
    }

    /**
     * Get widget icon.
     *
     * Retrieve Elementor widget icon.
     *
     * @return string Widget icon.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_icon()
    {
        return 'techco-custom-icon';
    }

    /**
     * Get widget categories.
     *
     * Retrieve the list of categories the Elementor widget belongs to.
     *
     * @return array Widget categories.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_categories()
    {
        return ['techco_widgets'];
    }


    protected function register_controls()
    {

        $this->start_controls_section(
            'content_option',
            [
                'label' => esc_html__('Content', 'techco-core'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );
        $this->add_control(
            'design_style',
            [
                'label' => __('Design Style', 'techco-core'),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    'style_1' => __('Style 1', 'techco-core'),
                    'style_2' => __('Style 2', 'techco-core'),
                ],
                'default' => 'style_1',
            ]
        );
        $this->add_control(
            'bg_image',
            [
                'label' => esc_html__('Image', 'textdomain'),
                'type' => \Elementor\Controls_Manager::MEDIA,
            ]
        );
        $this->add_control(
            'subtitle',
            [
                'type' => Controls_Manager::TEXT,
                'label' => esc_html__('Sub Title', 'textdomain'),
                'label_block' => true,
            ]
        );
        $this->add_control(
            'logo',
            [
                'label' => esc_html__('Logo', 'textdomain'),
                'type' => \Elementor\Controls_Manager::MEDIA,
            ]
        );
        $this->add_control(
            'title',
            [
                'type' => Controls_Manager::TEXT,
                'label' => esc_html__('Title', 'textdomain'),
                'label_block' => true,
            ]
        );
        $this->add_control(
            'content_hr',
            [
                'label' => esc_html__('Content', 'textdomain'),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );
        $this->add_control(
            'content',
            [
                'type' => Controls_Manager::TEXTAREA,
                'label' => esc_html__('Content', 'textdomain'),
                'label_block' => true,
            ]
        );
        $this->add_control(
            'avatar',
            [
                'label' => esc_html__('Avatar', 'textdomain'),
                'type' => \Elementor\Controls_Manager::MEDIA,
            ]
        );
        $this->add_control(
            'name',
            [
                'type' => Controls_Manager::TEXT,
                'label' => esc_html__('Name', 'textdomain'),
                'label_block' => true,
            ]
        );
        $this->add_control(
            'desig',
            [
                'type' => Controls_Manager::TEXT,
                'label' => esc_html__('Designation', 'textdomain'),
                'label_block' => true,
            ]
        );
        $this->add_control(
            'data',
            [
                'type' => Controls_Manager::TEXT,
                'label' => esc_html__('Data', 'textdomain'),
                'label_block' => true,
            ]
        );
        $this->add_control(
            'data_desc',
            [
                'type' => Controls_Manager::TEXTAREA,
                'label' => esc_html__('Data Description', 'textdomain'),
                'label_block' => true,
            ]
        );
        $this->end_controls_section();

        $this->start_controls_section(
            'contact_style',
            [
                'label' => esc_html__('Style', 'techco-core'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            'padding',
            [
                'label' => esc_html__('Padding', 'techco-core'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em', 'rem', 'custom'],
                'selectors' => [
                    '{{WRAPPER}} .client-story .story-holder' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_control(
            'subtitle-c',
            [
                'label' => esc_html__('Sub Title Color', 'techco-core'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .client-story .story-holder span' => 'color: {{VALUE}} !important',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'subtitle_typography',
                'selector' => '{{WRAPPER}} .client-story .story-holder span',
            ]
        );
        $this->add_control(
            'title-c',
            [
                'label' => esc_html__('Title Color', 'techco-core'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .client-story .story-holder h3' => 'color: {{VALUE}} !important',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'title_typography',
                'selector' => '{{WRAPPER}} .client-story .story-holder h3',
            ]
        );
        $this->add_control(
            'title_padding',
            [
                'label' => esc_html__('Title Padding', 'techco-core'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em', 'rem', 'custom'],
                'selectors' => [
                    '{{WRAPPER}} .client-story .story-holder h3' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_control(
            'content_options',
            [
                'label' => esc_html__('Content Style', 'techco-core'),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );
        $this->add_control(
            'content_padding',
            [
                'label' => esc_html__('Padding', 'textdomain'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em', 'rem', 'custom'],
                'selectors' => [
                    '{{WRAPPER}} .client-story .story-content' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_control(
            'content_bg-c',
            [
                'label' => esc_html__('Background Color', 'textdomain'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .client-story .story-content' => 'background-color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            's_content_hr',
            [
                'type' => \Elementor\Controls_Manager::DIVIDER,
            ]
        );
        $this->add_control(
            's_content-c',
            [
                'label' => esc_html__('Content Color', 'techco-core'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .client-story .story-content p' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 's_content_typography',
                'selector' => '{{WRAPPER}} .iconbox_title',
            ]
        );
        $this->add_control(
            's_name_hr',
            [
                'type' => \Elementor\Controls_Manager::DIVIDER,
            ]
        );
        $this->add_control(
            's_name-c',
            [
                'label' => esc_html__('Name Color', 'techco-core'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .client-story .story-author-holder h3' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 's_name_typography',
                'selector' => '{{WRAPPER}} .client-story .story-author-holder h3',
            ]
        );
        $this->add_control(
            's_border-c',
            [
                'label' => esc_html__('Border Color', 'textdomain'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .story-author' => 'border-color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'data_hr',
            [
                'type' => \Elementor\Controls_Manager::DIVIDER,
            ]
        );
        $this->add_control(
            's_data-c',
            [
                'label' => esc_html__('Data Text Color', 'techco-core'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .story-data h3' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 's_data_typography',
                'selector' => '{{WRAPPER}} .story-data h3',
            ]
        );
        $this->add_control(
            'data_desc_hr',
            [
                'type' => \Elementor\Controls_Manager::DIVIDER,
            ]
        );
        $this->add_control(
            's_data-desc_c',
            [
                'label' => esc_html__('Data Description Color', 'techco-core'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .client-story .story-data p' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 's_data_desc_typography',
                'selector' => '{{WRAPPER}} .client-story .story-data p',
            ]
        );

        $this->end_controls_section();

    }

    protected function render()
    {
        $settings = $this->get_settings_for_display();
        ?>

        <?php if ($settings['design_style'] === 'style_2'): ?>
        <div class="client-story">
            <div class="row flex-row-reverse mt-none-30">
                <div class="col-lg-8 mt-30">
                    <div class="story-holder" <?php if (!empty($settings['bg_image']['url'])): ?>
                         style="background-image: url('<?php echo esc_url($settings['bg_image']['url']); ?>') <?php endif; ?>">
                        <span><?php echo esc_html($settings['subtitle']); ?></span>
                        <div class="story-logo">
                            <?php echo wp_get_attachment_image($settings['logo']['id'], 'thumbnail'); ?>
                        </div>
                        <h3><?php echo esc_html($settings['title']); ?></h3>
                    </div>
                </div>
                <div class="col-lg-4 mt-30">
                    <div class="story-content">
                        <p><?php echo wp_kses($settings['content'], true); ?></p>
                        <div class="story-author ul_li">
                            <div class="story-author-avatar">
                                <?php echo wp_get_attachment_image($settings['avatar']['id'], 'thumbnail'); ?>
                            </div>
                            <div class="story-author-holder">
                                <h3><?php echo esc_html($settings['name']); ?></h3>
                                <span><?php echo esc_html($settings['desig']); ?></span>
                            </div>
                        </div>
                        <div class="story-data">
                            <h3><?php echo esc_html($settings['data']); ?></h3>
                            <p><?php echo wp_kses($settings['data_desc'], true); ?></p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    <?php else: ?>
        <div class="client-story">
            <div class="row mt-none-30">
                <div class="col-lg-8 mt-30">
                    <div class="story-holder" <?php if (!empty($settings['bg_image']['url'])): ?>
                         style="background-image: url('<?php echo esc_url($settings['bg_image']['url']); ?>') <?php endif; ?>">
                        <span><?php echo esc_html($settings['subtitle']); ?></span>
                        <div class="story-logo">
                            <?php echo wp_get_attachment_image($settings['logo']['id'], 'thumbnail'); ?>
                        </div>
                        <h3><?php echo esc_html($settings['title']); ?></h3>
                    </div>
                </div>
                <div class="col-lg-4 mt-30">
                    <div class="story-content">
                        <p><?php echo wp_kses($settings['content'], true); ?></p>
                        <div class="story-author ul_li">
                            <div class="story-author-avatar">
                                <?php echo wp_get_attachment_image($settings['avatar']['id'], 'thumbnail'); ?>
                            </div>
                            <div class="story-author-holder">
                                <h3><?php echo esc_html($settings['name']); ?></h3>
                                <span><?php echo esc_html($settings['desig']); ?></span>
                            </div>
                        </div>
                        <div class="story-data">
                            <h3><?php echo esc_html($settings['data']); ?></h3>
                            <p><?php echo wp_kses($settings['data_desc'], true); ?></p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    <?php
    endif;
    }

}


Plugin::instance()->widgets_manager->register(new Techco_Story());