<?php

/**
 * Elementor Single Widget
 * @package techco-core
 * @since 1.0.0
 */

namespace Elementor;

if (!defined('ABSPATH')) exit; // Exit if accessed directly.

class Techco_Progress extends Widget_Base
{

    /**
     * Get widget name.
     *
     * Retrieve Elementor widget name.
     *
     * @return string Widget name.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_name()
    {
        return 'int-progress';
    }

    /**
     * Get widget title.
     *
     * Retrieve Elementor widget title.
     *
     * @return string Widget title.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_title()
    {
        return esc_html__('Progress', 'techco-core');
    }

    /**
     * Get widget icon.
     *
     * Retrieve Elementor widget icon.
     *
     * @return string Widget icon.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_icon()
    {
        return 'techco-custom-icon';
    }

    /**
     * Get widget categories.
     *
     * Retrieve the list of categories the Elementor widget belongs to.
     *
     * @return array Widget categories.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_categories()
    {
        return ['techco_widgets'];
    }


    protected function register_controls()
    {

        $this->start_controls_section(
            'content_option',
            [
                'label' => esc_html__('Content', 'techco-core'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'design_style',
            [
                'label' => __('Design Style', 'techco-core'),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    'style_1' => __('Style 1', 'techco-core'),
                    'style_2' => __('Style 2', 'techco-core'),
                    'style_3' => __('Style 3', 'techco-core'),
                ],
                'default' => 'style_1',
            ]
        );
        $this->add_control(
            'progress_number',
            [
                'type' => Controls_Manager::TEXT,
                'label' => esc_html__('Progress Number', 'techco-core'),
                'label_block' => true,
            ]
        );
        $this->add_control(
            'progress_content',
            [
                'type' => Controls_Manager::TEXTAREA,
                'label' => esc_html__('Content', 'techco-core'),
                'label_block' => true,
            ]
        );
        $this->end_controls_section();

        $this->start_controls_section(
            'contact_style',
            [
                'label' => esc_html__('Style', 'techco-core'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Background::get_type(),
            [
                'name' => 'background_crl',
                'types' => [ 'classic', 'gradient' ],
                'selector' => '{{WRAPPER}} .cs_progress',
            ]
        );
        $this->add_control(
            'padding',
            [
                'label' => esc_html__('Padding', 'techco-core'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em', 'rem', 'custom'],
                'selectors' => [
                    '{{WRAPPER}} .cs_progress' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_control(
            'progress_border-c',
            [
                'label' => esc_html__('Progress Border Color', 'techco-core'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .cs_progress .cs_progress_bar svg circle:not(.cs_progress_bar-circle-58)' => 'stroke: {{VALUE}}',
                    '{{WRAPPER}} .cs_progress .cs_progress_bar2 svg circle:not(.cs_progress_bar2-circle-58)' => 'stroke: {{VALUE}}',
                    '{{WRAPPER}} .cs_progress .cs_progress_bar3 svg circle:not(.cs_progress_bar3-circle-58)' => 'stroke: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'progress_border_active-c',
            [
                'label' => esc_html__('Progress Border Active Color', 'techco-core'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .cs_progress .cs_progress_bar svg .cs_progress_bar-circle-58' => 'stroke: {{VALUE}} !important',
                    '{{WRAPPER}}  .cs_progress .cs_progress_bar2 svg .cs_progress_bar2-circle-58' => 'stroke: {{VALUE}} !important',
                    '{{WRAPPER}}  .cs_progress .cs_progress_bar3 svg .cs_progress_bar3-circle-58' => 'stroke: {{VALUE}} !important',
                ],
            ]
        );
        $this->add_control(
            'progress_number_hr',
            [
                'type' => \Elementor\Controls_Manager::DIVIDER,
            ]
        );
        $this->add_control(
            'progress_number-c',
            [
                'label' => esc_html__('Progress Number Color', 'purefit-core'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .cs_progress .cs_progress_bar svg .cs_progress_bar-text-58' => 'fill: {{VALUE}}',
                    '{{WRAPPER}} .cs_progress .cs_progress_bar2 svg .cs_progress_bar2-text-58' => 'fill: {{VALUE}}',
                    '{{WRAPPER}} .cs_progress .cs_progress_bar3 svg .cs_progress_bar3-text-58' => 'fill: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'progress_number_typography',
                'selector' => '{{WRAPPER}} .cs_progress .cs_progress_bar svg .cs_progress_bar-text-58, {{WRAPPER}} .cs_progress .cs_progress_bar svg .cs_progress_bar2-text-58, {{WRAPPER}} .cs_progress .cs_progress_bar svg .cs_progress_bar3-text-58',
            ]
        );
        $this->add_control(
            'progress_content_hr',
            [
                'type' => \Elementor\Controls_Manager::DIVIDER,
            ]
        );
        $this->add_control(
            'progress_content-c',
            [
                'label' => esc_html__('Content Color', 'techco-core'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .cs_progress p' => 'color: {{VALUE}} !important',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'progress_content_typography',
                'selector' => '{{WRAPPER}} .cs_progress p',
            ]
        );
        $this->end_controls_section();

    }

    protected function render()
    {
        $settings = $this->get_settings_for_display();
        ?>

        <?php if ($settings['design_style'] === 'style_2'): ?>
        <div class="cs_progress grd2">
            <div class="cs_progress_bar2" data-pie='{ "percent": <?php echo esc_attr($settings['progress_number']); ?> }'></div>
            <p>
                <?php echo esc_html($settings['progress_content']); ?>
            </p>
        </div>
        <?php elseif ($settings['design_style'] === 'style_3'): ?>
        <div class="cs_progress grd3">
            <div class="cs_progress_bar3" data-pie='{ "percent": <?php echo esc_attr($settings['progress_number']); ?> }'></div>
            <p>
                <?php echo esc_html($settings['progress_content']); ?>
            </p>
        </div>
        <?php else: ?>
        <div class="cs_progress">
            <div class="cs_progress_bar" data-pie='{ "percent": <?php echo esc_attr($settings['progress_number']); ?> }'></div>
            <p>
                <?php echo esc_html($settings['progress_content']); ?>
            </p>
        </div>
    <?php
    endif;
    }


}


Plugin::instance()->widgets_manager->register(new Techco_Progress());