<?php

/**
 * Elementor Single Widget
 * @package techco-core
 * @since 1.0.0
 */

namespace Elementor;

if (!defined('ABSPATH')) exit; // Exit if accessed directly.

class Techco_Hero_Three extends Widget_Base
{

    /**
     * Get widget name.
     *
     * Retrieve Elementor widget name.
     *
     * @return string Widget name.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_name()
    {
        return 'int-hero-three';
    }

    /**
     * Get widget title.
     *
     * Retrieve Elementor widget title.
     *
     * @return string Widget title.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_title()
    {
        return esc_html__('Hero Three', 'techco-core');
    }

    /**
     * Get widget icon.
     *
     * Retrieve Elementor widget icon.
     *
     * @return string Widget icon.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_icon()
    {
        return 'techco-custom-icon';
    }

    /**
     * Get widget categories.
     *
     * Retrieve the list of categories the Elementor widget belongs to.
     *
     * @return array Widget categories.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_categories()
    {
        return ['techco_widgets'];
    }


    protected function register_controls()
    {

        $this->start_controls_section(
            'content_option',
            [
                'label' => esc_html__('Content', 'techco-core'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );
        $this->add_control(
            'bg_img',
            [
                'label' => esc_html__('Background Image', 'techco-core'),
                'type' => \Elementor\Controls_Manager::MEDIA,
            ]
        );

        $this->add_control(
            'title',
            [
                'type' => Controls_Manager::WYSIWYG,
                'label' => esc_html__('Title', 'techco-core'),
                'label_block' => true,
            ]
        );
        $this->add_control(
            'content',
            [
                'type' => Controls_Manager::TEXTAREA,
                'label' => esc_html__('Content', 'techco-core'),
                'label_block' => true,
            ]
        );

        $this->add_control(
            'btn_option',
            [
                'label' => esc_html__('Button Options', 'techco-core'),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );
        $this->add_control(
            'btn_label',
            [
                'type' => Controls_Manager::TEXT,
                'label' => esc_html__('Button Label', 'techco-core'),
                'label_block' => true,
            ]
        );
        $this->add_control(
            'btn_link',
            [
                'label' => esc_html__('Button Link', 'techco-core'),
                'type' => \Elementor\Controls_Manager::URL,
                'options' => ['url'],
                'default' => [
                    'url' => '#',
                ],
                'label_block' => true,
            ]
        );
        $this->add_control(
            'review_option',
            [
                'label' => esc_html__('Review Option', 'techco-core'),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );
        $this->add_control(
            'review_logo',
            [
                'label' => esc_html__('Review Logo', 'techco-core'),
                'type' => \Elementor\Controls_Manager::MEDIA,
            ]
        );
        $this->add_control(
            'rating',
            [
                'label' => esc_html__('Rating', 'techco-core'),
                'type' => \Elementor\Controls_Manager::NUMBER,
                'min' => 1,
                'max' => 5,
                'step' => 5,
                'default' => 5,
            ]
        );
        $this->add_control(
            'review_text',
            [
                'type' => Controls_Manager::TEXT,
                'label' => esc_html__('Review Text', 'techco-core'),
                'label_block' => true,
            ]
        );
        $this->end_controls_section();

        $this->start_controls_section(
            'right_option',
            [
                'label' => esc_html__('Right Content', 'techco-core'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );
        $this->add_control(
            'right_bg_img',
            [
                'label' => esc_html__('Background Image', 'techco-core'),
                'type' => \Elementor\Controls_Manager::MEDIA,
            ]
        );
        $this->add_control(
            'image',
            [
                'label' => esc_html__('Image', 'techco-core'),
                'type' => \Elementor\Controls_Manager::MEDIA,
            ]
        );

        $this->add_control(
            'funfact_options',
            [
                'label' => esc_html__('Funfact Options', 'techco-core'),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );
        $repeater = new \Elementor\Repeater();

        $repeater->add_control(
            'enable_icon',
            [
                'label' => esc_html__('Enable Icon', 'techco-core'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => esc_html__('Show', 'techco-core'),
                'label_off' => esc_html__('Hide', 'techco-core'),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );
        $repeater->add_control(
            'icon_align',
            [
                'label' => __('Icon Align', 'techco-core'),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    'left' => __('Left', 'techco-core'),
                    'right' => __('Right', 'techco-core'),
                ],
                'default' => 'left',
                'condition' => [
                    'enable_icon' => ['yes'],
                ],
            ]
        );
        $repeater->add_control(
            'icon',
            [
                'label' => esc_html__('Icon', 'techco-core'),
                'type' => \Elementor\Controls_Manager::ICONS,
                'condition' => [
                    'enable_icon' => ['yes'],
                ],
            ]
        );
        $repeater->add_control(
            'number',
            [
                'type' => Controls_Manager::TEXT,
                'label' => esc_html__('Number', 'techco-core'),
                'label_block' => true,
            ]
        );
        $repeater->add_control(
            'suffix',
            [
                'type' => Controls_Manager::TEXT,
                'label' => esc_html__('Suffix', 'techco-core'),
                'label_block' => true,
            ]
        );
        $repeater->add_control(
            'title',
            [
                'type' => Controls_Manager::TEXT,
                'label' => esc_html__('Title', 'techco-core'),
                'label_block' => true,
            ]
        );

        $this->add_control(
            'lists',
            [
                'type' => Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
                'title_field' => '{{{ title }}}',
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'content_style',
            [
                'label' => esc_html__('Content Style', 'techco-core'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'title-c',
            [
                'label' => esc_html__('Title Color', 'techco-core'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .business_consulting_hero_section h1' => 'color: {{VALUE}} !important',
                ],
            ]
        );
        $this->add_control(
            'title-mark-c',
            [
                'label' => esc_html__('Title Mark Color', 'techco-core'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .business_consulting_hero_section h1 mark' => 'color: {{VALUE}} !important',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'title_typography',
                'selector' => '{{WRAPPER}} .business_consulting_hero_section h1',
            ]
        );
        $this->add_control(
            'content_hr',
            [
                'type' => \Elementor\Controls_Manager::DIVIDER,
            ]
        );
        $this->add_control(
            'content-c',
            [
                'label' => esc_html__('Content Color', 'techco-core'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .business_consulting_hero_section p' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'content_typography',
                'selector' => '{{WRAPPER}} .business_consulting_hero_section p',
            ]
        );
        $this->add_control(
            'btn_hr',
            [
                'type' => \Elementor\Controls_Manager::DIVIDER,
            ]
        );
        $this->add_control(
            'button_style',
            [
                'label' => esc_html__('Button Style', 'techco-core'),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );
        $this->add_control(
            'btn_padding',
            [
                'label' => esc_html__('Padding', 'techco-core'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em', 'rem', 'custom'],
                'selectors' => [
                    '{{WRAPPER}} .creative_btn .btn_label' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_control(
            'btn_radius',
            [
                'label' => esc_html__('Border Radius', 'techco-core'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em', 'rem', 'custom'],
                'selectors' => [
                    '{{WRAPPER}} .creative_btn .btn_label' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    '{{WRAPPER}} .creative_btn .btn_icon i' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'btn_typography',
                'selector' => '{{WRAPPER}} .creative_btn',
            ]
        );

        $this->start_controls_tabs(
            'style_tabs'
        );

        $this->start_controls_tab(
            'style_normal_tab',
            [
                'label' => esc_html__('Normal', 'techco-core'),
            ]
        );

        $this->add_control(
            'btn_color',
            [
                'label' => esc_html__('Button Color', 'techco-core'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .creative_btn' => 'color: {{VALUE}} !important',
                ],
            ]
        );
        $this->add_control(
            'btn_bg_color',
            [
                'label' => esc_html__('Background Color', 'techco-core'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .creative_btn .bg-primary' => 'background-color: {{VALUE}} !important',
                ],
            ]
        );

        $this->end_controls_tab();

        $this->start_controls_tab(
            'style_hover_tab',
            [
                'label' => esc_html__('Hover', 'techco-core'),
            ]
        );

        $this->add_control(
            'h_btn_color',
            [
                'label' => esc_html__('Button Color', 'techco-core'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .creative_btn:hover' => 'color: {{VALUE}} !important',
                ],
            ]
        );
        $this->add_control(
            'h_btn_bg_color',
            [
                'label' => esc_html__('Background Color', 'techco-core'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .creative_btn:hover .bg-primary' => 'background-color: {{VALUE}} !important',
                ],
            ]
        );
        $this->end_controls_tab();

        $this->end_controls_tabs();

        $this->add_control(
            'review_style',
            [
                'label' => esc_html__('Review Style', 'techco-core'),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );
        $this->add_control(
            'rating-c',
            [
                'label' => esc_html__('Rating Color', 'techco-core'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .rating_block li i' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'rating_text_hr',
            [
                'type' => \Elementor\Controls_Manager::DIVIDER,
            ]
        );
        $this->add_control(
            'rating_text-c',
            [
                'label' => esc_html__('Rating Title Color', 'techco-core'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .google_reviews .review_counter' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'rating_text_typography',
                'selector' => '{{WRAPPER}} .google_reviews .review_counter',
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'funfact_style',
            [
                'label' => esc_html__('Funfact Style', 'techco-core'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            'funfact_bg-c',
            [
                'label' => esc_html__('Background Color', 'techco-core'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .funfact_block' => 'background-color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'ff_padding',
            [
                'label' => esc_html__('Padding', 'techco-core'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em', 'rem', 'custom'],
                'selectors' => [
                    '{{WRAPPER}} .funfact_block.capsule_layout' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_control(
            'ff_icon_hr',
            [
                'type' => \Elementor\Controls_Manager::DIVIDER,
            ]
        );
        $this->add_control(
            'ff_icon-c',
            [
                'label' => esc_html__('Icon Color', 'techco-core'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .funfact_block.capsule_layout .funfact_icon svg path' => 'fill: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'icon_bg-c',
            [
                'label' => esc_html__('Icon BG Color', 'techco-core'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .funfact_block.capsule_layout .funfact_icon' => 'background-color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'ff_number_hr',
            [
                'type' => \Elementor\Controls_Manager::DIVIDER,
            ]
        );
        $this->add_control(
            'ff_number-c',
            [
                'label' => esc_html__('Number Color', 'techco-core'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .funfact_block .counter_value' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'ff_number_typography',
                'selector' => '{{WRAPPER}} .funfact_block .counter_value',
            ]
        );
        $this->add_control(
            'tt_title_hr',
            [
                'type' => \Elementor\Controls_Manager::DIVIDER,
            ]
        );
        $this->add_control(
            'ff_title-c',
            [
                'label' => esc_html__('Title Color', 'techco-core'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .funfact_block .funfact_title' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'ff_title_typography',
                'selector' => '{{WRAPPER}} .funfact_block .funfact_title',
            ]
        );
        $this->end_controls_section();

    }

    protected function render()
    {
        $settings = $this->get_settings_for_display();
        ?>
        <section class="business_consulting_hero_section section_decoration mb-0" <?php if (!empty($settings['bg_img']['url'])): ?>
                style="background-image: url('<?php echo esc_url($settings['bg_img']['url']); ?>') <?php endif; ?>">
            <div class="container">
                <div class="row mt-none-30 align-items-center justify-content-lg-between">
                    <div class="col-lg-5 mt-30">
                        <div class="business_consulting_hero_content">
                            <?php if (!empty($settings['title'])): ?>
                                <h1>
                                    <?php echo wp_kses($settings['title'], true); ?>
                                </h1>
                            <?php endif; ?>
                            <?php if (!empty($settings['content'])): ?>
                                <p>
                                    <?php echo wp_kses($settings['content'], true); ?>
                                </p>
                            <?php endif; ?>

                            <?php if (!empty($settings['btn_label'])): ?>
                                <a class="creative_btn" href="<?php echo esc_url($settings['btn_link']['url']); ?>">
                                    <span class="btn_label bg-primary"><?php echo esc_html($settings['btn_label']); ?></span>
                                    <span class="btn_icon">
                                      <i class="bg-primary fa-solid fa-arrow-up-right"></i>
                                      <i class="bg-primary fa-solid fa-arrow-up-right"></i>
                                    </span>
                                </a>
                            <?php endif; ?>
                            <div class="google_reviews">
                                <?php if (!empty($settings['review_logo'])): ?>
                                    <div class="review_admin_logo">
                                        <?php echo wp_get_attachment_image($settings['review_logo']['id'], 'full'); ?>
                                    </div>
                                <?php endif; ?>
                                <div class="review_info_content">
                                    <ul class="rating_block unordered_list">
                                        <?php if ($settings['rating'] == '1'): ?>
                                            <li><i class="fas fa-star"></i></li>
                                            <li><i class="far fa-star"></i></li>
                                            <li><i class="far fa-star"></i></li>
                                            <li><i class="far fa-star"></i></li>
                                            <li><i class="far fa-star"></i></li>
                                        <?php elseif ($settings['rating'] == '2'): ?>
                                            <li><i class="fas fa-star"></i></li>
                                            <li><i class="fas fa-star"></i></li>
                                            <li><i class="far fa-star"></i></li>
                                            <li><i class="far fa-star"></i></li>
                                            <li><i class="far fa-star"></i></li>
                                        <?php elseif ($settings['rating'] == '3'): ?>
                                            <li><i class="fas fa-star"></i></li>
                                            <li><i class="fas fa-star"></i></li>
                                            <li><i class="fas fa-star"></i></li>
                                            <li><i class="far fa-star"></i></li>
                                            <li><i class="far fa-star"></i></li>
                                        <?php elseif ($settings['rating'] == '4'): ?>
                                            <li><i class="fas fa-star"></i></li>
                                            <li><i class="fas fa-star"></i></li>
                                            <li><i class="fas fa-star"></i></li>
                                            <li><i class="fas fa-star"></i></li>
                                            <li><i class="far fa-star"></i></li>
                                        <?php elseif ($settings['rating'] == '5'): ?>
                                            <li><i class="fas fa-star"></i></li>
                                            <li><i class="fas fa-star"></i></li>
                                            <li><i class="fas fa-star"></i></li>
                                            <li><i class="fas fa-star"></i></li>
                                            <li><i class="fas fa-star"></i></li>
                                        <?php endif; ?>
                                    </ul>
                                    <?php if (!empty($settings['review_text'])): ?>
                                        <div class="review_counter"><?php echo wp_kses($settings['review_text'], true); ?></div>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-lg-6 mt-30">
                        <div class="business_consulting_hero_image">
                            <?php echo wp_get_attachment_image($settings['image']['id'], 'full', false, array('class' => 'hero_image')); ?>
                            <?php
                            $delay = 0;
                            foreach ($settings['lists'] as $index => $list):
                                $delay = $index * 0.2;
                                ?>
                                <div class="funfact_block capsule_layout wow fadeInUp" data-wow-delay="<?php echo esc_attr($delay . 's'); ?>" data-wow-duration=".7s">
                                    <?php if ($list['icon_align'] === 'left'): ?>
                                        <div class="funfact_icon">
                                            <?php \Elementor\Icons_Manager::render_icon($list['icon'], ['aria-hidden' => 'true']); ?>
                                        </div>
                                    <?php endif; ?>
                                    <div class="funfact_content">
                                        <div class="counter_value">
                                            <span class="odometer" data-count="<?php echo esc_attr($list['number']); ?>">0</span>
                                            <span><?php echo esc_html($list['suffix']); ?></span>
                                        </div>
                                        <?php if (!empty($list['title'])): ?>
                                            <h3 class="funfact_title mb-0"><?php echo esc_html($list['title']); ?></h3>
                                        <?php endif; ?>
                                    </div>
                                    <?php if ($list['icon_align'] === 'right'): ?>
                                        <div class="funfact_icon">
                                            <?php \Elementor\Icons_Manager::render_icon($list['right'], ['aria-hidden' => 'true']); ?>
                                        </div>
                                    <?php endif; ?>
                                </div>
                            <?php endforeach; ?>
                        </div>
                    </div>
                </div>
            </div>
            <?php if (!empty($settings['right_bg_img']['id'])): ?>
                <div class="decoration_item shape_1">
                    <?php echo wp_get_attachment_image($settings['right_bg_img']['id'], 'full'); ?>
                </div>
            <?php endif; ?>
        </section>

        <?php
    }


}


Plugin::instance()->widgets_manager->register(new Techco_Hero_Three());