<?php

/**
 * Elementor Single Widget
 * @package techco-core
 * @since 1.0.0
 */

namespace Elementor;

if (!defined('ABSPATH')) exit; // Exit if accessed directly.

class Techco_Hero_One extends Widget_Base
{

    /**
     * Get widget name.
     *
     * Retrieve Elementor widget name.
     *
     * @return string Widget name.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_name()
    {
        return 'int-hero-one';
    }

    /**
     * Get widget title.
     *
     * Retrieve Elementor widget title.
     *
     * @return string Widget title.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_title()
    {
        return esc_html__('Hero One', 'techco-core');
    }

    /**
     * Get widget icon.
     *
     * Retrieve Elementor widget icon.
     *
     * @return string Widget icon.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_icon()
    {
        return 'techco-custom-icon';
    }

    /**
     * Get widget categories.
     *
     * Retrieve the list of categories the Elementor widget belongs to.
     *
     * @return array Widget categories.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_categories()
    {
        return ['techco_widgets'];
    }


    protected function register_controls()
    {

        $this->start_controls_section(
            'content_option',
            [
                'label' => esc_html__('Content', 'techco-core'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );
        $this->add_control(
            'bg_image',
            [
                'label' => esc_html__('Background Image', 'techco-core'),
                'type' => \Elementor\Controls_Manager::MEDIA,
            ]
        );
        $this->add_control(
            'sub_title',
            [
                'type' => Controls_Manager::TEXT,
                'label' => esc_html__('Sub Title', 'techco-core'),
                'label_block' => true,
            ]
        );
        $this->add_control(
            'sub_title_badge',
            [
                'type' => Controls_Manager::TEXT,
                'label' => esc_html__('Sub Title Badge', 'techco-core'),
            ]
        );
        $this->add_control(
            'title',
            [
                'type' => Controls_Manager::TEXT,
                'label' => esc_html__('Title', 'techco-core'),
                'label_block' => true,
            ]
        );
        $this->add_control(
            'content',
            [
                'type' => Controls_Manager::TEXTAREA,
                'label' => esc_html__('Content', 'techco-core'),
                'label_block' => true,
            ]
        );
        $this->add_control(
            'btn_label',
            [
                'type' => Controls_Manager::TEXT,
                'label' => esc_html__('Button Label', 'techco-core'),
                'label_block' => true,
            ]
        );
        $this->add_control(
            'btn_link',
            [
                'label' => esc_html__('Button Link', 'techco-core'),
                'type' => \Elementor\Controls_Manager::URL,
                'options' => ['url'],
                'default' => [
                    'url' => '#',
                ],
                'label_block' => true,
            ]
        );
        $this->add_control(
            'review_info',
            [
                'label' => esc_html__('Review Info', 'techco-core'),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );
        $this->add_control(
            'trustpilot_img',
            [
                'label' => esc_html__('Trustpilot Image', 'techco-core'),
                'type' => \Elementor\Controls_Manager::MEDIA,
            ]
        );
        $this->add_control(
            'trustpilot_rating',
            [
                'type' => Controls_Manager::TEXT,
                'label' => esc_html__('Trustpilot Rating', 'techco-core'),
                'label_block' => true,
            ]
        );
        $this->add_control(
            'review_text',
            [
                'type' => Controls_Manager::TEXT,
                'label' => esc_html__('Review Text', 'techco-core'),
                'label_block' => true,
            ]
        );
        $this->end_controls_section();

        $this->start_controls_section(
            'image_option',
            [
                'label' => esc_html__('Image', 'techco-core'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );
        $this->add_control(
            'image',
            [
                'label' => esc_html__('Image', 'techco-core'),
                'type' => \Elementor\Controls_Manager::MEDIA,
            ]
        );
        $this->end_controls_section();

        $this->start_controls_section(
            'clients_option',
            [
                'label' => esc_html__('Clients Option', 'techco-core'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );
        $this->add_control(
            'clients_number',
            [
                'type' => Controls_Manager::TEXT,
                'label' => esc_html__('Number', 'techco-core'),
                'label_block' => true,
            ]
        );
        $this->add_control(
            'clients_text',
            [
                'type' => Controls_Manager::TEXT,
                'label' => esc_html__('Text', 'techco-core'),
                'label_block' => true,
            ]
        );
        $repeater = new \Elementor\Repeater();

        $repeater->add_control(
            'avatar',
            [
                'label' => esc_html__('Avatar', 'techco-core'),
                'type' => \Elementor\Controls_Manager::MEDIA,
            ]
        );
        $this->add_control(
            'avatars',
            [
                'label' => esc_html__('Add Avatar', 'techco-core'),
                'type' => Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
            ]
        );
        $this->add_control(
            'avatar_number',
            [
                'type' => Controls_Manager::TEXT,
                'label' => esc_html__('Avatar Number', 'techco-core'),
                'label_block' => true,
            ]
        );
        $this->end_controls_section();

        $this->start_controls_section(
            'categories_option',
            [
                'label' => esc_html__('Categories Option', 'techco-core'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );
        $repeater = new \Elementor\Repeater();

        $repeater->add_control(
            'label',
            [
                'type' => Controls_Manager::TEXT,
                'label' => esc_html__('Label', 'techco-core'),
                'label_block' => true,
            ]
        );
        $repeater->add_control(
            'link',
            [
                'label' => esc_html__('Link', 'techco-core'),
                'type' => \Elementor\Controls_Manager::URL,
                'options' => ['url'],
                'default' => [
                    'url' => '#',
                ],
                'label_block' => true,
            ]
        );
        $this->add_control(
            'categories',
            [
                'type' => Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
                'title_field' => '{{{ label }}}',
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'progress_option',
            [
                'label' => esc_html__('Progress Option', 'techco-core'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );
        $this->add_control(
            'progress_image',
            [
                'label' => esc_html__('Image', 'techco-core'),
                'type' => \Elementor\Controls_Manager::MEDIA,
            ]
        );
        $this->add_control(
            'progress_number',
            [
                'type' => Controls_Manager::TEXT,
                'label' => esc_html__('Progress Number', 'techco-core'),
                'label_block' => true,
            ]
        );
        $this->add_control(
            'progress_title',
            [
                'type' => Controls_Manager::TEXT,
                'label' => esc_html__('Title', 'techco-core'),
                'label_block' => true,
            ]
        );
        $this->end_controls_section();

        $this->start_controls_section(
            'content_style',
            [
                'label' => esc_html__('Content Style', 'techco-core'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            'content_bg-c',
            [
                'label' => esc_html__('Background Color', 'techco-core'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .it_solution_hero_content' => 'background-color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'content_padding',
            [
                'label' => esc_html__('Padding', 'techco-core'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em', 'rem', 'custom'],
                'selectors' => [
                    '{{WRAPPER}} .it_solution_hero_content' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_control(
            'sub_title-c',
            [
                'label' => esc_html__('Sub Title Color', 'techco-core'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .heading_focus_text' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'badge-c',
            [
                'label' => esc_html__('Badge Color', 'techco-core'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .heading_focus_text .badge' => 'color: {{VALUE}} !important',
                ],
            ]
        );
        $this->add_control(
            'badge_bg-c',
            [
                'label' => esc_html__('Badge BG Color', 'techco-core'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .heading_focus_text .badge' => 'background-color: {{VALUE}} !important',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'subtitle_typography',
                'selector' => '{{WRAPPER}} .heading_focus_text, {{WRAPPER}} .heading_focus_text .badge',
            ]
        );
        $this->add_control(
            'title-c',
            [
                'label' => esc_html__('Title Color', 'techco-core'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .it_solution_hero_content h1' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'title_typography',
                'selector' => '{{WRAPPER}} .it_solution_hero_content h1',
            ]
        );
        $this->add_control(
            'title_padding',
            [
                'label' => esc_html__('Title Padding', 'techco-core'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em', 'rem', 'custom'],
                'selectors' => [
                    '{{WRAPPER}} .it_solution_hero_content h1' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_control(
            'content_hr',
            [
                'type' => \Elementor\Controls_Manager::DIVIDER,
            ]
        );
        $this->add_control(
            'content-c',
            [
                'label' => esc_html__('Content Color', 'techco-core'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .it_solution_hero_content p' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'content_typography',
                'selector' => '{{WRAPPER}} .it_solution_hero_content p',
            ]
        );
        $this->add_control(
            'btn_hr',
            [
                'type' => \Elementor\Controls_Manager::DIVIDER,
            ]
        );
        $this->add_control(
            'button_style',
            [
                'label' => esc_html__('Button Style', 'techco-core'),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );
        $this->add_control(
            'btn_padding',
            [
                'label' => esc_html__('Padding', 'techco-core'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em', 'rem', 'custom'],
                'selectors' => [
                    '{{WRAPPER}} .btn' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_control(
            'btn_radius',
            [
                'label' => esc_html__('Border Radius', 'techco-core'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em', 'rem', 'custom'],
                'selectors' => [
                    '{{WRAPPER}} .btn' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'btn_typography',
                'selector' => '{{WRAPPER}} .btn',
            ]
        );

        $this->start_controls_tabs(
            'style_tabs'
        );

        $this->start_controls_tab(
            'style_normal_tab',
            [
                'label' => esc_html__('Normal', 'techco-core'),
            ]
        );

        $this->add_control(
            'btn_color',
            [
                'label' => esc_html__('Button Color', 'techco-core'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .btn' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'btn_border_color',
            [
                'label' => esc_html__('Button Border Color', 'techco-core'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .btn' => 'border-color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'btn_bg_color',
            [
                'label' => esc_html__('Background Color', 'techco-core'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .btn' => 'background-color: {{VALUE}}',
                ],
            ]
        );

        $this->end_controls_tab();

        $this->start_controls_tab(
            'style_hover_tab',
            [
                'label' => esc_html__('Hover', 'techco-core'),
            ]
        );
        $this->add_control(
            'h_btn_color',
            [
                'label' => esc_html__('Button Color', 'techco-core'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .btn:hover' => 'color: {{VALUE}}'
                ],
            ]
        );
        $this->add_control(
            'h_border_c',
            [
                'label' => esc_html__('Border Color', 'techco-core'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .btn:hover' => 'border-color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'hbtn_bg_color',
            [
                'label' => esc_html__('Background Color', 'techco-core'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .btn:hover' => 'background-color: {{VALUE}}',
                ],
            ]
        );
        $this->end_controls_tab();
        $this->end_controls_tabs();

        $this->add_control(
            'review_style',
            [
                'label' => esc_html__('Review Style', 'techco-core'),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );
        $this->add_control(
            'review_number-c',
            [
                'label' => esc_html__('Review Number Color', 'techco-core'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .review_short_info span' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'review_number_typography',
                'selector' => '{{WRAPPER}} .review_short_info span',
            ]
        );
        $this->add_control(
            'review_text_hr',
            [
                'type' => \Elementor\Controls_Manager::DIVIDER,
            ]
        );
        $this->add_control(
            'review_text-c',
            [
                'label' => esc_html__('Review Text Color', 'techco-core'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .review_short_info .review_counter' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'review_text_typography',
                'selector' => '{{WRAPPER}} .review_short_info .review_counter',
            ]
        );
        $this->end_controls_section();

        $this->start_controls_section(
            'clients_style',
            [
                'label' => esc_html__('Clients Style', 'techco-core'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            'client_bg-c',
            [
                'label' => esc_html__('Background Color', 'techco-core'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .it_solution_hero_images .worldwide_clients' => 'background-color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'client_padding',
            [
                'label' => esc_html__('Padding', 'techco-core'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em', 'rem', 'custom'],
                'selectors' => [
                    '{{WRAPPER}} .it_solution_hero_images .worldwide_clients' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_control(
            'client_radius',
            [
                'label' => esc_html__('Border Radius', 'techco-core'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em', 'rem', 'custom'],
                'selectors' => [
                    '{{WRAPPER}} .it_solution_hero_images .worldwide_clients' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_control(
            'client_number_hr',
            [
                'type' => \Elementor\Controls_Manager::DIVIDER,
            ]
        );
        $this->add_control(
            'client_number-c',
            [
                'label' => esc_html__('Number Color', 'techco-core'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .it_solution_hero_images .worldwide_clients .counter_value' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'client_number_typography',
                'selector' => '{{WRAPPER}} .it_solution_hero_images .worldwide_clients .counter_value',
            ]
        );
        $this->add_control(
            'client_text_hr',
            [
                'type' => \Elementor\Controls_Manager::DIVIDER,
            ]
        );
        $this->add_control(
            'client_text-c',
            [
                'label' => esc_html__('Text Color', 'techco-core'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .it_solution_hero_images .worldwide_clients p' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'client_text_typography',
                'selector' => '{{WRAPPER}} .it_solution_hero_images .worldwide_clients p',
            ]
        );
        $this->add_control(
            'avatar_text_hr',
            [
                'type' => \Elementor\Controls_Manager::DIVIDER,
            ]
        );
        $this->add_control(
            'avatar_text-c',
            [
                'label' => esc_html__('Avatar Text Color', 'techco-core'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .avatar_group > li:last-child' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'avatar_text_bg-c',
            [
                'label' => esc_html__('Background Color', 'techco-core'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .avatar_group > li:last-child' => 'background-color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'avatar_text_typography',
                'selector' => '{{WRAPPER}} .avatar_group > li:last-child',
            ]
        );
        $this->end_controls_section();

        $this->start_controls_section(
            'category_style',
            [
                'label' => esc_html__('Category Style', 'techco-core'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            'cat_bg-c',
            [
                'label' => esc_html__('Background Color', 'techco-core'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .it_solution_hero_images .categories' => 'background-color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'cat_wrapper_padding',
            [
                'label' => esc_html__('Padding', 'techco-core'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em', 'rem', 'custom'],
                'selectors' => [
                    '{{WRAPPER}} .it_solution_hero_images .categories' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_control(
            'cat_radius',
            [
                'label' => esc_html__('Border Radius', 'techco-core'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em', 'rem', 'custom'],
                'selectors' => [
                    '{{WRAPPER}} .it_solution_hero_images .categories' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_control(
            'cat_style',
            [
                'label' => esc_html__('Category Style', 'techco-core'),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'cat_typography',
                'selector' => '{{WRAPPER}} .it_solution_hero_images .categories a span',
            ]
        );
        $this->add_control(
            'cat_padding',
            [
                'label' => esc_html__('Padding', 'techco-core'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em', 'rem', 'custom'],
                'selectors' => [
                    '{{WRAPPER}} .it_solution_hero_images .categories a span' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->start_controls_tabs(
            'cstyle_tabs'
        );

        $this->start_controls_tab(
            'cstyle_normal_tab',
            [
                'label' => esc_html__('Normal', 'techco-core'),
            ]
        );

        $this->add_control(
            'cat-c',
            [
                'label' => esc_html__('Color', 'techco-core'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .it_solution_hero_images .categories a span' => 'color: {{VALUE}}',
                    '{{WRAPPER}} .it_solution_hero_images .categories a i' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'cat_border_c',
            [
                'label' => esc_html__('Border Color', 'techco-core'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .it_solution_hero_images .categories a span' => 'border-color: {{VALUE}}',
                    '{{WRAPPER}} .it_solution_hero_images .categories a i' => 'border-color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'ccat_bg-c',
            [
                'label' => esc_html__('Background Color', 'techco-core'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .it_solution_hero_images .categories a span' => 'background-color: {{VALUE}}',
                    '{{WRAPPER}} .it_solution_hero_images .categories a i' => 'background-color: {{VALUE}}',
                ],
            ]
        );

        $this->end_controls_tab();

        $this->start_controls_tab(
            'cstyle_hover_tab',
            [
                'label' => esc_html__('Hover', 'techco-core'),
            ]
        );

        $this->add_control(
            'h_cat-c',
            [
                'label' => esc_html__('Color', 'techco-core'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .it_solution_hero_images .categories a span:hover' => 'color: {{VALUE}}',
                    '{{WRAPPER}} .it_solution_hero_images .categories a:hover i' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'h_cat_border_c',
            [
                'label' => esc_html__('Border Color', 'techco-core'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .it_solution_hero_images .categories a span:hover' => 'border-color: {{VALUE}}',
                    '{{WRAPPER}} .it_solution_hero_images .categories a:hover i' => 'border-color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'h_cat_bg-c',
            [
                'label' => esc_html__('Background Color', 'techco-core'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .it_solution_hero_images .categories a span:hover' => 'background-color: {{VALUE}}',
                    '{{WRAPPER}} .it_solution_hero_images .categories a:hover i' => 'background-color: {{VALUE}}',
                ],
            ]
        );

        $this->end_controls_tab();

        $this->end_controls_tabs();
        $this->end_controls_section();

        $this->start_controls_section(
            'progress_style',
            [
                'label' => esc_html__('Progress Style', 'techco-core'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'progress-stroke-c',
            [
                'label' => esc_html__('Progress Circle Stroke Color', 'techco-core'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .it_solution_hero_images .business_growth_content .business_growth svg circle:not(.business_growth-circle-58)' => 'stroke: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'progress-c',
            [
                'label' => esc_html__('Progress Stroke Color', 'techco-core'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .it_solution_hero_images .business_growth_content .business_growth svg .business_growth-circle-58' => 'stroke: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'progress_number_hr',
            [
                'type' => \Elementor\Controls_Manager::DIVIDER,
            ]
        );
        $this->add_control(
            'progress_number-c',
            [
                'label' => esc_html__('Progress Number Color', 'techco-core'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .it_solution_hero_images .business_growth_content .business_growth svg .business_growth-text-58' => 'fill: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'progress_number_typography',
                'selector' => '{{WRAPPER}} .it_solution_hero_images .business_growth_content .business_growth svg .business_growth-text-58',
            ]
        );
        $this->add_control(
            'progress_text_hr',
            [
                'type' => \Elementor\Controls_Manager::DIVIDER,
            ]
        );
        $this->add_control(
            'progress_text-c',
            [
                'label' => esc_html__('Progress Text Color', 'techco-core'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .it_solution_hero_images .business_growth_content p' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'progress_text_typography',
                'selector' => '{{WRAPPER}} .it_solution_hero_images .business_growth_content p',
            ]
        );

        $this->end_controls_section();

    }

    protected function render()
    {
        $settings = $this->get_settings_for_display();
        ?>
        <section class="it_solution_hero_section">
            <div class="container">
                <div class="row">
                    <div class="col-lg-7">
                        <div class="it_solution_hero_content" <?php if (!empty($settings['bg_image']['url'])): ?>
                             style="background-image: url('<?php echo esc_url($settings['bg_image']['url']); ?>') <?php endif; ?>">
                            <div class="heading_focus_text mb-0 d-inline-flex align-items-center"><?php echo esc_html($settings['sub_title']);
                                if (!empty($settings['sub_title_badge'])): ?>
                                    <span class="badge bg-secondary text-white"><?php echo esc_html($settings['sub_title_badge']); ?></span>
                                <?php endif; ?>
                            </div>
                            <?php if (!empty($settings['title'])): ?>
                                <h1>
                                    <?php echo wp_kses($settings['title'], true); ?>
                                </h1>
                            <?php endif; ?>

                            <?php if (!empty($settings['content'])): ?>
                                <p>
                                    <?php echo wp_kses($settings['content'], true); ?>
                                </p>
                            <?php endif; ?>
                            <ul class="btns_group unordered_list p-0 justify-content-start">
                                <?php if (!empty($settings['btn_label'])): ?>
                                    <li>
                                        <a class="btn" href="<?php echo esc_url($settings['btn_link']['url']); ?>">
                                            <span class="btn_label"
                                                  data-text="<?php echo esc_attr($settings['btn_label']); ?>"><?php echo esc_html($settings['btn_label']); ?></span>
                                            <span class="btn_icon">
                          <i class="fa-solid fa-arrow-up-right"></i>
                        </span>
                                        </a>
                                    </li>
                                <?php endif; ?>
                                <li>
                                    <div class="review_short_info">
                                        <div class="d-flex">
                                            <?php echo wp_get_attachment_image($settings['trustpilot_img']['id'], 'full'); ?>
                                            <span><?php echo esc_html($settings['trustpilot_rating']); ?></span>
                                        </div>
                                        <div class="review_counter"><?php echo wp_kses($settings['review_text'], true); ?></div>
                                    </div>
                                </li>
                            </ul>
                        </div>
                    </div>
                    <div class="col-lg-5">
                        <ul class="it_solution_hero_images unordered_list">
                            <li>
                                <?php echo wp_get_attachment_image($settings['image']['id'], 'full'); ?>
                            </li>
                            <li>
                                <div class="worldwide_clients">
                                    <?php if (!empty($settings['clients_number'])): ?>
                                        <div class="counter_value"><?php echo esc_html($settings['clients_number']); ?></div>
                                    <?php endif; ?>
                                    <?php if (!empty($settings['clients_text'])): ?>
                                        <p>
                                            <?php echo wp_kses($settings['clients_text'], true); ?>
                                        </p>
                                    <?php endif; ?>
                                    <ul class="avatar_group unordered_list">
                                        <?php
                                        foreach ($settings['avatars'] as $avatar):
                                            ?>
                                            <li>
                                                <?php echo wp_get_attachment_image($avatar['avatar']['id'], 'full'); ?>
                                            </li>
                                        <?php endforeach; ?>
                                        <li>
                                            <?php echo esc_html($settings['avatar_number']); ?>
                                        </li>
                                    </ul>
                                </div>
                            </li>
                            <li>
                                <ul class="categories unordered_list_block">
                                    <?php
                                    foreach ($settings['categories'] as $category):
                                        ?>
                                        <li>
                                            <a href="<?php echo esc_url($category['link']['url']); ?>">
                                                <span><?php echo esc_html($category['label']); ?></span>
                                                <i class="fa-solid fa-plus"></i>
                                            </a>
                                        </li>
                                    <?php endforeach; ?>
                                </ul>
                            </li>
                            <li>
                                <div class="business_growth_content"
                                    <?php if (!empty($settings['progress_image']['url'])): ?>
                                     style="background-image: url('<?php echo esc_url($settings['progress_image']['url']); ?>') <?php endif; ?>">
                                    <div class="progress_content">
                                        <div class="business_growth" data-pie='{ "percent": <?php echo esc_attr($settings['progress_number']); ?> }'></div>
                                        <p>
                                            <?php echo esc_html($settings['progress_title']); ?>
                                        </p>
                                    </div>
                                </div>
                            </li>
                        </ul>
                    </div>
                </div>
            </div>
        </section>

        <?php
    }


}


Plugin::instance()->widgets_manager->register(new Techco_Hero_One());