<?php

/**
 * Elementor Single Widget
 * @package techco-core
 * @since 1.0.0
 */

namespace Elementor;

if (!defined('ABSPATH')) exit; // Exit if accessed directly.

class Techco_Footer_Copyright_V2 extends Widget_Base
{

    /**
     * Get widget name.
     *
     * Retrieve Elementor widget name.
     *
     * @return string Widget name.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_name()
    {
        return 'int-footer-copyright-v2';
    }

    /**
     * Get widget title.
     *
     * Retrieve Elementor widget title.
     *
     * @return string Widget title.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_title()
    {
        return esc_html__('Footer Copyright V2', 'techco-core');
    }

    /**
     * Get widget icon.
     *
     * Retrieve Elementor widget icon.
     *
     * @return string Widget icon.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_icon()
    {
        return 'techco-custom-icon';
    }

    /**
     * Get widget categories.
     *
     * Retrieve the list of categories the Elementor widget belongs to.
     *
     * @return array Widget categories.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_categories()
    {
        return ['techco_widgets'];
    }


    protected function register_controls()
    {

        $this->start_controls_section(
            'content_option',
            [
                'label' => esc_html__('Content', 'techco-core'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );
        $this->add_control(
            'bg_image',
            [
                'label' => esc_html__('Background Image', 'techco-core'),
                'type' => \Elementor\Controls_Manager::MEDIA,
            ]
        );
        $this->add_control(
            'copyright_text',
            [
                'type' => Controls_Manager::WYSIWYG,
                'label' => esc_html__('Copyright Text', 'techco-core'),
                'label_block' => true,
            ]
        );
        $this->add_control(
            'links_option',
            [
                'label' => esc_html__('Links Options', 'techco-core'),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );
        $repeater = new \Elementor\Repeater();

        $repeater->add_control(
            'label',
            [
                'type' => Controls_Manager::TEXT,
                'label' => esc_html__('Label', 'techco-core'),
                'label_block' => true,
            ]
        );
        $repeater->add_control(
            'link',
            [
                'label' => esc_html__('Link', 'techco-core'),
                'type' => \Elementor\Controls_Manager::URL,
                'options' => ['url'],
                'default' => [
                    'url' => '#',
                ],
                'label_block' => true,
            ]
        );
        $this->add_control(
            'links',
            [
                'label' => esc_html__('Add Link', 'techco-core'),
                'type' => Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
                'title_field' => '{{{ label }}}',
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'copyright_style',
            [
                'label' => esc_html__('Style', 'techco-core'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            'text-c',
            [
                'label' => esc_html__('Text Color', 'techco-core'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .footer_bottom.style_2 .copyright_text p' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'link-c',
            [
                'label' => esc_html__('Link Color', 'techco-core'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .copyright_text a' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'text_typography',
                'selector' => '{{WRAPPER}} .copyright_text',
            ]
        );
        $this->add_control(
            'link_style',
            [
                'label' => esc_html__('Link Style', 'techco-core'),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );
        $this->add_control(
            'b_link-c',
            [
                'label' => esc_html__('Link Color', 'techco-core'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .footer_bottom.style_2 .icon_list a' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'link_hover-c',
            [
                'label' => esc_html__('Link Hover Color', 'techco-core'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .footer_bottom.style_2 .icon_list a:hover' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'link_dot-c',
            [
                'label' => esc_html__('Link Dot Color', 'techco-core'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .icon_list .icon_list_icon:has(.fa-circle)' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'link_typography',
                'selector' => '{{WRAPPER}} .footer_bottom.style_2 .icon_list a',
            ]
        );
        $this->end_controls_section();

    }

    protected function render()
    {
        $settings = $this->get_settings_for_display();
        ?>
        <div class="footer_bottom style_2" <?php if (!empty($settings['bg_image']['url'])): ?>
             style="background-image: url('<?php echo esc_url($settings['bg_image']['url']); ?>') <?php endif; ?>">
            <div class="container d-md-flex align-items-md-center justify-content-md-between">
                <?php if (!empty($settings['copyright_text'])): ?>
                    <div class="copyright_text">
                        <?php echo wp_kses($settings['copyright_text'], true); ?>
                    </div>
                <?php endif; ?>
                <ul class="icon_list unordered_list">
                    <?php
                    foreach ($settings['links'] as $link):
                        $target = $link['link']['is_external'] ? ' target="_blank"' : '';
                        $nofollow = $link['link']['nofollow'] ? ' rel="nofollow"' : '';
                        ?>
                        <li>
                            <a href="<?php echo esc_url($link['link']['url']); ?>" <?php echo $target . $nofollow; ?>>
                              <span class="icon_list_icon">
                                <i class="fa-solid fa-circle"></i>
                              </span>
                                <span class="icon_list_text">
                                <?php echo esc_html($link['label']); ?>
                              </span>
                            </a>
                        </li>
                    <?php endforeach; ?>
                </ul>
            </div>
        </div>
        <?php
    }

}


Plugin::instance()->widgets_manager->register(new Techco_Footer_Copyright_V2());