<?php

/**
 * Elementor Single Widget
 * @package techco-core
 * @since 1.0.0
 */

namespace Elementor;

if (!defined('ABSPATH')) exit; // Exit if accessed directly.

class Techco_Contact_Info extends Widget_Base
{

    /**
     * Get widget name.
     *
     * Retrieve Elementor widget name.
     *
     * @return string Widget name.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_name()
    {
        return 'int-contact-info';
    }

    /**
     * Get widget title.
     *
     * Retrieve Elementor widget title.
     *
     * @return string Widget title.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_title()
    {
        return esc_html__('Contact Info', 'techco-core');
    }

    /**
     * Get widget icon.
     *
     * Retrieve Elementor widget icon.
     *
     * @return string Widget icon.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_icon()
    {
        return 'techco-custom-icon';
    }

    /**
     * Get widget categories.
     *
     * Retrieve the list of categories the Elementor widget belongs to.
     *
     * @return array Widget categories.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_categories()
    {
        return ['techco_widgets'];
    }


    protected function register_controls()
    {

        $this->start_controls_section(
            'section_title_option',
            [
                'label' => esc_html__('Section Title', 'techco-core'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );
        $this->add_control(
            'sub_title_img',
            [
                'label' => esc_html__('Sub Title Image', 'techco-core'),
                'type' => \Elementor\Controls_Manager::MEDIA,
            ]
        );
        $this->add_control(
            'sub_title', [
                'label' => esc_html__('Sub Title', 'techco-core'),
                'type' => Controls_Manager::TEXT,
                'label_block' => true,
            ]
        );
        $this->add_control(
            'title_hr',
            [
                'type' => \Elementor\Controls_Manager::DIVIDER,
            ]
        );
        $this->add_control(
            'title', [
                'label' => esc_html__('Title', 'techco-core'),
                'type' => Controls_Manager::TEXTAREA,
                'label_block' => true,
            ]
        );
        $this->add_control(
            'st_content_hr',
            [
                'type' => \Elementor\Controls_Manager::DIVIDER,
            ]
        );
        $this->add_control(
            'content', [
                'label' => esc_html__('Content', 'techco-core'),
                'type' => Controls_Manager::TEXTAREA,
                'label_block' => true,
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'content_option',
            [
                'label' => esc_html__('Content', 'techco-core'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );
        $repeater = new \Elementor\Repeater();

        $repeater->add_control(
            'icon',
            [
                'label' => esc_html__('Icon', 'techco-core'),
                'type' => \Elementor\Controls_Manager::ICONS,
            ]
        );
        $repeater->add_control(
            'info',
            [
                'type' => Controls_Manager::WYSIWYG,
                'label' => esc_html__('Info', 'techco-core'),
                'label_block' => true,
            ]
        );
        $this->add_control(
            'infos',
            [
                'label' => esc_html__('Add Info', 'techco-core'),
                'type' => Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
                'title_field' => '{{{ info }}}',
            ]
        );
        $this->add_control(
            'feature_option',
            [
                'label' => esc_html__('Feature Options', 'techco-core'),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $repeater = new \Elementor\Repeater();
        $repeater->add_control(
            'number',
            [
                'type' => Controls_Manager::TEXTAREA,
                'label' => esc_html__('Number', 'techco-core'),
                'label_block' => true,
            ]
        );
        $repeater->add_control(
            'text',
            [
                'type' => Controls_Manager::TEXTAREA,
                'label' => esc_html__('Feature Text', 'techco-core'),
                'label_block' => true,
            ]
        );
        $this->add_control(
            'features',
            [
                'label' => esc_html__('Add Feature', 'techco-core'),
                'type' => Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
                'title_field' => '{{{ text }}}',
            ]
        );
        $this->end_controls_section();

        $this->start_controls_section(
            'section_title_style',
            [
                'label' => esc_html__('Section Title', 'techco-core'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            'sub_title-c',
            [
                'label' => esc_html__('Sub Title Color', 'techco-core'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .heading_focus_text' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'subtitle_typography',
                'selector' => '{{WRAPPER}} .heading_focus_text, {{WRAPPER}} .heading_focus_text .badge',
            ]
        );
        $this->add_control(
            'st_title-c',
            [
                'label' => esc_html__('Title Color', 'techco-core'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .heading_block .heading_text' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'st_title-mark-c',
            [
                'label' => esc_html__('Title Mark Color', 'techco-core'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .heading_text mark' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'st_title_typography',
                'selector' => '{{WRAPPER}} .heading_block .heading_text',
            ]
        );
        $this->add_control(
            'title_padding',
            [
                'label' => esc_html__('Title Padding', 'techco-core'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em', 'rem', 'custom'],
                'selectors' => [
                    '{{WRAPPER}} .heading_block .heading_text' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_control(
            'title_margin',
            [
                'label' => esc_html__('Title Margin', 'techco-core'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em', 'rem', 'custom'],
                'selectors' => [
                    '{{WRAPPER}} .heading_block .heading_text' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_control(
            'content_style_hr',
            [
                'type' => \Elementor\Controls_Manager::DIVIDER,
            ]
        );
        $this->add_control(
            'st_content-c',
            [
                'label' => esc_html__('Content Color', 'techco-core'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .heading_block .heading_description' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'st_content_typography',
                'selector' => '{{WRAPPER}} .heading_block .heading_description',
            ]
        );
        $this->end_controls_section();

        $this->start_controls_section(
            'contact_info_style',
            [
                'label' => esc_html__('Contact Info', 'techco-core'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            'ci_bg-c',
            [
                'label' => esc_html__('Wrapper BG Color', 'techco-core'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .xb-service-box' => 'background-color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'icon-c',
            [
                'label' => esc_html__('Icon Color', 'techco-core'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .contact_method_list .icon svg path' => 'fill: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'icon_bg-c',
            [
                'label' => esc_html__('Icon BG Color', 'techco-core'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .contact_method_list .icon' => 'background-color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'info_text-c',
            [
                'label' => esc_html__('Info Text Color', 'techco-core'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .contact_method_list a' => 'color: {{VALUE}}',
                    '{{WRAPPER}} .contact_method_list p' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'info_text_typography',
                'selector' => '{{WRAPPER}} .contact_method_list a, {{WRAPPER}} .contact_method_list p',
            ]
        );
        $this->add_control(
            'feature_hr',
            [
                'type' => \Elementor\Controls_Manager::DIVIDER,
            ]
        );
        $this->add_control(
            'feat_number_c',
            [
                'label' => esc_html__('Feature Number Color', 'techco-core'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .support_step .serial_number' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'feat_number_border-c',
            [
                'label' => esc_html__('Feature Number Border Color', 'techco-core'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .support_step .serial_number' => 'border-color: {{VALUE}}',
                    '{{WRAPPER}} .support_step::before' => 'background-color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'feature-c',
            [
                'label' => esc_html__('Feature Color', 'techco-core'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .support_step .text' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'feature_typography',
                'selector' => '{{WRAPPER}} .support_step .text',
            ]
        );

        $this->end_controls_section();

    }

    protected function render()
    {
        $settings = $this->get_settings_for_display();
        ?>
        <div class="contact_method_box">
            <div class="heading_block mb-40">
                <div class="heading_focus_text has_underline d-inline-flex mb-3" <?php if (!empty($settings['sub_title_img']['url'])): ?>
                     style="background-image: url('<?php echo esc_url($settings['sub_title_img']['url']); ?>') <?php endif; ?>">
                    <?php echo esc_html($settings['sub_title']); ?>
                </div>
                <?php if (!empty($settings['title'])): ?>
                    <h2 class="heading_text mb-0">
                        <?php echo wp_kses($settings['title'], true); ?>
                    </h2>
                <?php endif; ?>
                <?php if (!empty($settings['content'])): ?>
                    <p class="heading_description mb-0">
                        <?php echo wp_kses($settings['content'], true); ?>
                    </p>
                <?php endif; ?>
            </div>
            <ul class="contact_method_list unordered_list_block">
                <?php
                foreach ($settings['infos'] as $info):
                    ?>
                    <li>
                        <span class="icon">
                          <?php \Elementor\Icons_Manager::render_icon($info['icon'], ['aria-hidden' => 'true']); ?>
                        </span>
                        <?php if (!empty($info['info'])): ?>
                            <span class="text">
                            <?php echo wp_kses($info['info'], true) ?>
                        </span>
                        <?php endif; ?>
                    </li>
                <?php endforeach; ?>
            </ul>
            <ul class="support_step unordered_list_block">
                <?php
                foreach ($settings['features'] as $feature):
                    ?>
                    <li>
                        <span class="serial_number"><?php echo esc_html($feature['number']); ?></span>
                        <span class="text"><?php echo esc_html($feature['text']); ?></span>
                    </li>
                <?php endforeach; ?>
            </ul>
        </div>

        <?php
    }


}


Plugin::instance()->widgets_manager->register(new Techco_Contact_Info());