<?php

/**
 * Elementor Single Widget
 * @package techco-core
 * @since 1.0.0
 */

namespace Elementor;

if (!defined('ABSPATH')) exit; // Exit if accessed directly.

class Techco_Footer_One extends Widget_Base
{

    /**
     * Get widget name.
     *
     * Retrieve Elementor widget name.
     *
     * @return string Widget name.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_name()
    {
        return 'techco-footer-1';
    }

    /**
     * Get widget title.
     *
     * Retrieve Elementor widget title.
     *
     * @return string Widget title.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_title()
    {
        return esc_html__('Footer One', 'techco-core');
    }

    /**
     * Get widget icon.
     *
     * Retrieve Elementor widget icon.
     *
     * @return string Widget icon.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_icon()
    {
        return 'techco-custom-icon';
    }

    /**
     * Get widget categories.
     *
     * Retrieve the list of categories the Elementor widget belongs to.
     *
     * @return array Widget categories.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_categories()
    {
        return ['techco_hf_widgets'];
    }


    protected function register_controls()
    {

        $this->start_controls_section(
            'image_option',
            [
                'label' => esc_html__('Image Option', 'techco-core'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );
        $this->add_control(
            'bg_image',
            [
                'label' => esc_html__('Background Image', 'techco-core'),
                'type' => \Elementor\Controls_Manager::MEDIA,
            ]
        );
        $this->end_controls_section();

        $this->start_controls_section(
            'contact_option',
            [
                'label' => esc_html__('Contact Option', 'techco-core'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );
        $this->add_control(
            'c_icon',
            [
                'label' => esc_html__('Icon', 'techco-core'),
                'type' => \Elementor\Controls_Manager::ICONS,
            ]
        );
        $this->add_control(
            'c_subtitle',
            [
                'type' => Controls_Manager::TEXT,
                'label' => esc_html__('Sub Title', 'techco-core'),
                'label_block' => true,
            ]
        );
        $this->add_control(
            'c_title',
            [
                'type' => Controls_Manager::TEXTAREA,
                'label' => esc_html__('Title', 'techco-core'),
                'label_block' => true,
            ]
        );
        $this->add_control(
            'shortcode',
            [
                'type' => Controls_Manager::TEXT,
                'label' => esc_html__('Shortcode', 'techco-core'),
                'label_block' => true,
            ]
        );
        $this->end_controls_section();

        $this->start_controls_section(
            'contact_info_option',
            [
                'label' => esc_html__('Contact Info Option', 'techco-core'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'ci_icon',
            [
                'label' => esc_html__('Icon', 'techco-core'),
                'type' => \Elementor\Controls_Manager::ICONS,
            ]
        );
        $this->add_control(
            'ci_subtitle',
            [
                'type' => Controls_Manager::TEXT,
                'label' => esc_html__('Sub Title', 'techco-core'),
                'label_block' => true,
            ]
        );
        $this->add_control(
            'address',
            [
                'type' => Controls_Manager::WYSIWYG,
                'label' => esc_html__('Address', 'techco-core'),
                'label_block' => true,
            ]
        );
        $this->add_control(
            'info',
            [
                'type' => Controls_Manager::WYSIWYG,
                'label' => esc_html__('Time Information', 'techco-core'),
                'label_block' => true,
            ]
        );

        $repeater = new \Elementor\Repeater();

        $repeater->add_control(
            'icon',
            [
                'label' => esc_html__('Icon', 'techco-core'),
                'type' => \Elementor\Controls_Manager::ICONS,
            ]
        );
        $repeater->add_control(
            'link',
            [
                'label' => esc_html__('Link', 'techco-core'),
                'type' => \Elementor\Controls_Manager::URL,
                'options' => ['url'],
                'default' => [
                    'url' => '#',
                ],
                'label_block' => true,
            ]
        );
        $this->add_control(
            'socials',
            [
                'label' => esc_html__('Social List', 'techco-core'),
                'type' => Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
            ]
        );
        $this->add_control(
            'b_image',
            [
                'label' => esc_html__('Image', 'techco-core'),
                'type' => \Elementor\Controls_Manager::MEDIA,
            ]
        );
        $this->add_control(
            'b_address',
            [
                'type' => Controls_Manager::WYSIWYG,
                'label' => esc_html__('Address', 'techco-core'),
                'label_block' => true,
            ]
        );
        $this->end_controls_section();

        $this->start_controls_section(
            'footer_option',
            [
                'label' => esc_html__('Footer Option', 'techco-core'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );
        $this->add_control(
            'logo',
            [
                'label' => esc_html__('Logo', 'techco-core'),
                'type' => \Elementor\Controls_Manager::MEDIA,
            ]
        );
        $this->add_control(
            'f_title',
            [
                'type' => Controls_Manager::TEXTAREA,
                'label' => esc_html__('Title', 'techco-core'),
                'label_block' => true,
            ]
        );
        $this->add_control(
            'navs_ottion_hr',
            [
                'type' => \Elementor\Controls_Manager::DIVIDER,
            ]
        );
        $repeater = new \Elementor\Repeater();

        $repeater->add_control(
            'nav',
            [
                'type' => Controls_Manager::TEXT,
                'label' => esc_html__('Nav', 'techco-core'),
                'label_block' => true,
            ]
        );
        $repeater->add_control(
            'link',
            [
                'label' => esc_html__('Link', 'techco-core'),
                'type' => \Elementor\Controls_Manager::URL,
                'options' => ['url'],
                'default' => [
                    'url' => '#',
                ],
                'label_block' => true,
            ]
        );
        $this->add_control(
            'navs',
            [
                'label' => esc_html__('Nav List', 'techco-core'),
                'type' => Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
                'title_field' => '{{{ nav }}}',
            ]
        );
        $this->add_control(
            'copyright_option_hr',
            [
                'type' => \Elementor\Controls_Manager::DIVIDER,
            ]
        );
        $this->add_control(
            'copyright_text',
            [
                'type' => Controls_Manager::WYSIWYG,
                'label' => esc_html__('Copyright Text', 'techco-core'),
                'label_block' => true,
            ]
        );
        $this->add_control(
            'links_option_hr',
            [
                'type' => \Elementor\Controls_Manager::DIVIDER,
            ]
        );
        $repeater = new \Elementor\Repeater();

        $repeater->add_control(
            'link_label',
            [
                'type' => Controls_Manager::TEXT,
                'label' => esc_html__('Link Label', 'techco-core'),
                'label_block' => true,
            ]
        );
        $repeater->add_control(
            'link',
            [
                'label' => esc_html__('Link', 'techco-core'),
                'type' => \Elementor\Controls_Manager::URL,
                'options' => ['url'],
                'default' => [
                    'url' => '#',
                ],
                'label_block' => true,
            ]
        );
        $this->add_control(
            'links',
            [
                'label' => esc_html__('Link List', 'techco-core'),
                'type' => Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
                'title_field' => '{{{ link_label }}}',
            ]
        );
        $this->end_controls_section();


        $this->start_controls_section(
            'top_style',
            [
                'label' => esc_html__('Top Style', 'techco-core'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            'subtitle-c',
            [
                'label' => esc_html__('Sub Title Color', 'techco-core'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .contact-title span' => 'color: {{VALUE}}',
                    '{{WRAPPER}} .contact-info .xb-item--address h3' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'subtitle_typography',
                'selector' => '{{WRAPPER}} .contact-title span, {{WRAPPER}} .contact-info .xb-item--address h3',
            ]
        );
        $this->add_control(
            'title_hr',
            [
                'type' => \Elementor\Controls_Manager::DIVIDER,
            ]
        );
        $this->add_control(
            'title-c',
            [
                'label' => esc_html__('Title Color', 'techco-core'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .contact-info .xb-item--address h3' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'title_typography',
                'selector' => '{{WRAPPER}} .contact-info .xb-item--address h3',
            ]
        );
        $this->add_control(
            'field_style',
            [
                'label' => esc_html__('Form Style', 'techco-core'),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );
        $this->add_control(
            'field-c',
            [
                'label' => esc_html__('Field Color', 'techco-core'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .contact-from .xb-item--field input' => 'color: {{VALUE}}',
                    '{{WRAPPER}} .contact-from .xb-item--field textarea' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'field-bg-c',
            [
                'label' => esc_html__('Field BG Color', 'techco-core'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .contact-from .xb-item--field input' => 'background-color: {{VALUE}}',
                    '{{WRAPPER}} .contact-from .xb-item--field textarea' => 'background-color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'btn_style',
            [
                'label' => esc_html__('Button Style', 'techco-core'),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );
        $this->add_control(
            'btn_padding',
            [
                'label' => esc_html__('Padding', 'techco-core'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em', 'rem', 'custom'],
                'selectors' => [
                    '{{WRAPPER}} .thm-btn' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_control(
            'btn_radius',
            [
                'label' => esc_html__('Border Radius', 'techco-core'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em', 'rem', 'custom'],
                'selectors' => [
                    '{{WRAPPER}} .thm-btn' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'btn_typography',
                'selector' => '{{WRAPPER}} .thm-btn',
            ]
        );

        $this->start_controls_tabs(
            'style_tabs'
        );

        $this->start_controls_tab(
            'style_normal_tab',
            [
                'label' => esc_html__('Normal', 'techco-core'),
            ]
        );

        $this->add_control(
            'btn_color',
            [
                'label' => esc_html__('Button Color', 'techco-core'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .thm-btn' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'btn_border_color',
            [
                'label' => esc_html__('Button Border Color', 'techco-core'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .thm-btn::before' => 'border-color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'btn_bg_color',
            [
                'label' => esc_html__('Background Color', 'techco-core'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .thm-btn' => 'background-color: {{VALUE}}',
                ],
            ]
        );

        $this->end_controls_tab();

        $this->start_controls_tab(
            'style_hover_tab',
            [
                'label' => esc_html__('Hover', 'techco-core'),
            ]
        );

        $this->add_control(
            'h_btn_color',
            [
                'label' => esc_html__('Button Color', 'techco-core'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .thm-btn:hover' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'h_border_c',
            [
                'label' => esc_html__('Border Color', 'techco-core'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .thm-btn:hover::before' => 'border-color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'hbtn_bg_color',
            [
                'label' => esc_html__('Background Color', 'techco-core'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .thm-btn::after' => 'background-color: {{VALUE}}',
                ],
            ]
        );
        $this->end_controls_tab();
        $this->end_controls_tabs();

        $this->end_controls_section();

        $this->start_controls_section(
            'bottom_style',
            [
                'label' => esc_html__('Bottom Style', 'techco-core'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            'b_title-c',
            [
                'label' => esc_html__('Title Color', 'techco-core'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .sec-title .title' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'b_title_typography',
                'selector' => '{{WRAPPER}} .sec-title .title',
            ]
        );
        $this->add_control(
            'nav_style',
            [
                'label' => esc_html__('Nav Style', 'techco-core'),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );
        $this->add_control(
            'nav-c',
            [
                'label' => esc_html__('Nav Color', 'techco-core'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .footer-nav li a' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'nav_hover-c',
            [
                'label' => esc_html__('Nav Hover Color', 'techco-core'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .footer-nav li a:hover' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'nav_typography',
                'selector' => '{{WRAPPER}} .footer-nav li a',
            ]
        );
        $this->add_control(
            'copyright_hr',
            [
                'label' => esc_html__('Copyright Text Style', 'techco-core'),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );
        $this->add_control(
            'copyright-c',
            [
                'label' => esc_html__('Copyright Text Color', 'techco-core'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .footer-copyright' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'copyright_typography',
                'selector' => '{{WRAPPER}} .footer-copyright',
            ]
        );
        $this->add_control(
            'links_hr',
            [
                'label' => esc_html__('Link Style', 'techco-core'),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );
        $this->add_control(
            'link-c',
            [
                'label' => esc_html__('Link Color', 'techco-core'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .footer-links li a' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'link-hover-c',
            [
                'label' => esc_html__('Link Hover Color', 'techco-core'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .footer-links li a' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'link_typography',
                'selector' => '{{WRAPPER}} .footer-links li a',
            ]
        );


        $this->end_controls_section();

    }

    protected function render()
    {
        $settings = $this->get_settings_for_display();
        ?>

        <footer class="position-top bg_img pb-70" <?php if (!empty($settings['bg_image']['url'])): ?>
                style="background-image: url('<?php echo esc_url($settings['bg_image']['url']); ?>') <?php endif; ?>">
            <div class="container">
                <div class="contact pb-100">
                    <div class="row">
                        <div class="col-lg-7">
                            <div class="xb-contact contact-mt--255">
                                <div class="contact-title mb-35">
                                    <?php if (!empty($settings['c_subtitle'])): ?>
                                        <span> <?php \Elementor\Icons_Manager::render_icon($settings['c_icon'], ['aria-hidden' => 'true']);
                                            echo esc_html($settings['c_subtitle']); ?></span>
                                    <?php endif; ?>
                                    <h3><?php echo esc_html($settings['c_title']); ?></h3>
                                </div>
                                <?php if (!empty($settings['shortcode'])): ?>
                                    <div class="contact-from">
                                        <?php echo do_shortcode($settings['shortcode']); ?>
                                    </div>
                                <?php endif; ?>
                            </div>
                        </div>
                        <div class="col-lg-5">
                            <div class="contact-info contact-mt--255 mt-md-30">
                                <div class="xb-item--head">
                                    <div class="xb-item--address">
                                        <?php if (!empty($settings['ci_subtitle'])): ?>
                                            <h3><?php \Elementor\Icons_Manager::render_icon($settings['ci_icon'], ['aria-hidden' => 'true']);
                                                echo esc_html($settings['ci_subtitle']); ?></h3>
                                        <?php endif; ?>
                                        <?php echo wp_kses($settings['address'], true); ?>
                                    </div>
                                    <div class="xb-item--open">
                                        <?php echo wp_kses($settings['info'], true); ?>
                                    </div>
                                    <ul class="xb-item--social ul_li mt-30">
                                        <?php
                                        foreach ($settings['socials'] as $social):
                                            ?>
                                            <li>
                                                <a href="<?php echo esc_html($social['link']['url']); ?>"><?php \Elementor\Icons_Manager::render_icon($social['icon'], ['aria-hidden' => 'true']); ?></a>
                                            </li>
                                        <?php endforeach; ?>
                                    </ul>
                                </div>
                                <div class="xb-item--cta" <?php if (!empty($settings['b_image']['url'])): ?>
                                     style="background-image: url('<?php echo esc_url($settings['b_image']['url']); ?>') <?php endif; ?>">
                                    <?php echo wp_kses($settings['b_address'], true); ?>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="footer-inner">
                    <div class="footer-logo mb-25 text-center">
                        <?php echo wp_get_attachment_image($settings['logo']['id'], 'medium'); ?>
                    </div>
                    <?php if (!empty($settings['f_title'])): ?>
                        <div class="sec-title sec-title--white text-center mb-50">
                            <h2 class="title"><?php echo esc_html($settings['f_title']); ?></h2>
                        </div>
                    <?php endif; ?>
                    <ul class="footer-nav ul_li_center">
                        <?php
                        foreach ($settings['navs'] as $nav):
                            ?>
                            <li>
                                <a href="<?php echo esc_url($nav['link']['url']); ?>"><?php echo esc_html($nav['nav']); ?></a>
                            </li>
                        <?php endforeach; ?>
                    </ul>
                    <div class="footer-bottom mt-50 ul_li_between">
                        <?php if (!empty($settings['copyright_text'])): ?>
                            <div class="footer-copyright mt-30">
                                <?php echo wp_kses($settings['copyright_text'], true); ?>
                            </div>
                        <?php endif; ?>
                        <ul class="footer-links ul_li mt-30">
                            <?php
                            foreach ($settings['links'] as $link):
                                ?>
                                <li>
                                    <a href="<?php echo esc_url($link['link']['url']); ?>"><?php echo esc_html($link['link_label']); ?></a>
                                </li>
                            <?php endforeach; ?>
                        </ul>
                    </div>
                </div>
            </div>
        </footer>

        <!-- sidebar-info end -->
        <div class="body-overlay"></div>


        <?php
    }
}


Plugin::instance()->widgets_manager->register(new Techco_Footer_One());