<?php
/**
 * All Elementor widget init
 * @package techco
 * @since 1.0.0
 */

if ( !defined('ABSPATH') ){
	exit(); // exit if access directly
}

if ( !class_exists('Techco_Elementor_Widget_Init') ){

	class Techco_Elementor_Widget_Init{
		/*
		* $instance
		* @since 1.0.0
		* */
		private static $instance;
		/*
		* construct()
		* @since 1.0.0
		* */
		public function __construct() {
			add_action( 'elementor/elements/categories_registered', array($this,'_widget_categories') );
			//elementor widget registered
			add_action('elementor/widgets/register',array($this,'_widget_registered'));
			add_action('elementor/editor/after_enqueue_styles',array($this,'editor_style'));
			add_action('elementor/documents/register_controls',array($this,'register_document_controls'));
		}
		/*
	   * getInstance()
	   * @since 1.0.0
	   * */
		public static function getInstance(){
			if ( null == self::$instance ){
				self::$instance = new self();
			}
			return self::$instance;
		}
		/**
		 * _widget_categories()
		 * @since 1.0.0
		 * */
		public function _widget_categories($elements_manager){
			$elements_manager->add_category(
				'techco_widgets',
				[
					'title' => __( 'Techco Addons', 'techco-core' ),
					'icon' => 'fa fa-plug'
				]
			);
			$elements_manager->add_category(
				'techco_hf_widgets',
				[
					'title' => __( 'Techco Header & Footer', 'techco-core' ),
					'icon' => 'fa fa-plug'
				]
			);
		}
		

		/**
		 * _widget_registered()
		 * @since 1.0.0
		 * */
		public function _widget_registered(){
			if( !class_exists('Elementor\Widget_Base') ){
				return;
			}
			$elementor_widgets = array(	
				
				// techco Theme Widgets
				'sec-title',
				'xb-button',
				'megamenu-company',
				'megamenu-service',
				'hero-one',
				'hero-two',
				'hero-three',
				'hero-four',
				'cta',
				'cta-v2',
				'footer-info',
				'xb-heading',
				'xb-heading-md',
				'xb-content',
				'xb-social',
				'footer-links',
				'footer-copyright',
				'footer-copyright-v2',
				'brand',
				'brand-v2',
				'funfact',
				'employee',
				'about-image',
				'xb-list',
				'about-video',
				'xb-iconbox',
				'testimonial',
				'blog',
				'blog-v2',
				'service',
				'image-video',
				'xb-content-v2',
				'faq',
				'faq-v2',
				'faq-v3',
				'xb-list-v2',
				'xb-list-v3',
				'project-info',
				'similar-project',
				'project',
				'team',
				'footer-service',
				'service-v2',
				'funfact-v2',
				'funfact-v3',
				'funfact-v4',
				'project-v2',
				'xb-tab',
				'iconbox-v2',
				'xb-review',
				'testimonial-v2',
				'contact-info',
				'contact',
				'brand-v3',
				'feature',
				'feature-v2',
				'feature-v3',
				'feature-v4',
				'service-v3',
				'service-v4',
				'testimonial-v3',
				'testimonial-v4',
				'about',
				'blog-v3',
				'blog-v4',
				'contact-v2',
				'contact-v3',
				'xb-social-v2',
				'xb-social-v3',
				'xb-page-title',
				'pricing-tab',
				'pricing',
				'team-v2',
				'team-info',
				'iconbox-v3',
				'iconbox-v4',
				'iconbox-v5',
				'project-v3',
				'marquee',
				'awards',
				'story',
				'parallax-image',
				'progress-bar',
				'brand-marquee',
				'brand-marquee-v2',
				'brand-title',
				'title-marquee',

				// header
				'01-header',
				'02-header',
				'03-header',
				'04-header',
				'05-header',

				// header
				'01-footer',

			);

			$elementor_widgets = apply_filters('techco_elementor_widget',$elementor_widgets);

			if ( is_array($elementor_widgets) && !empty($elementor_widgets) ) {
				foreach ( $elementor_widgets as $widget ){
					$widget_file = 'plugins/elementor/widget/'.$widget.'.php';
					$template_file = locate_template($widget_file);
					if ( !$template_file || !is_readable( $template_file ) ) {
						$template_file = TECHCO_DIR_PATH.'/elementor/widgets/'.$widget.'.php';
					}
					if ( $template_file && is_readable( $template_file ) ) {
						include_once $template_file;
					}
				}
			}
		}

		public function editor_style(){
			$cs_icon = plugins_url( 'icons.png', __FILE__ );
			wp_add_inline_style( 'elementor-editor', '.elementor-element .icon .techco-custom-icon{content: url( '.$cs_icon.');width: 28px;}' );
		}

		/**
		 * Register additional document controls.
		 *
		 * @param \Elementor\Core\DocumentTypes\PageBase $document The PageBase document instance.
		 */
		public function register_document_controls( $document ) {

			if ( ! $document instanceof \Elementor\Core\DocumentTypes\PageBase || ! $document::get_property( 'has_elements' ) ) {
				return;
			}

			$document->start_controls_section(
				'body_typography',
				[
					'label' => esc_html__( 'Body Typography', 'techco-core' ),
					'tab' => \Elementor\Controls_Manager::TAB_STYLE,
				]
			);

			$document->add_group_control(
				\Elementor\Group_Control_Typography::get_type(),
				[
					'name' => 'page_body_font',
					'selector' => '{{WRAPPER}}',
				]
			);
			$document->add_control(
				'body_color',
				[
					'label' => esc_html__( 'Body Color', 'techco-core' ),
					'type' => \Elementor\Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}}' => 'color: {{VALUE}}',
					],
				]
			);
			$document->add_control(
				'heading_color',
				[
					'label' => esc_html__( 'Heading Color', 'techco-core' ),
					'type' => \Elementor\Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} h1, h2, h3, h4, h5, h6' => 'color: {{VALUE}}',
					],
				]
			);
			$document->add_group_control(
				\Elementor\Group_Control_Typography::get_type(),
				[
					'name' => 'page_heading_font',
					'selector' => '{{WRAPPER}} h1, {{WRAPPER}} h2, {{WRAPPER}} h3, {{WRAPPER}} h4, {{WRAPPER}} h5, {{WRAPPER}} h6',
				]
			);

			$document->end_controls_section();
		}
	}

	if ( class_exists('Techco_Elementor_Widget_Init') ){
		Techco_Elementor_Widget_Init::getInstance();
	}

}//end if