<?php
/**
 * The template for displaying all single posts
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/#single-post
 *
 * @package techco
 */

get_header();
$project_banner = techco_option('enable_project_breadcrumb', true);
$project_breadcrumb_title = techco_option('port_breadcrumb_title');
$banner_text_align = techco_option('banner_default_text_align', 'center');
?>
<?php if ($project_banner == true) : ?>
    <div class="breadcrumb project-banner pos-rel">
        <div class="container">
            <div class="breadcrumb__content text-<?php echo esc_attr($banner_text_align); ?>">
                <h2 class="breadcrumb__title">
                    <?php
                    if (!empty($project_breadcrumb_title)) {
                        echo esc_html($project_breadcrumb_title);
                    } else {
                        the_title();
                    }
                    ?>
                </h2>
                <?php
                if (function_exists('bcn_display') && $project_banner == true) :?>
                    <div class="breadcrumb-container">
                        <?php bcn_display(); ?>
                    </div>
                <?php endif; ?>
            </div>
        </div>
    </div>
<?php endif; ?>
<?php
while (have_posts()) :
    the_post();

    get_template_part('template-parts/content', 'project');


endwhile; // End of the loop.
?>

<?php
get_footer();
