<?php
/**
 * The template for displaying search results pages
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/#search-result
 *
 * @package Techco
 */

get_header();

$search_banner = techco_option('search_banner', true);
$search_layout = techco_option('search_layout', 'right-sidebar');
$banner_text_align = techco_option('banner_default_text_align', 'center');
?>

    <?php if ($search_banner == true) : ?>
        <div class="breadcrumb search-banner pos-rel">
            <div class="container">
                <div class="breadcrumb__content text-<?php echo esc_attr($banner_text_align); ?>">
                    <h2 class="breadcrumb__title"><?php
                        /* translators: %s: search query. */
                        printf(esc_html__('Search Results for: %s', 'techco'), '<span>' . get_search_query() . '</span>');
                        ?>
                    </h2>
                    <?php if (function_exists('bcn_display')) : ?>
                        <div class="breadcrumb-container">
                            <?php bcn_display(); ?>
                        </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    <?php endif; ?>

    <div id="primary" class="content-area pt-120 pb-120 layout-<?php echo esc_attr($search_layout); ?>">
        <div class="container">
            <?php
            if ($search_layout == 'grid') {
                get_template_part('template-parts/post/post-grid');
            } else {
                get_template_part('template-parts/post/post-sidebar');
            }
            ?>
        </div>
    </div><!-- #primary -->

<?php
get_footer();
