<?php


/**
 * Enqueue styles and scripts.
 */
function techco_enqueue_css_and_js() {

    // Enqueue Style
    wp_enqueue_style( 'bootstrap', get_theme_file_uri( 'assets/css/bootstrap.min.css' ), array(), '5.0.', 'all' );

    wp_enqueue_style( 'font-awesome-5', get_theme_file_uri( 'assets/css/fontawesome.css' ), array(), '5.13.0', 'all' );

    wp_enqueue_style( 'e-animations', get_theme_file_uri( 'assets/css/animate.css' ), array(), '3.5.1', 'all' );

    wp_enqueue_style( 'swiper-techco', get_theme_file_uri( 'assets/css/swiper-bundle.min.css' ), array(), '6.6.1', 'all' );

    wp_enqueue_style( 'magnific-popup', get_theme_file_uri( 'assets/css/magnific-popup.css' ), array(), '1.0.0', 'all' );

    wp_enqueue_style( 'odometer', get_theme_file_uri( 'assets/css/odometer.min.css' ), array(), '1.0.0', 'all' );

    wp_enqueue_style( 'cursor', get_theme_file_uri( 'assets/css/cursor.css' ), array(), '1.0.0', 'all' );

    wp_enqueue_style( 'magnific-popup', get_theme_file_uri( 'assets/css/magnific-popup.min.css' ), array(), '3.1.9', 'all' );

    wp_enqueue_style( 'techco-core', get_theme_file_uri( 'assets/css/techco-core.css' ), array(), TECHCO_VERSION, 'all' );

    wp_enqueue_style( 'techco-main', get_theme_file_uri( 'assets/css/style.css' ), array(), TECHCO_VERSION, 'all' );

    wp_enqueue_style( 'techco-style', get_stylesheet_uri(), array(), TECHCO_VERSION, 'all' );

    // Enqueue script
    wp_enqueue_script( 'popper', get_theme_file_uri( 'assets/js/popper.min.js' ), array( 'jquery' ), '2.11.7', true );

    wp_enqueue_script( 'bootstrap', get_theme_file_uri( 'assets/js/bootstrap.min.js' ), array( 'jquery' ), '5.0.0', true );

    wp_enqueue_script( 'bootstrap-dropdown', get_theme_file_uri( 'assets/js/bootstrap-dropdown-ml-hack.min.js' ), array( 'jquery' ), '1.0.0', true );

    wp_enqueue_script( 'swiper-slider', get_theme_file_uri( 'assets/js/swiper-bundle.min.js' ), array( 'jquery' ), '6.7.0', true );

    wp_enqueue_script( 'parallaxie', get_theme_file_uri( 'assets/js/parallaxie.js' ), array( 'jquery' ), '1.0.0', true );

    wp_enqueue_script( 'imagesloaded', get_theme_file_uri( 'assets/js/imagesloaded.pkgd.min.js' ), array( 'jquery' ), '4.1.4', true );

    wp_enqueue_script( 'isotope', get_theme_file_uri( 'assets/js/isotope.pkgd.min.js' ), array( 'jquery' ), '3.0.5', true );

    wp_enqueue_script( 'parallax-scroll', get_theme_file_uri( 'assets/js/parallax-scroll.js' ), array( 'jquery' ), '1.0.0', true );

    wp_enqueue_script( 'wow', get_theme_file_uri( 'assets/js/wow.min.js' ), array( 'jquery' ), '1.1.3', true );

    wp_enqueue_script( 'countdown', get_theme_file_uri( 'assets/js/countdown.js' ), array( 'jquery' ), '1.0.0', true );

    wp_enqueue_script( 'marquee', get_theme_file_uri( 'assets/js/jquery.marquee.min.js' ), array( 'jquery' ), '1.0.0', true );

    wp_enqueue_script( 'cursor-bundle', get_theme_file_uri( 'assets/js/cursor-bundle.js' ), array( 'jquery' ), '1.0.0', true );

    wp_enqueue_script( 'magnific-popup', get_theme_file_uri( 'assets/js/magnific-popup.min.js' ), array( 'jquery' ), '1.1.0', true );

    wp_enqueue_script( 'appear', get_theme_file_uri( 'assets/js/appear.min.js' ), array( 'jquery' ), '1.0.0', true );

    wp_enqueue_script( 'odometer', get_theme_file_uri( 'assets/js/odometer.min.js' ), array( 'jquery' ), '0.4.8', true );

    wp_enqueue_script( 'circularProgressBar', get_theme_file_uri( 'assets/js/circularProgressBar.min.js' ), array( 'jquery' ), '1.0.0', true );

    wp_enqueue_script( 'techco-main', get_theme_file_uri( 'assets/js/main.js' ), array( 'jquery' ), TECHCO_VERSION, true );

    if ( is_singular() && comments_open() && get_option( 'thread_comments' ) ) {
        wp_enqueue_script( 'comment-reply' );
    }
}

add_action( 'wp_enqueue_scripts', 'techco_enqueue_css_and_js' );

/**
 * Enqueue Backend Styles And Scripts.
 **/

function techco_backend_css_js( $screen ) {

    if ( $screen == "widgets.php" ) {
        wp_enqueue_media();
        wp_enqueue_script( 'techco-media-upload', get_theme_file_uri( 'assets/js/media-upload.js' ), array( 'jquery' ), '1.0.0', true );
    }
}

add_action( 'admin_enqueue_scripts', 'techco_backend_css_js' );