<?php
/**
 * This file represents an example of the code that themes would use to register
 * the required plugins.
 *
 * It is expected that theme authors would copy and paste this code into their
 * functions.php file, and amend to suit.
 *
 * @see http://tgmpluginactivation.com/configuration/ for detailed documentation.
 *
 * @package    TGM-Plugin-Activation
 * @subpackage Example
 * @version    2.6.1 for parent theme Techco for publication on ThemeForest
 * @author     Thomas Griffin, Gary Jones, Juliette Reinders Folmer
 * @copyright  Copyright (c) 2011, Thomas Griffin
 * @license    http://opensource.org/licenses/gpl-2.0.php GPL v2 or later
 * @link       https://github.com/TGMPA/TGM-Plugin-Activation
 */

require_once get_template_directory() . '/inc/class-tgm-plugin-activation.php';

add_action('tgmpa_register', 'techco_register_required_plugins');

function techco_register_required_plugins() {
    /*
     * Array of plugin arrays. Required keys are name and slug.
     * If the source is NOT from the .org repo, then source is also required.
     */
    $plugins = array(
        array(
            'name'      => esc_attr__('Techco Core', 'techco'),
            'slug'      => 'techco-core',
            'source'    => get_template_directory_uri() . '/plugin/techco-core.zip',
            'required'  => true,
        ),
        array(
            'name'      => esc_html__('Breadcrumb NavXT', 'techco'),
            'slug'      => 'breadcrumb-navxt',
            'required'  => false,
        ),

        array(
            'name'               => esc_html__('Slider Revolution', 'techco'),
            'slug'               => 'revslider',
            'source'             => 'http://seargin.xpressbuddy.com/plugins/revslider.zip',
            'required'           => true,
        ),

        array(
            'name'      => esc_html__('Envato Market', 'techco'),
            'slug'      => 'envato-market',
            'source'    => esc_url('https://goo.gl/pkJS33'),
            'external_url' => esc_url('https://goo.gl/pkJS33'),
            'required'  => true,
        ),
        array(
            'name'      => esc_html__('Classic Editor', 'techco'),
            'slug'      => 'classic-editor',
            'required'  => false,
        ),
        array(
            'name'      => esc_html__('Contact Form 7', 'techco'),
            'slug'      => 'contact-form-7',
            'required'  => false,
        ),
        array(
            'name'      => esc_html__('Elementor Page Builder', 'techco'),
            'slug'      => 'elementor',
            'required'  => true,
        ),
        array(
            'name'      => esc_html__('One Click Demo Import', 'techco'),
            'slug'      => 'one-click-demo-import',
            'required'  => false,
        ),
        array(
            'name'      => esc_html__('SVG Support', 'techco'),
            'slug'      => 'svg-support',
            'required'  => false,
        ),
    );

    $config = array(
        'id'           => 'techco',                 // Unique ID for hashing notices for multiple instances of TGMPA.
        'default_path' => '',                       // Default absolute path to bundled plugins.
        'menu'         => 'tgmpa-install-plugins',  // Menu slug.
        'has_notices'  => true,                     // Show admin notices or not.
        'dismissable'  => true,                     // If false, a user cannot dismiss the nag message.
        'dismiss_msg'  => '',                       // If 'dismissable' is false, this message will be output at top of nag.
        'is_automatic' => false,                    // Automatically activate plugins after installation or not.
        'message'      => '',                       // Message to output right before the plugins table.
    );

    tgmpa($plugins, $config);
}
?>
