<?php

require_once get_template_directory() . '/inc/theme-setups.php';

$techco_theme_data = wp_get_theme();

/*
 * Define theme version
 */
define('TECHCO_VERSION', (WP_DEBUG) ? time() : $techco_theme_data->get('Version'));

/*
 * Inc folder directory
 */
define('TECHCO_INC_DIR', get_template_directory() . '/inc/');

/*
 * After setup theme
 */
require_once TECHCO_INC_DIR . 'theme-setup.php';

/*
 * Load default theme options
 */
 require_once TECHCO_INC_DIR . 'cs-framework-functions.php';

/*
 * Load meta box and theme options if Codestar framework installed.
 */
if( class_exists( 'CSF' ) ) {
    // require_once TECHCO_INC_DIR . 'metabox-and-options/metabox-and-options.php';
}

/**
 * Template Functions
 */
require TECHCO_INC_DIR . 'template-functions.php';

/*
 * Enqueue styles and scripts.
 */
require_once TECHCO_INC_DIR . 'css-and-js.php';

/*
 * Register widget area
 */
require_once TECHCO_INC_DIR . 'widget-area-init.php';

/**
 * tgmp functions file
 */
require_once TECHCO_INC_DIR . 'class-tgm-plugin-activation.php';
require_once TECHCO_INC_DIR . 'add-plugin.php';

/*
 * Load inline style.
 */
require_once TECHCO_INC_DIR . 'inline-style.php';

/**
 * Implement the Custom Header feature.
 */
require TECHCO_INC_DIR . 'custom-header.php';

/**
 * Custom template tags for this theme.
 */
require TECHCO_INC_DIR . 'class-wp-techco-navwalker.php';

/**
 * techco Core Functions
 */
require TECHCO_INC_DIR . 'techco-helper-class.php';

/**
 * Customizer additions.
 */
require TECHCO_INC_DIR . '/customizer.php';

/**
 * Load Jetpack compatibility file.
 */
if ( defined( 'JETPACK__VERSION' ) ) {
    require TECHCO_INC_DIR . '/jetpack.php';
}

/*
 * Comment Template
 */
require_once TECHCO_INC_DIR . 'comment-template.php';

/*
 * Import Demo Content
 */
require_once TECHCO_INC_DIR . 'demo-content/import-demo-content.php';
