<?php
/**
 * The template for displaying 404 pages (not found)
 *
 * @link https://codex.wordpress.org/Creating_an_Error_404_Page
 *
 * @package Techco
 */

get_header();

$error_banner      = techco_option('error_banner', true);
$error_banner_title = techco_option('error_page_title');
$banner_text_align = techco_option('banner_default_text_align', 'center');
$error_img = techco_option('error_img');
$not_found_text     = techco_option('not_found_text');
$go_back_home       = techco_option('go_back_home', true);

?>

<?php if($error_banner == true) : ?>
    <div class="breadcrumb error-page-banner pos-rel">
        <div class="container">
            <div class="breadcrumb__content text-<?php echo esc_attr( $banner_text_align ); ?>">
                <h2 class="breadcrumb__title">
                    <?php echo esc_html($error_banner_title); ?>
                </h2>

                <?php if ( function_exists( 'bcn_display' ) ) :?>
                    <div class="breadcrumb-container">
                        <?php bcn_display();?>
                    </div>
                <?php endif;?>
            </div>
        </div>
    </div>
<?php endif; ?>

    <div id="primary" class="content-area pt-120 pb-120">
        <div class="container not-found-content">
            <div class="row justify-content-center">
                <div class="col-lg-12">
                    <div class="contant-wrapper text-center">
                        <div class="text-404">
                            <h2><?php esc_html_e( '404', 'techco') ?></h2>
                        </div>
                        <div class="error-page__content mb-50">
                            <?php
                            if (!empty($not_found_text)) {
                                echo wp_kses( $not_found_text, array(
                                    'a'      => array(
                                        'href'   => array(),
                                        'target' => array()
                                    ),
                                    'strong' => array(),
                                    'small'  => array(),
                                    'span'   => array(),
                                    'p'   => array(),
                                    'h1'   => array(),
                                    'h2'   => array(),
                                    'h3'   => array(),
                                    'h4'   => array(),
                                    'h5'   => array(),
                                    'h6'   => array(),
                                ) );
                            }else {
                                ?>
                                <h2><?php esc_html_e( 'Hi 👋 Sorry We Can’t Find That Page!', 'techco') ?></h2>
                                <p><?php esc_html_e( 'Oops! The page you are looking for does not exist. It might have been moved or deleted.', 'techco') ?></p>
                                <?php
                            }
                            ?>

                            <?php if ($go_back_home == true) : ?>
                                <div class="error-page-button">
                                    <a class="btn" href="<?php echo esc_url(home_url('/')); ?>">
                                        <span class="btn_label" data-text="<?php echo esc_attr__('Go Back Home', 'techco') ?>"><?php echo esc_html__('Go Back Home', 'techco') ?></span>
                                        <span class="btn_icon">
                                          <i class="fa-solid fa-arrow-up-right"></i>
                                        </span>
                                    </a>
                                </div>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div><!-- #primary -->

<?php
get_footer();