<?php
if (!function_exists('fpsd_check_is_array')) {

    /**
     * Function to check given a variable is array and not empty
     *
     * @since 1.0
     * @param Array $args Array.
     * @return boolean
     */
    function fpsd_check_is_array($args) {
        return ( is_array($args) && !empty($args) ) ? true : false;
    }

}

// Common Function to add setting for Rule.
if (!function_exists('fpsd_to_add_settings_for_rule')) {

    function fpsd_to_add_settings_for_rule($array) {
        // Discounts Rule Options
        $i = 0;

        wp_localize_script('admin-general', 'admin_general', array(
            'ajax_url' => FP_SD_ADMIN_AJAX_URL,
            'actionforsorting' => $array['actionforsorting'],
            'sorting_nonce' => wp_create_nonce('sumo-discounts-sorting-nonce'),
        ));
        wp_enqueue_script('admin-general');
        wp_enqueue_script('fpsd_date_picker_enhanced');
        ?>
        <div class="sumo_discounts_wrapper">
            <div id="accordion">
                <?php
                $get_saved_data = $array['get_saved_data'];
                if (is_array($get_saved_data) && !empty($get_saved_data)) {
                    foreach ($get_saved_data as $key => $value) {
                        $tab_name = isset($value['sumo_dynamic_rule_name']) ? $value['sumo_dynamic_rule_name'] : '';
                        $rule_name = '' != $tab_name ? $tab_name : '(untitled)';
                        ?>
                        <div class="group sumo_discounts_rule">                            
                            <h3><?php echo esc_html($rule_name); ?>   <span class="sumo_discounts_remove button" title="<?php esc_attr_e('Remove this Rule', 'sumodiscounts'); ?>" >X</span></h3>
                            <div>
                                <?php echo do_shortcode(fpsd_display_data_after_saved($key, $array['pricing_type'], $array['nameforinputfield'])); ?>
                            </div>
                        </div>
                        <?php
                    }
                }
                ?>
            </div>
            <div class="sumo_discount_add button-primary" data-pricing_type="<?php echo esc_attr($array['actionforaddrule']); ?>"data-pricing_type="<?php echo esc_attr($array['pricing_type']); ?>" data-classforaddlocalrule="<?php echo esc_attr($array['classforaddlocalrule']); ?>"><?php esc_html_e('Add Rule', 'sumodiscounts'); ?></div>
        </div>
        <?php
    }

}

// Get the function html to the quantity rule
if (!function_exists('fpsd_local_rule_function')) {

    function fpsd_local_rule_function($array) {       
        $get_list_of_array = fpsd_generate_dynamic_rule_pricing_fields($array['rule_type']);
        $nameforinputfield = $array['nameforinputfield'];
        ob_start();
        foreach ($get_list_of_array as $key => $new_fields) {
            ?>
            <p class="form-field sumo_rule_form" >
                <label>
                    <?php echo esc_html($new_fields['label'][0]); ?>
                </label>
                <span class="dashicons dashicons-info" title="<?php echo esc_attr($new_fields['tooltip'][0]); ?>"></span>
                <?php if ('specialoffer' == $array['rule_type']) { ?>
                    <input type="number" min="0.01" step="0.01" required="required" class="sumo_rule_input"  name="<?php echo esc_attr($nameforinputfield); ?>[<?php echo esc_attr($array['unique_id']); ?>][<?php echo esc_attr($array['nameforfields']); ?>][<?php echo esc_attr($array['phpunique_id']); ?>][<?php echo esc_attr($new_fields['name'][0]); ?>]" value=""/>
                <?php } else { ?>
                    <input type="text" required="required" class="sumo_number_input" name="<?php echo esc_attr($nameforinputfield); ?>[<?php echo esc_attr($array['unique_id']); ?>][<?php echo esc_attr($array['nameforfields']); ?>][<?php echo esc_attr($array['phpunique_id']); ?>][<?php echo esc_attr($new_fields['name'][0]); ?>]" value=""/>
                <?php } ?>
                <label>
                    <?php echo esc_html($new_fields['label'][1]); ?>
                </label>
                <span class="dashicons dashicons-info" title="<?php echo esc_attr($new_fields['tooltip'][1]); ?>"></span>
                <?php if ('specialoffer' == $array['rule_type']) { ?>
                    <input type="number"  min="0.01" step="0.01" required="required" name="<?php echo esc_attr($nameforinputfield); ?>[<?php echo esc_attr($array['unique_id']); ?>][<?php echo esc_attr($array['nameforfields']); ?>][<?php echo esc_attr($array['phpunique_id']); ?>][<?php echo esc_attr($new_fields['name'][1]); ?>]" value=""/>
                <?php } else { ?>
                    <input type="text"  required="required" class="sumo_number_input" name="<?php echo esc_attr($nameforinputfield); ?>[<?php echo esc_attr($array['unique_id']); ?>][<?php echo esc_attr($array['nameforfields']); ?>][<?php echo esc_attr($array['phpunique_id']); ?>][<?php echo esc_attr($new_fields['name'][1]); ?>]" value=""/>
                <?php } ?>
                <label>
                    <?php echo esc_html($new_fields['label'][2]); ?>
                </label>
                <span class="dashicons dashicons-info" title="<?php echo esc_attr($new_fields['tooltip'][2]); ?>"></span>
                <select name="<?php echo esc_attr($nameforinputfield); ?>[<?php echo esc_attr($array['unique_id']); ?>][<?php echo esc_attr($array['nameforfields']); ?>][<?php echo esc_attr($array['phpunique_id']); ?>][<?php echo esc_attr($new_fields['name'][2]); ?>]">
                    <option value="1"><?php esc_html_e('% Discount', 'sumodiscounts'); ?></option>
                    <option value="2"><?php esc_html_e('Fixed Discount', 'sumodiscounts'); ?></option>
                    <option value="3"><?php esc_html_e('Fixed Price', 'sumodiscounts'); ?></option>
                </select>

                <label>
                    <?php echo esc_html($new_fields['label'][3]); ?>
                </label>
                <span class="dashicons dashicons-info" title="<?php echo esc_attr($new_fields['tooltip'][3]); ?>"></span>
                <input type="number" min=".01" step="any" required="required" class="sumo_rule_input" name="<?php echo esc_attr($nameforinputfield); ?>[<?php echo esc_attr($array['unique_id']); ?>][<?php echo esc_attr($array['nameforfields']); ?>][<?php echo esc_attr($array['phpunique_id']); ?>][<?php echo esc_attr($new_fields['name'][3]); ?>]" value=""/>
                <?php if ('specialoffer' == $array['rule_type']) { ?>
                    <input type="checkbox" name="<?php echo esc_attr($nameforinputfield); ?>[<?php echo esc_attr($array['unique_id']); ?>][<?php echo esc_attr($array['nameforfields']); ?>][<?php echo esc_attr($array['phpunique_id']); ?>][<?php echo esc_attr($new_fields['name'][4]); ?>]" value="yes"/>
                    <label>
                        <?php echo esc_html($new_fields['label'][4]); ?>
                    </label>
                    <span class="dashicons dashicons-info" title="<?php echo esc_attr($new_fields['tooltip'][4]); ?>"></span>
                <?php } if ('quantity_pricing' == $array['rule_type']) { ?>
                    <input type="checkbox" name="<?php echo esc_attr($nameforinputfield); ?>[<?php echo esc_attr($array['unique_id']); ?>][<?php echo esc_attr($array['nameforfields']); ?>][<?php echo esc_attr($array['phpunique_id']); ?>][<?php echo esc_attr($new_fields['name'][4]); ?>]" value="yes"/>
                    <label>
                        <b><?php echo esc_html(( $new_fields['label'][4]), 'sumodiscounts'); ?></b><br><br>
                    </label>
                <?php } ?>
                <span class="sumo_delete_row button-secondary"><?php esc_html_e('Delete Row', 'sumodiscounts'); ?></span>
            </p>
            <?php
        }
    }

}

if (!function_exists('fpsd_array_to_field_conversion')) {

    function fpsd_array_to_field_conversion($new_array) {        
        $get_list_of_array = fpsd_generate_dynamic_rule_pricing_fields($new_array['rule_type']);
        $nameforinputfield = $new_array['nameforinputfield'];
        ob_start();
        foreach ($get_list_of_array as $key => $new_fields) {
            switch ($new_fields['type']) {
                case 'text':
                    ?>
                    <p class="form-field">
                        <b><?php esc_html_e($new_fields['label'], 'sumodiscounts'); ?></b>&nbsp;&nbsp;&nbsp;&nbsp;<span class="dashicons dashicons-info" title="<?php echo esc_attr($new_fields['tooltip']); ?>"></span><input name="<?php echo esc_attr($nameforinputfield); ?>[<?php echo esc_attr($new_array['unique_id']); ?>][<?php echo esc_attr($new_fields['name']); ?>]" type="<?php echo esc_attr($new_fields['type']); ?>" value="" placeholder="<?php echo esc_attr($new_fields['placeholder']); ?>"/><br><br>
                    </p>
                    <?php
                    break;
                case 'number':
                    ?>
                    <p class="form-field">
                        <b><?php esc_html_e($new_fields['label'], 'sumodiscounts'); ?></b>&nbsp;&nbsp;&nbsp;&nbsp;<span class="dashicons dashicons-info" title="<?php echo esc_attr($new_fields['tooltip']); ?>"></span><input class="<?php echo esc_attr($new_fields['id']); ?>" name="<?php echo esc_attr($nameforinputfield); ?>[<?php echo esc_attr($new_array['unique_id']); ?>][<?php echo esc_attr($new_fields['name']); ?>]" type="<?php echo esc_attr($new_fields['type']); ?>" value="" step="any" min="0.01" placeholder="<?php echo esc_attr($new_fields['placeholder']); ?>"/><br><br>
                    </p>
                    <?php
                    break;
                case 'title':
                    ?>
                    <br>
                    <p class="form-field">
                        <b><?php esc_html_e($new_fields['label'], 'sumodiscounts'); ?></b>
                    </p>
                    <br>
                    <?php
                    break;
                case 'select':
                    ?>
                    <p class="form-field">
                        <b><?php esc_html_e($new_fields['label'], 'sumodiscounts'); ?></b>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
                        <span class="dashicons dashicons-info" title="<?php echo esc_attr(isset($new_fields['tooltip']) ? $new_fields['tooltip'] : '' ); ?>"></span><select  class="<?php echo esc_attr($new_fields['class']); ?>" id="<?php echo esc_attr($new_fields['id']); ?>" name="<?php echo esc_attr($nameforinputfield); ?>[<?php echo esc_attr($new_array['unique_id']); ?>][<?php echo esc_attr($new_fields['name']); ?>]">
                            <?php
                            foreach ($new_fields['options'] as $key => $options) {
                                ?>
                                <option value="<?php echo esc_attr($key); ?>"><?php echo esc_html($options); ?></option>
                                <?php
                            }
                            ?>
                        </select><br><br>
                    </p>
                    <?php
                    break;
                case 'checkbox':
                    ?>
                    <p class="form-field">
                        <b><?php esc_html_e($new_fields['label'], 'sumodiscounts'); ?></b>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<span class="dashicons dashicons-info" title="<?php echo esc_attr($new_fields['tooltip']); ?>"></span><input type="checkbox" name="<?php echo esc_attr($nameforinputfield); ?>[<?php echo esc_attr($new_array['unique_id']); ?>][<?php echo esc_attr($new_fields['name']); ?>]" value="yes"/><br><br>
                    </p>
                    <?php
                    break;
                case 'datepicker':
                    ?>
                    <p class="form-field sumo_rule_form" >
                        <?php
                        $label_one = $new_fields['label'][0];
                        $label_two = $new_fields['label'][1];

                        $name_one = $new_fields['name'][0];
                        $name_two = $new_fields['name'][1];

                        $tooltip_one = $new_fields['tooltip'][0];
                        $tooltip_two = $new_fields['tooltip'][1];
                        ?>
                        <b><?php esc_html_e($label_one, 'sumodiscounts'); ?></b><span class="dashicons dashicons-info" title="<?php echo esc_attr($tooltip_one); ?>"></span><input type="text" placeholder="dd-mm-yy" class="sp_date sumo_dash_icons_info" name="<?php echo esc_attr($nameforinputfield); ?>[<?php echo esc_attr($new_array['unique_id']); ?>][<?php echo esc_attr($name_one); ?>]" id="from_<?php echo esc_attr($new_array['unique_id']); ?>" />&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;

                        <b><?php esc_html_e($label_two, 'sumodiscounts'); ?></b><span class="dashicons dashicons-info" title="<?php echo esc_attr($tooltip_two); ?>"></span><input type="text" placeholder="dd-mm-yy" class="sp_date sumo_dash_icons_info" name="<?php echo esc_attr($nameforinputfield); ?>[<?php echo esc_attr($new_array['unique_id']); ?>][<?php echo esc_attr($name_two); ?>]" id="to_<?php echo esc_attr($new_array['unique_id']); ?>" />
                    </p>
                    <?php
                    break;
                case 'sumo_uph_datepicker':
                    ?>
                    <p class="form-field sumo_rule_form" >
                        <?php
                        $label_one = $new_fields['label'][0];
                        $label_two = $new_fields['label'][1];

                        $name_one = $new_fields['name'][0];
                        $name_two = $new_fields['name'][1];

                        $tooltip_one = $new_fields['tooltip'][0];
                        $tooltip_two = $new_fields['tooltip'][1];
                        ?>
                        <b><?php esc_html_e($label_one, 'sumodiscounts'); ?></b><span class="dashicons dashicons-info" title="<?php echo esc_attr($tooltip_one); ?>"></span><input type="text" placeholder="yy-mm-dd" class="sp__date sumo_dash_icons_info" name="<?php echo esc_attr($nameforinputfield); ?>[<?php echo esc_attr($new_array['unique_id']); ?>][<?php echo esc_attr($name_one); ?>]" id="sumo_uph_from_datepicker" />&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;

                        <b><?php esc_html_e($label_two, 'sumodiscounts'); ?></b><span class="dashicons dashicons-info" title="<?php echo esc_attr($tooltip_two); ?>"></span><input type="text" placeholder="yy-mm-dd" class="sp__date sumo_dash_icons_info" name="<?php echo esc_attr($nameforinputfield); ?>[<?php echo esc_attr($new_array['unique_id']); ?>][<?php echo esc_attr($name_two); ?>]" id="sumo_uph_to_datepicker" />
                    </p>
                    <?php
                    break;
                case 'weekdays':
                    $label_name = $new_fields['label'];
                    $option_name = $new_fields['name'];
                    $title_name = $new_fields['week_days_title'];
                    $week_tooltip = $new_fields['tooltip'];
                    ?>
                    <p class="form-field">
                        <label><?php esc_html_e($title_name, 'sumodiscounts'); ?><span class="dashicons dashicons-info" title="<?php echo esc_attr($week_tooltip); ?>"></span></label>

                        <?php
                        foreach ($option_name as $key => $eachname) {
                            ?>
                            <input type="checkbox" name="<?php echo esc_attr($nameforinputfield); ?>[<?php echo esc_attr($new_array['unique_id']); ?>][<?php echo esc_attr($eachname); ?>]" value="1" checked="checked"/> <?php echo esc_attr($new_fields['label'][$key]); ?><br>
                            <?php
                        }
                        ?>
                    </p>
                    <?php
                    break;
                case 'multiselectincuser':
                    global $woocommerce;
                    ?>
                    <p class="form-field">
                        <label>
                            <?php esc_html_e($new_fields['label'], 'sumodiscounts'); ?>
                        </label>
                        <?php if ((float) $woocommerce->version <= (float) ( '2.2.0' )) { ?>
                            <span class="dashicons dashicons-info" title="<?php echo esc_attr($new_fields['tooltip']); ?>"></span><select class="<?php echo esc_attr($new_fields['class']); ?>" name="<?php echo esc_attr($nameforinputfield); ?>[<?php echo esc_attr($new_array['unique_id']); ?>][<?php echo esc_attr($new_fields['name']); ?>][]" multiple="multiple" id="<?php echo esc_attr($new_fields['id']); ?>">
                            </select>
                        <?php } else { ?>
                            <span class="dashicons dashicons-info" title="<?php echo esc_attr($new_fields['tooltip']); ?>"></span>
                            <?php
                            $name = $nameforinputfield . '[' . $new_array['unique_id'] . '][' . $new_fields['name'] . ']';
                            $id = $new_fields['id'];
                            fpsd_customer_search($name, $id);
                        }
                        ?>
                    </p>
                    <?php
                    break;

                case 'multiselectexcuser':
                    global $woocommerce;
                    ?>
                    <p class="form-field">
                        <b>
                            <?php esc_html_e($new_fields['label'], 'sumodiscounts'); ?>
                        </b>
                        <?php if ((float) $woocommerce->version <= (float) ( '2.2.0' )) { ?>
                            <span class="dashicons dashicons-info" title="<?php echo esc_attr($new_fields['tooltip']); ?>"></span><select class="<?php echo esc_attr($new_fields['class']); ?>" name="<?php echo esc_attr($nameforinputfield); ?>[<?php echo esc_attr($new_array['unique_id']); ?>][<?php echo esc_attr($new_fields['name']); ?>][]"  multiple="multiple" id="<?php echo esc_attr($new_fields['id']); ?>">
                            </select>
                        <?php } else { ?>
                            <span class="dashicons dashicons-info" title="<?php echo esc_attr($new_fields['tooltip']); ?>"></span>
                            <?php
                            $name = $nameforinputfield . '[' . $new_array['unique_id'] . '][' . $new_fields['name'] . ']';
                            $id = $new_fields['id'];
                            fpsd_customer_search($name, $id);
                        }
                        ?>
                    </p>
                    <?php
                    break;

                case 'multiselect':
                    global $woocommmerce;
                    ?>
                    <p class="form-field">
                        <b>
                            <?php esc_html_e($new_fields['label'], 'sumodiscounts'); ?>
                        </b>
                        <span class="dashicons dashicons-info" title="<?php echo esc_attr($new_fields['tooltip']); ?>"></span><select class="<?php echo esc_attr($new_fields['class']); ?>" name="<?php echo esc_attr($nameforinputfield); ?>[<?php echo esc_attr($new_array['unique_id']); ?>][<?php echo esc_attr($new_fields['name']); ?>][]" id="<?php echo esc_attr($new_fields['class']); ?>" multiple="multiple">
                            <?php
                            if (is_array($new_fields['options'])) {
                                if (!empty($new_fields['options'])) {
                                    foreach ($new_fields['options'] as $key => $options) {
                                        ?>
                                        <option value="<?php echo esc_attr($key); ?>" 
                                        <?php
                                        if (isset($get_data[$new_fields['name']])) {
                                            foreach ($get_data[$new_fields['name']] as $value) {
                                                echo selected($key, $value);
                                            }
                                        }
                                        ?>
                                                ><?php echo esc_html($options); ?></option>
                                                <?php
                                            }
                                        }
                                    }
                                    ?>
                        </select>
                    </p>
                    <?php
                    break;

                case 'multiselect1':
                    global $woocommmerce;
                    ?>
                    <p class="form-field">
                        <b>
                            <?php esc_html_e($new_fields['label'], 'sumodiscounts'); ?>
                        </b>
                        <span class="dashicons dashicons-info" title="<?php echo esc_attr($new_fields['tooltip']); ?>"></span><select class="<?php echo esc_attr($new_fields['class']); ?>" name="<?php echo esc_attr($nameforinputfield); ?>[<?php echo esc_attr($new_array['unique_id']); ?>][<?php echo esc_attr($new_fields['name']); ?>][]" id="<?php echo esc_attr($new_fields['class']); ?>" multiple="multiple">
                            <?php
                            foreach ($new_fields['options'] as $key => $options) {
                                ?>
                                <option value="<?php echo esc_attr($key); ?>" 
                                <?php
                                if (isset($get_data[$new_fields['name']])) {
                                    foreach ($get_data[$new_fields['name']] as $value) {
                                        echo selected($key, $value);
                                    }
                                }
                                ?>
                                        ><?php echo esc_html($options); ?></option>
                                        <?php
                                    }
                                    ?>
                        </select>
                    </p>
                    <?php
                    break;
                case 'multiselectincproduct':
                    global $woocommerce;
                    ?>
                    <p class="form-field">
                        <label>
                            <?php esc_html_e($new_fields['label'], 'sumodiscounts'); ?>
                        </label>
                        <?php if ((float) $woocommerce->version <= (float) ( '2.2.0' )) { ?>
                            <span class="dashicons dashicons-info" title="<?php echo esc_attr($new_fields['tooltip']); ?>"></span><select class="<?php echo esc_attr($new_fields['class']); ?>" name="<?php echo esc_attr($nameforinputfield); ?>[<?php echo esc_attr($new_array['unique_id']); ?>][<?php echo esc_attr($new_fields['name']); ?>][]"  multiple="multiple" id="<?php echo esc_attr($new_fields['id']); ?>">
                            </select>
                        <?php } else { ?>
                            <span class="dashicons dashicons-info" title="<?php echo esc_attr($new_fields['tooltip']); ?>"></span>
                            <?php
                            $add_array = (float) WC()->version < (float) '3.0.0' ? '' : '[]';
                            $name = $nameforinputfield . '[' . $new_array['unique_id'] . '][' . $new_fields['name'] . ']' . $add_array;
                            $id = $new_fields['id'];
                            fpsd_product_search($name, $id);
                            ?>
                        <?php } ?>
                    </p>
                    <?php
                    break;
                case 'multiselectfreeproduct_soat':
                    global $woocommerce;
                    ?>
                    <p class="form-field">
                        <label>
                            <?php esc_html_e($new_fields['label'], 'sumodiscounts'); ?>
                        </label>
                        <?php if ((float) $woocommerce->version <= (float) ( '2.2.0' )) { ?>
                            <span class="dashicons dashicons-info" title="<?php echo esc_attr($new_fields['tooltip']); ?>"></span><select class="<?php echo esc_attr($new_fields['class']); ?>" name="<?php echo esc_attr($nameforinputfield); ?>[<?php echo esc_attr($new_array['unique_id']); ?>][<?php echo esc_attr($new_fields['name']); ?>]"  id="<?php echo esc_attr($new_fields['id']); ?>">                                                                
                            </select>
                        <?php } else { ?>
                            <span class="dashicons dashicons-info" title="<?php echo esc_attr($new_fields['tooltip']); ?>"></span>
                            <?php
                            $name = $nameforinputfield . '[' . $new_array['unique_id'] . '][' . $new_fields['name'] . ']';
                            $id = $new_fields['id'];
                            fpsd_product_search($name, $id, false);
                        }
                        ?>
                    </p>
                    <?php
                    break;
                case 'multiselectincproduct_soat':
                    global $woocommerce;
                    ?>
                    <p class="form-field">
                        <label>
                            <?php esc_html_e($new_fields['label'], 'sumodiscounts'); ?>
                        </label>
                        <?php if ((float) $woocommerce->version <= (float) ( '2.2.0' )) { ?>
                            <span class="dashicons dashicons-info" title="<?php echo esc_attr($new_fields['tooltip']); ?>"></span><select class="<?php echo esc_attr($new_fields['class']); ?>" name="<?php echo esc_attr($nameforinputfield); ?>[<?php echo esc_attr($new_array['unique_id']); ?>][<?php echo esc_attr($new_fields['name']); ?>][]"  multiple="multiple" id="<?php echo esc_attr($new_fields['id']); ?>">
                            </select>
                        <?php } else { ?>
                            <span class="dashicons dashicons-info" title="<?php echo esc_attr($new_fields['tooltip']); ?>"></span>
                            <?php
                            $add_array = (float) WC()->version < (float) '3.0.0' ? '' : '[]';
                            $name = $nameforinputfield . '[' . $new_array['unique_id'] . '][' . $new_fields['name'] . ']' . $add_array;
                            $id = $new_fields['id'];
                            fpsd_product_search($name, $id);
                        }
                        ?>
                    </p>
                    <?php
                    break;

                case 'multiselectexcproduct':
                    global $woocommerce;
                    ?>
                    <p class="form-field">
                        <b>
                            <?php esc_html_e($new_fields['label'], 'sumodiscounts'); ?>
                        </b>
                        <?php if ((float) $woocommerce->version <= (float) ( '2.2.0' )) { ?>
                            <span class="dashicons dashicons-info" title="<?php echo esc_attr($new_fields['tooltip']); ?>"></span><select class="<?php echo esc_attr($new_fields['class']); ?>" name="<?php echo esc_attr($nameforinputfield); ?>[<?php echo esc_attr($new_array['unique_id']); ?>][<?php echo esc_attr($new_fields['name']); ?>][]"  multiple="multiple" id="<?php echo esc_attr($new_fields['id']); ?>">
                            </select>
                        <?php } else { ?>
                            <span class="dashicons dashicons-info" title="<?php echo esc_attr($new_fields['tooltip']); ?>"></span>
                            <?php
                            $add_array = (float) WC()->version < (float) '3.0.0' ? '' : '[]';
                            $name = $nameforinputfield . '[' . $new_array['unique_id'] . '][' . $new_fields['name'] . ']' . $add_array;
                            $id = $new_fields['id'];
                            fpsd_product_search($name, $id);
                        }
                        ?>
                    </p>
                    <?php
                    break;

                case 'multiselectexcproduct_soat':
                    global $woocommerce;
                    ?>
                    <p class="form-field">
                        <b>
                            <?php esc_html_e($new_fields['label'], 'sumodiscounts'); ?>
                        </b>
                        <?php if ((float) $woocommerce->version <= (float) ( '2.2.0' )) { ?>
                            <span class="dashicons dashicons-info" title="<?php echo esc_attr($new_fields['tooltip']); ?>"></span><select class="<?php echo esc_attr($new_fields['class']); ?>" name="<?php echo esc_attr($nameforinputfield); ?>[<?php echo esc_attr($new_array['unique_id']); ?>][<?php echo esc_attr($new_fields['name']); ?>][]"  multiple="multiple" id="<?php echo esc_attr($new_fields['id']); ?>">
                            </select>
                        <?php } else { ?>
                            <span class="dashicons dashicons-info" title="<?php echo esc_attr($new_fields['tooltip']); ?>"></span>
                            <?php
                            $add_array = (float) WC()->version < (float) '3.0.0' ? '' : '[]';
                            $name = $nameforinputfield . '[' . $new_array['unique_id'] . '][' . $new_fields['name'] . ']' . $add_array;
                            $id = $new_fields['id'];
                            fpsd_product_search($name, $id);
                        }
                        ?>
                    </p>
                    <?php
                    break;
                case 'multiselectincproductapplyon':
                    global $woocommerce;
                    ?>
                    <p class="form-field">
                        <b>
                            <?php esc_html_e($new_fields['label'], 'sumodiscounts'); ?>
                        </b>
                        <?php if ((float) $woocommerce->version <= (float) ( '2.2.0' )) { ?>
                            <span class="dashicons dashicons-info" title="<?php echo esc_attr($new_fields['tooltip']); ?>"></span><select class="<?php echo esc_attr($new_fields['class']); ?>" name="<?php echo esc_attr($nameforinputfield); ?>[<?php echo esc_attr($new_array['unique_id']); ?>][<?php echo esc_attr($new_fields['name']); ?>]"  id="<?php echo esc_attr($new_fields['id']); ?>">
                            </select>
                        <?php } else { ?>
                            <span class="dashicons dashicons-info" title="<?php echo esc_attr($new_fields['tooltip']); ?>"></span>
                            <?php
                            $add_array = (float) WC()->version < (float) '3.0.0' ? '' : '[]';
                            $name = $nameforinputfield . '[' . $new_array['unique_id'] . '][' . $new_fields['name'] . ']' . $add_array;
                            $id = $new_fields['id'];
                            fpsd_product_search($name, $id);
                        }
                        ?>
                    </p>
                    <?php
                    break;

                case 'multiselectexcproductapplyon':
                    global $woocommerce;
                    ?>
                    <p class="form-field">
                        <b>
                            <?php echo esc_html($new_fields['label']); ?>
                        </b>
                        <?php if ((float) $woocommerce->version <= (float) ( '2.2.0' )) { ?>
                            <span class="dashicons dashicons-info" title="<?php echo esc_attr($new_fields['tooltip']); ?>"></span><select class="<?php echo esc_attr($new_fields['class']); ?>" name="<?php echo esc_attr($nameforinputfield); ?>[<?php echo esc_attr($new_array['unique_id']); ?>][<?php echo esc_attr($new_fields['name']); ?>][]"  multiple="multiple" id="<?php echo esc_attr($new_fields['id']); ?>">
                            </select>
                        <?php } else { ?>
                            <span class="dashicons dashicons-info" title="<?php echo esc_attr($new_fields['tooltip']); ?>"></span>
                            <?php
                            $add_array = (float) WC()->version < (float) '3.0.0' ? '' : '[]';
                            $name = $nameforinputfield . '[' . $new_array['unique_id'] . '][' . $new_fields['name'] . ']' . $add_array;
                            $id = $new_fields['id'];
                            fpsd_product_search($name, $id);
                        }
                        ?>
                    </p>
                    <?php
                    break;
                case 'multiselectinccategory':
                    global $woocommmerce;
                    ?>
                    <p class="form-field">
                        <b>
                            <?php echo esc_html($new_fields['label']); ?>
                        </b>
                        <span class="dashicons dashicons-info" title="<?php echo esc_attr($new_fields['tooltip']); ?>"></span><select  class="<?php echo esc_attr($new_fields['class']); ?> sumo_multiselect_cat" name="<?php echo esc_attr($nameforinputfield); ?>[<?php echo esc_attr($new_array['unique_id']); ?>][<?php echo esc_attr($new_fields['name']); ?>][]" id="<?php echo esc_attr($new_fields['id']); ?>" multiple="multiple">
                            <?php
                            if (is_array($new_fields['options'])) {
                                if (!empty($new_fields['options'])) {
                                    foreach ($new_fields['options'] as $key => $options) {
                                        ?>
                                        <option value="<?php echo esc_attr($key); ?>" 
                                        <?php
                                        if (isset($get_data[$new_fields['name']])) {
                                            foreach ($get_data[$new_fields['name']] as $value) {
                                                echo selected($key, $value);
                                            }
                                        }
                                        ?>
                                                ><?php echo esc_html($options); ?></option>
                                                <?php
                                            }
                                        }
                                    }
                                    ?>
                        </select>
                    </p>
                    <?php
                    break;

                case 'multiselectexccategory':
                    global $woocommmerce;
                    ?>
                    <p class="form-field">
                        <b>
                            <?php echo esc_html($new_fields['label']); ?>
                        </b>
                        <span class="dashicons dashicons-info" title="<?php echo esc_attr($new_fields['tooltip']); ?>"></span><select  class="<?php echo esc_attr($new_fields['class']); ?> sumo_multiselect_cat" name="<?php echo esc_attr($nameforinputfield); ?>[<?php echo esc_attr($new_array['unique_id']); ?>][<?php echo esc_attr($new_fields['name']); ?>][]" id="<?php echo esc_attr($new_fields['id']); ?>" multiple="multiple">
                            <?php
                            foreach ($new_fields['options'] as $key => $options) {
                                ?>
                                <option value="<?php echo esc_attr($key); ?>" 
                                <?php
                                if (isset($get_data[$new_fields['name']])) {
                                    foreach ($get_data[$new_fields['name']] as $value) {
                                        echo selected($key, $value);
                                    }
                                }
                                ?>
                                        ><?php echo esc_html($options); ?></option>
                                        <?php
                                    }
                                    ?>
                        </select>
                    </p>
                    <?php
                    break;
                case 'multiselectinctag':
                    global $woocommmerce;
                    ?>
                    <p class="form-field">
                        <b>
                            <?php echo esc_html($new_fields['label']); ?>
                        </b>
                        <span class="dashicons dashicons-info" title="<?php echo esc_attr($new_fields['tooltip']); ?>"></span><select  class="<?php echo esc_attr($new_fields['class']); ?> sumo_multiselect_cat" name="<?php echo esc_attr($nameforinputfield); ?>[<?php echo esc_attr($new_array['unique_id']); ?>][<?php echo esc_attr($new_fields['name']); ?>][]" id="<?php echo esc_attr($new_fields['id']); ?>" multiple="multiple">
                            <?php
                            foreach ($new_fields['options'] as $key => $options) {
                                ?>
                                <option value="<?php echo esc_attr($key); ?>" 
                                <?php
                                if (isset($get_data[$new_fields['name']])) {
                                    foreach ($get_data[$new_fields['name']] as $value) {
                                        echo selected($key, $value);
                                    }
                                }
                                ?>
                                        ><?php echo esc_html($options); ?></option>
                                        <?php
                                    }
                                    ?>
                        </select>
                    </p>
                    <?php
                    break;
                case 'multiselectexctag':
                    global $woocommmerce;
                    ?>
                    <p class="form-field">
                        <b>
                            <?php echo esc_html($new_fields['label']); ?>
                        </b>
                        <span class="dashicons dashicons-info" title="<?php echo esc_attr($new_fields['tooltip']); ?>"></span><select  class="<?php echo esc_attr($new_fields['class']); ?> sumo_multiselect_cat" name="<?php echo esc_attr($nameforinputfield); ?>[<?php echo esc_attr($new_array['unique_id']); ?>][<?php echo esc_attr($new_fields['name']); ?>][]" id="<?php echo esc_attr($new_fields['id']); ?>" multiple="multiple">
                            <?php
                            foreach ($new_fields['options'] as $key => $options) {
                                ?>
                                <option value="<?php echo esc_attr($key); ?>" 
                                <?php
                                if (isset($get_data[$new_fields['name']])) {
                                    foreach ($get_data[$new_fields['name']] as $value) {
                                        echo selected($key, $value);
                                    }
                                }
                                ?>
                                        ><?php echo esc_html($options); ?></option>
                                        <?php
                                    }
                                    ?>
                        </select>
                    </p>
                    <?php
                    break;

                case 'multiselectincmemberplans':
                    if (class_exists('SUMOMemberships') && sumo_get_membership_levels()) {
                        global $woocommerce;
                        ?>
                        <p class="form-field">
                            <b>
                                <?php esc_html_e($new_fields['label'], 'sumodiscounts'); ?>
                            </b>
                            <?php
                            if ((float) WC()->version < (float) '3.0.0') {
                                ?>
                                <span class="dashicons dashicons-info" title="<?php echo esc_attr($new_fields['tooltip']); ?>"></span>
                                <input type="text" class="<?php echo esc_attr($new_fields['class']); ?> sumomembership_plans_select" name="<?php echo esc_attr($nameforinputfield); ?>[<?php echo esc_attr($new_array['unique_id']); ?>][<?php echo esc_attr($new_fields['name']); ?>]"  id="<?php echo esc_attr($new_fields['id']); ?>"/>

                            <?php } else { ?>
                                <span class="dashicons dashicons-info" title="<?php echo esc_attr($new_fields['tooltip']); ?>"></span>
                                <?php
                                $add_array = (float) WC()->version < (float) '3.0.0' ? '' : '[]';
                                $name = $nameforinputfield . '[' . $new_array['unique_id'] . '][' . $new_fields['name'] . ']' . $add_array;                                
                                $id = $new_fields['id'];                                
                                ?>
                                <select name="<?php echo esc_attr($name); ?>" class="sumomembership_plans_select sumo_select_plans" multiple="multiple" id="<?php echo esc_attr($id); ?>" ></select>
                                <?php
                            }
                            ?>
                        </p>
                        <?php
                    }
                    break;
                    case 'multiselectexcmemberplans':
                    if (class_exists('SUMOMemberships') && sumo_get_membership_levels()) {
                        global $woocommerce;
                        ?>
                        <p class="form-field">
                            <b>
                                <?php esc_html_e($new_fields['label'], 'sumodiscounts'); ?>
                            </b>
                            <?php
                            if ((float) WC()->version < (float) '3.0.0') {
                                ?>
                                <span class="dashicons dashicons-info" title="<?php echo esc_attr($new_fields['tooltip']); ?>"></span>
                                <input type="text" class="<?php echo esc_attr($new_fields['class']); ?> sumomembership_plans_select" name="<?php echo esc_attr($nameforinputfield); ?>[<?php echo esc_attr($new_array['unique_id']); ?>][<?php echo esc_attr($new_fields['name']); ?>]"  id="<?php echo esc_attr($new_fields['id']); ?>"/>

                            <?php } else { ?>
                                <span class="dashicons dashicons-info" title="<?php echo esc_attr($new_fields['tooltip']); ?>"></span>
                                <?php
                                $add_array = (float) WC()->version < (float) '3.0.0' ? '' : '[]';
                                $name = $nameforinputfield . '[' . $new_array['unique_id'] . '][' . $new_fields['name'] . ']' . $add_array;
                                $id = $new_fields['id'];
                                ?>
                                <select name="<?php echo esc_attr($name); ?>" class="sumomembership_plans_select sumo_select_plans" multiple="multiple" id="<?php echo esc_attr($id); ?>" ></select>
                                <?php
                            }
                            ?>
                        </p>
                        <?php
                    }
                    break;
                case 'quantity_pricing':
                    $label_name = $new_fields['label'];
                    $option_name = $new_fields['name'];
                    ?>
                    <div class="sumo_quantity_rule">
                        <p class="form-field sumo_rule_form" >
                            <label>
                                <?php echo esc_html($new_fields['label'][0]); ?>
                            </label>

                            <span class="dashicons dashicons-info" title="<?php echo esc_attr($new_fields['tooltip'][0]); ?>"></span><input type="text" class="sumo_number_input" required="required" name="<?php echo esc_attr($nameforinputfield); ?>[<?php echo esc_attr($new_array['unique_id']); ?>][<?php echo esc_attr($new_array['nameforfields']); ?>][<?php echo esc_attr($new_array['phpunique_id']); ?>][<?php echo esc_attr($new_fields['name'][0]); ?>]" value=""/>

                            <label>
                                <?php echo esc_html($new_fields['label'][1]); ?>
                            </label>
                            <span class="dashicons dashicons-info" title="<?php echo esc_attr($new_fields['tooltip'][1]); ?>"></span><input type="text" class="sumo_number_input" required="required" name="<?php echo esc_attr($nameforinputfield); ?>[<?php echo esc_attr($new_array['unique_id']); ?>][<?php echo esc_attr($new_array['nameforfields']); ?>][<?php echo esc_attr($new_array['phpunique_id']); ?>][<?php echo esc_attr($new_fields['name'][1]); ?>]" value=""/>

                            <label>
                                <?php echo esc_html($new_fields['label'][2]); ?>
                            </label>

                            <span class="dashicons dashicons-info" title="<?php echo esc_attr($new_fields['tooltip'][2]); ?>"></span><select name="<?php echo esc_attr($nameforinputfield); ?>[<?php echo esc_attr($new_array['unique_id']); ?>][<?php echo esc_attr($new_array['nameforfields']); ?>][<?php echo esc_attr($new_array['phpunique_id']); ?>][<?php echo esc_attr($new_fields['name'][2]); ?>]">
                                <option value="1"><?php esc_html_e('% Discount', 'sumodiscounts'); ?></option>
                                <option value="2"><?php esc_html_e('Fixed Discount', 'sumodiscounts'); ?></option>
                                <option value="3"><?php esc_html_e('Fixed Price', 'sumodiscounts'); ?></option>
                            </select>

                            <label>
                                <?php echo esc_html($new_fields['label'][3]); ?>
                            </label>

                            <span class="dashicons dashicons-info sumo_number_input" title="<?php echo esc_attr($new_fields['tooltip'][3]); ?>"></span><input type="number" min=".01" step="any" required="required"  name="<?php echo esc_attr($nameforinputfield); ?>[<?php echo esc_attr($new_array['unique_id']); ?>][<?php echo esc_attr($new_array['nameforfields']); ?>][<?php echo esc_attr($new_array['phpunique_id']); ?>][<?php echo esc_attr($new_fields['name'][3]); ?>]" value=""/>
                            <input type="checkbox" name="<?php echo esc_attr($nameforinputfield); ?>[<?php echo esc_attr($new_array['unique_id']); ?>][<?php echo esc_attr($new_array['nameforfields']); ?>][<?php echo esc_attr($new_array['phpunique_id']); ?>][<?php echo esc_attr($new_fields['name'][4]); ?>]" value="yes"/>
                            <label>
                                <b><?php esc_html_e($new_fields['label'][4], 'sumodiscounts'); ?></b><br><br>
                            </label>
                            <span class="dashicons dashicons-info" title="<?php echo esc_attr(isset($new_fields['tooltip'][5]) ? $new_fields['tooltip'][5] : '' ); ?>"></span>
                            <span class="sumo_delete_row button-secondary"><?php esc_html_e('Delete Row', 'sumodiscounts'); ?></span>
                        </p>

                    </div>
                    <span class="add_new_row_for_quantity button-primary" data-uniq_id="<?php echo esc_attr($new_array['unique_id']); ?>"><?php esc_html_e('Add New Row', 'sumodiscounts'); ?></span>
                    <?php
                    break;
                case 'offer_pricing':
                    $label_name = $new_fields['label'];
                    $option_name = $new_fields['name'];
                    ?>
                    <div class="sumo_offer_rule">
                        <p class="form-field sumo_rule_form" >
                            <label>
                                <?php echo esc_html($new_fields['label'][0]); ?>
                            </label>
                            <input type="number" min="1" step="1" required="required" class="sumo_number_input" name="<?php echo esc_attr($nameforinputfield); ?>[<?php echo esc_attr($new_array['unique_id']); ?>][<?php echo esc_attr($new_array['nameforfields']); ?>][<?php echo esc_attr($new_array['phpunique_id']); ?>][<?php echo esc_attr($new_fields['name'][0]); ?>]" value=""/>

                            <label>
                                <?php echo esc_html($new_fields['label'][1]); ?>
                            </label>
                            <input type="number" min="1" step="1" required="required"  class="sumo_number_input" name="<?php echo esc_attr($nameforinputfield); ?>[<?php echo esc_attr($new_array['unique_id']); ?>][<?php echo esc_attr($new_array['nameforfields']); ?>][<?php echo esc_attr($new_array['phpunique_id']); ?>][<?php echo esc_attr($new_fields['name'][1]); ?>]" value=""/>

                            <label>
                                <?php echo esc_html($new_fields['label'][2]); ?>
                            </label>
                            <select name="<?php echo esc_attr($nameforinputfield); ?>[<?php echo esc_attr($new_array['unique_id']); ?>][<?php echo esc_attr($new_array['nameforfields']); ?>][<?php echo esc_attr($new_array['phpunique_id']); ?>][<?php echo esc_attr($new_fields['name'][2]); ?>]">
                                <option value="1"><?php esc_html_e('% Discount', 'sumodiscounts'); ?></option>
                                <option value="2"><?php esc_html_e('Fixed Discount', 'sumodiscounts'); ?></option>
                                <option value="3"><?php esc_html_e('Fixed Price', 'sumodiscounts'); ?></option>
                            </select>

                            <label>
                                <?php echo esc_html($new_fields['label'][3]); ?>
                            </label>

                            <input type="number" min=".01" step="any" required="required"  class="sumo_number_input"  name="<?php echo esc_attr($nameforinputfield); ?>[<?php echo esc_attr($new_array['unique_id']); ?>][<?php echo esc_attr($new_array['nameforfields']); ?>][<?php echo esc_attr($new_array['phpunique_id']); ?>][<?php echo esc_attr($new_fields['name'][3]); ?>]" value=""/>

                            <input type="checkbox" name="<?php echo esc_attr($nameforinputfield); ?>[<?php echo esc_attr($new_array['unique_id']); ?>][<?php echo esc_attr($new_array['nameforfields']); ?>][<?php echo esc_attr($new_array['phpunique_id']); ?>][<?php echo esc_attr($new_fields['name'][4]); ?>]" value="yes"/>
                            <label>
                                <?php echo esc_html($new_fields['label'][4]); ?>
                            </label>
                            <span class="sumo_delete_row button-secondary"><?php esc_html_e('Delete Row', 'sumodiscounts'); ?></span>
                        </p>

                    </div>
                    <span class="add_new_row_for_offer button-primary" data-uniq_id="<?php echo esc_attr($new_array['unique_id']); ?>"><?php esc_html_e('Add New Row', 'sumodiscounts'); ?></span>

                    <?php
                    break;
                case 'cart_total_pricing':
                    $label_name = $new_fields['label'];
                    $option_name = $new_fields['name'];
                    ?>
                    <div class="sumo_cart_total_rule">
                        <p class="form-field sumo_rule_form" 
                           <label>
                                   <?php echo esc_html($new_fields['label'][0]); ?>
                            </label>
                            <span class="dashicons dashicons-info" title="<?php echo esc_attr($new_fields['tooltip'][0]); ?>"></span><input type="text" class="sumo_number_input" required="required"   name="<?php echo esc_attr($nameforinputfield); ?>[<?php echo esc_attr($new_array['unique_id']); ?>][<?php echo esc_attr($new_array['nameforfields']); ?>][<?php echo esc_attr($new_array['phpunique_id']); ?>][<?php echo esc_attr($new_fields['name'][0]); ?>]" value=""/>

                            <label>
                                <?php echo esc_html($new_fields['label'][1]); ?>
                            </label>
                            <span class="dashicons dashicons-info" title="<?php echo esc_attr($new_fields['tooltip'][1]); ?>"></span><input type="text" class="sumo_number_input" required="required"  name="<?php echo esc_attr($nameforinputfield); ?>[<?php echo esc_attr($new_array['unique_id']); ?>][<?php echo esc_attr($new_array['nameforfields']); ?>][<?php echo esc_attr($new_array['phpunique_id']); ?>][<?php echo esc_attr($new_fields['name'][1]); ?>]" value=""/>

                            <label>
                                <?php echo esc_html($new_fields['label'][2]); ?>
                            </label>
                            <span class="dashicons dashicons-info " title="<?php echo esc_attr($new_fields['tooltip'][2]); ?>"></span><select name="<?php echo esc_attr($nameforinputfield); ?>[<?php echo esc_attr($new_array['unique_id']); ?>][<?php echo esc_attr($new_array['nameforfields']); ?>][<?php echo esc_attr($new_array['phpunique_id']); ?>][<?php echo esc_attr($new_fields['name'][2]); ?>]">
                                <option value="1"><?php esc_html_e('% Discount', 'sumodiscounts'); ?></option>
                                <option value="2"><?php esc_html_e('Fixed Discount', 'sumodiscounts'); ?></option>
                            </select>

                            <label>
                                <?php echo esc_html($new_fields['label'][3]); ?>
                            </label>

                            <span class="dashicons dashicons-info sumo_number_input" title="<?php echo esc_attr($new_fields['tooltip'][3]); ?>"></span><input type="number" step="any" required="required" min=".01" name="<?php echo esc_attr($nameforinputfield); ?>[<?php echo esc_attr($new_array['unique_id']); ?>][<?php echo esc_attr($new_array['nameforfields']); ?>][<?php echo esc_attr($new_array['phpunique_id']); ?>][<?php echo esc_attr($new_fields['name'][3]); ?>]" value=""/>

                            <span class="sumo_delete_row button-secondary"><?php esc_html_e('Delete Row', 'sumodiscounts'); ?></span>
                        </p>

                    </div>
                    <span class="add_new_row_for_cart_total button-primary" data-uniq_id="<?php echo esc_attr($new_array['unique_id']); ?>"><?php esc_html_e('Add New Row', 'sumodiscounts'); ?></span>

                    <?php
                    break;
            }
        }

        $get_data = ob_get_clean();
        return $get_data;
    }

}

if (!function_exists('fpsd_generate_dynamic_rule_pricing_fields')) {

    function fpsd_generate_dynamic_rule_pricing_fields($ruletype) {
        $categorylist = array();
        $categoryname = array();
        $categoryid = array();
        $userroleslug = array();
        $userrolename = array();
        $newcombineduserrole = array();
        global $wp_roles;
        foreach ($wp_roles->roles as $values => $key) {
            $userroleslug[] = $values;
            $userrolename[] = $key['name'];
        }

        $newcombineduserrole = array_combine((array) $userroleslug, (array) $userrolename);

        $listcategories = get_terms('product_cat');
        if (is_array($listcategories) && !empty($listcategories)) {
            foreach ($listcategories as $category) {
                $categoryname[] = $category->name;
                $categoryid[] = $category->term_id;
            }
        }
        if (is_array($categoryid) && !empty($categoryid) && is_array($categoryname) && !empty($categoryname)) {
            $categorylist = array_combine((array) $categoryid, (array) $categoryname);
        }
        $product_tags = array();
        $all_tags = get_categories(array('hide_empty' => 0, 'taxonomy' => 'product_tag'));
        foreach ($all_tags as $each_tag) {
            $product_tags[$each_tag->term_id] = $each_tag->name;
        }
        $membership_plan_options = array();
        $membership_exclude_plan_options = array();
        $pricing_commonfield = array(
            array(
                'name' => 'sumo_enable_the_rule',
                'id' => 'sumo_enable_the_rule',
                'class' => 'sumo_enable_the_rule',
                'type' => 'checkbox',
                'label' => __('Enable this Rule', 'sumodiscounts'),
                'default' => 'yes',
                'tooltip' => __('Enable this checkbox, if you want to consider this rule for providing Discounts', 'sumodiscounts'),
            ),
            array(
                'name' => 'sumo_apply_this_rule_for_sale',
                'id' => 'sumo_apply_this_rule_for_sale',
                'class' => 'sumo_apply_this_rule_for_sale',
                'type' => 'checkbox',
                'label' => __('Apply this Rule for Product with Sale Price', 'sumodiscounts'),
                'default' => 'yes',
                'tooltip' => __('When enabled, Products with Sale Price will also be considered for providing discounts', 'sumodiscounts'),
            ),
            array(
                'name' => 'sumo_dynamic_rule_name',
                'id' => 'sumo_dynamic_rule_name',
                'class' => 'sumo_dynamic_rule_name',
                'type' => 'text',
                'label' => __('Rule Name', 'sumodiscounts'),
                'default' => __('Rule Description', 'sumodiscounts'),
                'placeholder' => __('Enter Name of this Rule', 'sumodiscounts'),
                'tooltip' => __('Enter a Name which can denote the purpose of creating this rule <br> Example: Discounts for Logged In Users', 'sumodiscounts'),
            ),
            array(
                'name' => 'sumo_dynamic_rule_priority',
                'id' => 'sumo_dynamic_rule_priority',
                'class' => 'sumo_dynamic_rule_priority',
                'type' => 'select',
                'label' => __('Row Priority', 'sumodiscounts'),
                'options' => array(
                    '1' => __('First Matched Rule', 'sumodiscounts'),
                    '2' => __('Last Matched Rule', 'sumodiscounts'),
                    '3' => __('Minimum Discount', 'sumodiscounts'),
                    '4' => __('Maximum Discount', 'sumodiscounts'),
                ),
                'tooltip' => __('Row priority will be used to decide what discount is applicable for the users when the user\'s Current quantity matches with more than one row in a Rule ', 'sumodiscounts'),
            ),
        );
        $pricing_fields_for_qty_selection = array(
            array(
                'name' => 'sumo_dynamic_rule_based_on_pricing',
                'id' => 'sumo_dynamic_rule_based_on_pricing',
                'class' => 'sumo_dynamic_rule_based_on_pricing',
                'type' => 'select',
                'label' => __('Quantity Calculation is based on', 'sumodiscounts'),
                'options' => array(
                    '1' => __('Quantity from Product Level', 'sumodiscounts'),
                    '2' => __('Quantity from Variant Level', 'sumodiscounts'),
                    '3' => __('Entire Cart Quantity', 'sumodiscounts'),
                    '4' => __('Quantity from Each Category', 'sumodiscounts'),
                ),
                'tooltip' => __('Based on the options provided, the discounts will be calculated', 'sumodiscounts'),
            ),
        );

        $options = array(
            '1' => __('All Users', 'sumodiscounts'),
            '2' => __('Include User(s)', 'sumodiscounts'),
            '3' => __('Exclude User(s)', 'sumodiscounts'),
            //                '4' => __('All User Roles','sumodiscounts'),
            '5' => __('Include User Role(s)', 'sumodiscounts'),
            '6' => __('Exclude User Role(s)', 'sumodiscounts'),           
        );
        if (class_exists('SUMOMemberships') && sumo_get_membership_levels()) {
            $options['7'] = __('Include SUMO Member(s)', 'sumodiscounts');
            $options['8'] = __('Exclude SUMO Member(s)', 'sumodiscounts');            
        $membership_plan_options = array(
            'name' => 'sumo_pricing_apply_to_include_memberplans',
            'id' => 'sumo_pricing_apply_to_include_memberplans',
            'class' => 'sumo_pricing_apply_to_include_memberplans',
            'type' => 'multiselectincmemberplans',
            'label' => __('Include Membership plans', 'sumodiscounts'),
            'placeholder' => __('Select Membership plans', 'sumodiscounts'),
            'tooltip' => __('Rule is valid only for the Members had selected membership plans. If the \'Include Membership plans\' is left empty then the rule is valid for all users.', 'sumodiscounts'),
        );
        $membership_exclude_plan_options = array(
            'name' => 'sumo_pricing_apply_to_exclude_memberplans',
            'id' => 'sumo_pricing_apply_to_exclude_memberplans',
            'class' => 'sumo_pricing_apply_to_exclude_memberplans',
            'type' => 'multiselectexcmemberplans',
            'label' => __('Exclude Membership plans', 'sumodiscounts'),
            'placeholder' => __('Select Membership plans', 'sumodiscounts'),
            'tooltip' => __('Rule is valid only for the Members had without selected membership plans. If the \'Exclude Membership plans\' is left empty then the rule is valid for all users.', 'sumodiscounts'),
        );
        }
        $pricing_fields_user_filter = array(
            array(
                'name' => 'sumo_pricing_apply_for_user_type',
                'id' => 'sumo_pricing_apply_for_user_type',
                'class' => 'sumo_pricing_apply_for_user_type',
                'type' => 'select',
                'label' => __('User Filter', 'sumodiscounts'),
                'options' => array(
                    '1' => __('All Users', 'sumodiscounts'),
                    '2' => __('Logged In Users', 'sumodiscounts'),
                    '3' => __('Guest', 'sumodiscounts'),
                ),
                'tooltip' => __('By Default, discounts will be provided for All Users.If you want to restrict the discounts only to Logged in Users/Guest that can be done using the options', 'sumodiscounts')
            ),
            array(
                'name' => 'sumo_pricing_apply_to_user',
                'id' => 'sumo_pricing_apply_to_user',
                'class' => 'sumo_pricing_apply_to_user',
                'type' => 'select',
                'label' => __('Applicable for', 'sumodiscounts'),
                'options' => $options,
                'tooltip' => __('By Default, discounts will be provided for All Users.If you want to restrict the discounts only to specific users then, that can be done using the options provided', 'sumodiscounts'),
            ),
            array(
                'name' => 'sumo_pricing_apply_to_include_users',
                'id' => 'sumo_pricing_apply_to_include_users',
                'class' => 'sumo_pricing_apply_to_include_users',
                'type' => 'multiselectincuser',
                'label' => __('Include User(s)', 'sumodiscounts'),
                'placeholder' => __('Select User(s)', 'sumodiscounts'),
                'tooltip' => __('Rule is valid only for the selected users. If the \'Include User(s)\' is left empty then the rule is not valid for any of the users.', 'sumodiscounts')
            ),
            array(
                'name' => 'sumo_pricing_apply_to_exclude_users',
                'id' => 'sumo_pricing_apply_to_exclude_users',
                'class' => 'sumo_pricing_apply_to_exclude_users',
                'type' => 'multiselectexcuser',
                'label' => __('Exclude User(s)', 'sumodiscounts'),
                'placeholder' => __('Select User(s)', 'sumodiscounts'),
                'tooltip' => __('Rule is valid only for all users except for those users who are excluded. If the \'Exclude User(s)\' is left empty then the rule is not valid for any of the Users.', 'sumodiscounts'),
            ),
            array(
                'name' => 'sumo_pricing_apply_to_include_users_role',
                'class' => 'sumo_pricing_apply_to_include_users_role',
                'id' => 'sumo_pricing_apply_to_include_users_role',
                'type' => 'multiselect',
                'label' => __('Include User Role(s)', 'sumodiscounts'),
                'placeholder' => __('Select User Role(s)', 'sumodiscounts'),
                'options' => $newcombineduserrole,
                'tooltip' => __('Rule is valid only for the users of the selected user role(s). If the \'Include User Role(s)\' is left empty then the rule is not valid for any of the users.', 'sumodiscounts')
            ),
            array(
                'name' => 'sumo_pricing_apply_to_exclude_users_role',
                'id' => 'sumo_pricing_apply_to_exclude_users_role',
                'class' => 'sumo_pricing_apply_to_exclude_users_role',
                'type' => 'multiselect1',
                'label' => __('Exclude User Role(s)', 'sumodiscounts'),
                'placeholder' => __('Select User Role(s)', 'sumodiscounts'),
                'options' => $newcombineduserrole,
                'tooltip' => __('Rule is valid only for all users of the selected user role(s) except for those users who belong to the user role(s) which are excluded. If the \'Exclude User Role(s)\' is left empty then the rule is not valid for any of the users.', 'sumodiscounts'),
            ),
            $membership_plan_options,
            $membership_exclude_plan_options,
        );

        if (fpsd_check_if_free_shipping_enabled()) {
            $allowfreeshipping = array(
                'name' => 'sumo_enable_free_shipping',
                'id' => 'sumo_enable_free_shipping',
                'class' => 'sumo_enable_free_shipping',
                'type' => 'checkbox',
                'label' => __('Allow Free Shipping', 'sumodiscounts'),
                'default' => 'no',
                'tooltip' => __('When enabled, Free Shipping will be allowed when it match the rule', 'sumodiscounts'),
            );
        } else {
            $allowfreeshipping = array();
        }
        $pricing_fields_from_datepicker = array(
            array(
                'name' => array(
                    'sumo_pricing_from_datepicker', 'sumo_pricing_to_datepicker',
                ),
                'id' => array(
                    'sumo_pricing_from_datepicker', 'sumo_pricing_to_datepicker',
                ),
                'class' => array(
                    'sumo_pricing_from_datepicker', 'sumo_pricing_to_datepicker',
                ),
                'type' => 'datepicker',
                'label' => array(
                    __('Rule Valid from', 'sumodiscounts') . '&nbsp;', __('Rule Valid Till', 'sumodiscounts') . '&nbsp;'
                ),
                'tooltip' => array(
                    __('The Date from which the Discounts are valid', 'sumodiscounts'), __('The Date till which the Discounts are valid', 'sumodiscounts'),
                ),
            ),
            array(
                'name' => array(
                    'sumo_pricing_rule_week_monday',
                    'sumo_pricing_rule_week_tuesday',
                    'sumo_pricing_rule_week_wednesday',
                    'sumo_pricing_rule_week_thursday',
                    'sumo_pricing_rule_week_friday',
                    'sumo_pricing_rule_week_saturday',
                    'sumo_pricing_rule_week_sunday',
                ),
                'id' => array(
                    'sumo_pricing_rule_week_monday',
                    'sumo_pricing_rule_week_tuesday',
                    'sumo_pricing_rule_week_wednesday',
                    'sumo_pricing_rule_week_thursday',
                    'sumo_pricing_rule_week_friday',
                    'sumo_pricing_rule_week_saturday',
                    'sumo_pricing_rule_week_sunday',
                ),
                'class' => array(
                    'sumo_pricing_rule_week_monday',
                    'sumo_pricing_rule_week_tuesday',
                    'sumo_pricing_rule_week_wednesday',
                    'sumo_pricing_rule_week_thursday',
                    'sumo_pricing_rule_week_friday',
                    'sumo_pricing_rule_week_saturday',
                    'sumo_pricing_rule_week_sunday',
                ),
                'type' => 'weekdays',
                'week_days_title' => __('Rule is valid on the following days', 'sumodiscounts'),
                'label' => array(
                    __('Monday', 'sumodiscounts'), __('Tuesday', 'sumodiscounts'), __('Wednesday', 'sumodiscounts'), __('Thursday', 'sumodiscounts'), __('Friday', 'sumodiscounts'), __('Saturday', 'sumodiscounts'), __('Sunday', 'sumodiscounts')
                ),
                'tooltip' => __('If you want to provide discounts only on certain days of a Week then select only those days.', 'sumodiscounts'),
            ),
            $allowfreeshipping,
        );

        $pricing_fields_for_productfilter = array(
            array(
                'name' => 'sumo_pricing_apply_to_products',
                'id' => 'sumo_pricing_apply_to_products',
                'class' => 'sumo_pricing_apply_to_products',
                'type' => 'select',
                'label' => __('Applicable for', 'sumodiscounts'),
                'options' => array(
                    '1' => __('All Products', 'sumodiscounts'),
                    '2' => __('Include Products', 'sumodiscounts'),
                    '3' => __('Exclude Products', 'sumodiscounts'),
                    '4' => __('All Categories', 'sumodiscounts'),
                    '5' => __('Include Categories', 'sumodiscounts'),
                    '6' => __('Exclude Categories', 'sumodiscounts'),
                    '7' => __('All Tags', 'sumodiscounts'),
                    '8' => __('Include Tags', 'sumodiscounts'),
                    '9' => __('Exclude Tags', 'sumodiscounts'),
                ),
                'tooltip' => __('By Default, discounts will be provided for All Products.If you want to restrict the discounts only to specific products/categories then, that can be done using the options provided', 'sumodiscounts'),
            ),
            array(
                'name' => 'sumo_pricing_apply_to_include_products',
                'id' => 'sumo_pricing_apply_to_include_products',
                'class' => 'sumo_pricing_apply_to_include_products',
                'type' => 'multiselectincproduct',
                'label' => __('Include Products', 'sumodiscounts'),
                'placeholder' => __('Select Products', 'sumodiscounts'),
                'tooltip' => __('Rule is applicable only the selected Products', 'sumodiscounts'),
            ),
            array(
                'name' => 'sumo_pricing_apply_to_exclude_products',
                'id' => 'sumo_pricing_apply_to_exclude_products',
                'class' => 'sumo_pricing_apply_to_exclude_products',
                'type' => 'multiselectexcproduct',
                'label' => __('Exclude Products', 'sumodiscounts'),
                'placeholder' => __('Select Products', 'sumodiscounts'),
                'tooltip' => __('Rule is applicable for all products except for those products which are excluded', 'sumodiscounts'),
            ),
            array(
                'name' => 'sumo_pricing_apply_to_include_category',
                'id' => 'sumo_pricing_apply_to_include_category',
                'class' => 'sumo_pricing_apply_to_include_category',
                'type' => 'multiselectinccategory',
                'label' => __('Include Categories', 'sumodiscounts'),
                'placeholder' => __('Select Categories', 'sumodiscounts'),
                'options' => $categorylist,
                'tooltip' => __('Rule is applicable for all products of the  selected categories', 'sumodiscounts'),
            ),
            array(
                'name' => 'sumo_pricing_apply_to_exclude_category',
                'id' => 'sumo_pricing_apply_to_exclude_category',
                'class' => 'sumo_pricing_apply_to_exclude_category',
                'type' => 'multiselectexccategory',
                'label' => __('Exclude Categories', 'sumodiscounts'),
                'placeholder' => __('Select Categories', 'sumodiscounts'),
                'options' => $categorylist,
                'tooltip' => __('Rule is applicable for all products except for those products which belongs to the Excluded categories', 'sumodiscounts'),
            ),
            array(
                'name' => 'sumo_pricing_apply_to_include_tag',
                'id' => 'sumo_pricing_apply_to_include_tag',
                'class' => 'sumo_pricing_apply_to_include_tag',
                'type' => 'multiselectinctag',
                'label' => __('Include Tags', 'sumodiscounts'),
                'placeholder' => __('Select Tags', 'sumodiscounts'),
                'options' => $product_tags,
                'tooltip' => __('Rule is applicable for all products of the  selected tags', 'sumodiscounts'),
            ),
            array(
                'name' => 'sumo_pricing_apply_to_exclude_tag',
                'id' => 'sumo_pricing_apply_to_exclude_tag',
                'class' => 'sumo_pricing_apply_to_exclude_tag',
                'type' => 'multiselectexctag',
                'label' => __('Exclude Tags', 'sumodiscounts'),
                'placeholder' => __('Select Tags', 'sumodiscounts'),
                'options' => $product_tags,
                'tooltip' => __('Rule is applicable for all products except for those products which belongs to the Excluded tags', 'sumodiscounts'),
            ),
        );

        $condition_for_include = array(
            array(
                'name' => 'sumo_pricing_inc_condition',
                'id' => 'sumo_pricing_inc_condition',
                'class' => 'sumo_pricing_inc_condition',
                'type' => 'select',
                'label' => __('Applicable when', 'sumodiscounts'),
                'options' => array(
                    '1' => __('Any one of the selected is available in cart', 'sumodiscounts'),
                    '2' => __('All of the selected are available in cart', 'sumodiscounts'),
                    '3' => __('only selected are available in cart', 'sumodiscounts')
                ),
            )
        );

        $pricing_fields_for_qty = array(
            array(
                'name' => array(
                    'sumo_pricing_rule_min_quantity',
                    'sumo_pricing_rule_max_quantity',
                    'sumo_pricing_rule_discount_type',
                    'sumo_pricing_rule_discount_value',
                    'sumo_pricing_rule_repeat_discount',
                ),
                'id' => array(
                    'sumo_pricing_rule_min_quantity',
                    'sumo_pricing_rule_max_quantity',
                    'sumo_pricing_rule_discount_type',
                    'sumo_pricing_rule_discount_value',
                    'sumo_pricing_rule_repeat_discount',
                ),
                'class' => array(
                    'sumo_pricing_rule_min_quantity',
                    'sumo_pricing_rule_max_quantity',
                    'sumo_pricing_rule_discount_type',
                    'sumo_pricing_rule_discount_value',
                    'sumo_pricing_rule_repeat_discount',
                ),
                'type' => 'quantity_pricing',
                'label' => array(
                    __('Min Quantity', 'sumodiscounts') . ' &nbsp;', '&nbsp;' . __('Max Quantity', 'sumodiscounts'), ' &nbsp; ' . __('Discount Type', 'sumodiscounts'), ' &nbsp;' . __('Value', 'sumodiscounts'), ' &nbsp;' . __('Repeat', 'sumodiscounts'),
                ),
                'tooltip' => array(
                    __('The minimum quantity which the user needs to purchase in order to get a Discount', 'sumodiscounts'), __('The maximum quantity which the user should not exceed in order to get a Discount', 'sumodiscounts'), __('The type of discount which is to be applied can be chosen', 'sumodiscounts'), __('Enter Value for discount', 'sumodiscounts'),
                ),
            ),
        );

        $applicable_to = array(
            array(
                'name' => 'sumo_special_offer_applicable_to_',
                'id' => 'sumo_special_offer_applicable_to_',
                'class' => 'sumo_special_offer_applicable_to_',
                'type' => 'select',
                'label' => __('Applicable To', 'sumodiscounts'),
                'options' => array(
                    '' => __('Same Products', 'sumodiscounts'),
                    '1' => __('Include Products', 'sumodiscounts'),
                    '2' => __('Exclude Products', 'sumodiscounts'),
                    '4' => __('Include Categories', 'sumodiscounts'),
                    '5' => __('Exclude Categories', 'sumodiscounts'),
                    '6' => __('Include Tags', 'sumodiscounts'),
                    '7' => __('Exclude Tags', 'sumodiscounts'),
                    '8' => __('Automatic free product', 'sumodiscounts'),
                ),
                'tooltip' => __('By Default, discounts will be provided for Same Products.If you want to restrict the discounts only to specific products/categories then, that can be done using the options provided', 'sumodiscounts'),
            ),
            array(
                'name' => 'sumo_special_offer_buy_quantity',
                'id' => 'sumo_special_offer_buy_quantity',
                'class' => 'sumo_special_offer_buy_quantity',
                'type' => 'number',
                'label' => __('When Quantity greater than or equal to', 'sumodiscounts'),
                'tooltip' => '',
            ),
            array(
                'name' => 'sumo_special_offer_apply_to_free_products',
                'id' => 'sumo_special_offer_apply_to_free_products',
                'class' => 'sumo_special_offer_apply_to_free_products',
                'type' => 'multiselectfreeproduct_soat',
                'label' => __('Free Product', 'sumodiscounts'),
                'placeholder' => __('Select Product', 'sumodiscounts'),
                'tooltip' => __('Discount is applicable only the selected Product', 'sumodiscounts'),
            ),
            array(
                'name' => 'sumo_special_offer_apply_to_include_products',
                'id' => 'sumo_special_offer_apply_to_include_products',
                'class' => 'sumo_special_offer_apply_to_include_products',
                'type' => 'multiselectincproduct_soat',
                'label' => __('Include Products', 'sumodiscounts'),
                'placeholder' => __('Select Products', 'sumodiscounts'),
                'tooltip' => __('Discount is applicable only the selected Products', 'sumodiscounts'),
            ),
            array(
                'name' => 'sumo_special_offer_apply_to_exclude_products',
                'id' => 'sumo_special_offer_apply_to_exclude_products',
                'class' => 'sumo_special_offer_apply_to_exclude_products',
                'type' => 'multiselectexcproduct_soat',
                'label' => __('Exclude Products', 'sumodiscounts'),
                'placeholder' => __('Select Products', 'sumodiscounts'),
                'tooltip' => __('Discount is applicable for all products except for those products which are excluded', 'sumodiscounts'),
            ),
            array(
                'name' => 'sumo_special_offer_apply_to_include_category',
                'id' => 'sumo_special_offer_apply_to_include_category',
                'class' => 'sumo_special_offer_apply_to_include_category',
                'type' => 'multiselectinccategory',
                'label' => __('Include Categories', 'sumodiscounts'),
                'placeholder' => __('Select Categories', 'sumodiscounts'),
                'options' => $categorylist,
                'tooltip' => __('Discount is applicable for all products of the  selected categories', 'sumodiscounts'),
            ),
            array(
                'name' => 'sumo_special_offer_apply_to_exclude_category',
                'id' => 'sumo_special_offer_apply_to_exclude_category',
                'class' => 'sumo_special_offer_apply_to_exclude_category',
                'type' => 'multiselectexccategory',
                'label' => __('Exclude Categories', 'sumodiscounts'),
                'placeholder' => __('Select Categories', 'sumodiscounts'),
                'options' => $categorylist,
                'tooltip' => __('Discount is applicable for all products except for those products which belongs to the Excluded categories', 'sumodiscounts'),
            ),
            array(
                'name' => 'sumo_special_offer_apply_to_include_tag',
                'id' => 'sumo_special_offer_apply_to_include_tag',
                'class' => 'sumo_special_offer_apply_to_include_tag',
                'type' => 'multiselectinctag',
                'label' => __('Include Tags', 'sumodiscounts'),
                'placeholder' => __('Select Tags', 'sumodiscounts'),
                'options' => $product_tags,
                'tooltip' => __('Discount is applicable for all products of the  selected tags', 'sumodiscounts'),
            ),
            array(
                'name' => 'sumo_special_offer_apply_to_exclude_tag',
                'id' => 'sumo_special_offer_apply_to_exclude_tag',
                'class' => 'sumo_special_offer_apply_to_exclude_tag',
                'type' => 'multiselectexctag',
                'label' => __('Exclude Tags', 'sumodiscounts'),
                'placeholder' => __('Select Tags', 'sumodiscounts'),
                'options' => $product_tags,
                'tooltip' => __('Discount is applicable for all products except for those products which belongs to the Excluded tags', 'sumodiscounts'),
            ),
            array(
                'name' => 'sumo_special_offer_applicable_on_',
                'id' => 'sumo_special_offer_applicable_on_',
                'class' => 'sumo_special_offer_applicable_on_',
                'type' => 'select',
                'label' => __('Apply Discount on', 'sumodiscounts'),
                'options' => array(
                    '1' => __('Product With Highest Price', 'sumodiscounts'),
                    '2' => __('Product With Lowest Price', 'sumodiscounts'),
                    '3' => __('All Product', 'sumodiscounts'),
                ),
                'tooltip' => __('When discount is set to be applied on selected products and more than one of the selected product is in cart, based on the option selected the discount will be applied to Product With Highest/Lowest Price.', 'sumodiscounts'),
            )
        );

        $pricing_fields_for_offer = array(
            array(
                'name' => array(
                    'sumo_pricing_rule_buy_offer',
                    'sumo_pricing_rule_free_offer',
                    'sumo_pricing_rule_discount_type_for_offer',
                    'sumo_pricing_rule_discount_value_for_offer',
                    'sumo_pricing_repeat_rule',
                ),
                'id' => array(
                    'sumo_pricing_rule_buy_offer',
                    'sumo_pricing_rule_free_offer',
                    'sumo_pricing_rule_discount_type_for_offer',
                    'sumo_pricing_rule_discount_value_for_offer',
                    'sumo_pricing_repeat_rule',
                ),
                'class' => array(
                    'sumo_pricing_rule_buy_offer',
                    'sumo_pricing_rule_free_offer',
                    'sumo_pricing_rule_discount_type_for_offer',
                    'sumo_pricing_rule_discount_value_for_offer',
                    'sumo_pricing_repeat_rule',
                ),
                'type' => 'offer_pricing',
                'label' => array(
                    __('Buy', 'sumodiscounts'), __('Get', 'sumodiscounts'), __('Discount Type', 'sumodiscounts'), __('Value', 'sumodiscounts'), __('Repeat Row', 'sumodiscounts')
                ),
            ),
        );

        $cartcriteria = array(
            array(
                'name' => 'sumo_pricing_criteria',
                'type' => 'select',
                'label' => __('Criteria ', 'sumodiscounts'),
                'id' => 'sumo_pricing_criteria',
                'class' => 'sumo_pricing_criteria',
                'options' => array(
                    '1' => __('Any Product(s) is in Cart', 'sumodiscounts'),
                    '2' => __('Any one of the Selected Product(s) is in Cart', 'sumodiscounts'),
                    '3' => __('Any one of the Selected Product(s) is not in Cart', 'sumodiscounts'),
                    '6' => __('Any Products have Categories in Cart', 'sumodiscounts'),
                    '4' => __('Any one of the Product(s) of a Selected Category is in Cart', 'sumodiscounts'),
                    '5' => __('Any one of the Product(s) of a Selected Category is not in Cart', 'sumodiscounts'),
                    '7' => __('Any Products have Tags in Cart', 'sumodiscounts'),
                    '8' => __('Any one of the Product(s) of a Selected Tag is in Cart', 'sumodiscounts'),
                    '9' => __('Any one of the Product(s) of a Selected Tag is not in Cart', 'sumodiscounts'),
                ),
                'tooltip' => __('Cart Discount will be applied based on option selected', 'sumodiscounts'),
            ),
            array(
                'name' => 'sumo_pricing_apply_to_include_products_for_cart',
                'id' => 'sumo_pricing_apply_to_include_products_for_cart',
                'class' => 'sumo_pricing_apply_to_include_products_for_cart',
                'type' => 'multiselectincproduct',
                'label' => __('Include Products', 'sumodiscounts'),
                'placeholder' => __('Select Products', 'sumodiscounts'),
                'tooltip' => __('Discount will be applied when any one of the selected products is in cart', 'sumodiscounts'),
            ),
            array(
                'name' => 'sumo_pricing_apply_to_exclude_products_for_cart',
                'id' => 'sumo_pricing_apply_to_exclude_products_for_cart',
                'class' => 'sumo_pricing_apply_to_exclude_products_for_cart',
                'type' => 'multiselectexcproduct',
                'label' => __('Exclude Products', 'sumodiscounts'),
                'placeholder' => __('Select Products', 'sumodiscounts'),
                'tooltip' => __('Discount will be applied when any one of the selected products is not in cart', 'sumodiscounts'),
            ),
            array(
                'name' => 'sumo_pricing_apply_to_include_category_for_cart',
                'id' => 'sumo_pricing_apply_to_include_category_for_cart',
                'class' => 'sumo_pricing_apply_to_include_category_for_cart',
                'type' => 'multiselectinccategory',
                'label' => __('Include Categories', 'sumodiscounts'),
                'placeholder' => __('Select Categories', 'sumodiscounts'),
                'options' => $categorylist,
                'tooltip' => __('Discount will be applied when any one of the Products of the selected category is in cart', 'sumodiscounts'),
            ),
            array(
                'name' => 'sumo_pricing_apply_to_exclude_category_for_cart',
                'id' => 'sumo_pricing_apply_to_exclude_category_for_cart',
                'class' => 'sumo_pricing_apply_to_exclude_category_for_cart',
                'type' => 'multiselectexccategory',
                'label' => __('Exclude Categories', 'sumodiscounts'),
                'placeholder' => __('Select Categories', 'sumodiscounts'),
                'options' => $categorylist,
                'tooltip' => __('Discount will be applied when any one of the Products of the selected category is not in cart', 'sumodiscounts'),
            ),
            array(
                'name' => 'sumo_pricing_apply_to_include_tag_for_cart',
                'id' => 'sumo_pricing_apply_to_include_tag_for_cart',
                'class' => 'sumo_pricing_apply_to_include_tag_for_cart',
                'type' => 'multiselectinctag',
                'label' => __('Include Tags', 'sumodiscounts'),
                'placeholder' => __('Select Tags', 'sumodiscounts'),
                'options' => $product_tags,
                'tooltip' => __('Discount will be applied when any one of the Products of the selected tag is in cart', 'sumodiscounts'),
            ),
            array(
                'name' => 'sumo_pricing_apply_to_exclude_tag_for_cart',
                'id' => 'sumo_pricing_apply_to_exclude_tag_for_cart',
                'class' => 'sumo_pricing_apply_to_exclude_tag_for_cart',
                'type' => 'multiselectexctag',
                'label' => __('Exclude Tags', 'sumodiscounts'),
                'placeholder' => __('Select Tags', 'sumodiscounts'),
                'options' => $product_tags,
                'tooltip' => __('Discount will be applied when any one of the Products of the selected tag is not in cart', 'sumodiscounts'),
            ),
        );
        $user_purchase_history = array(
            array(
                'name' => 'sumo_user_purchase_history',
                'type' => 'select',
                'label' => __('User Purchase History', 'sumodiscounts'),
                'id' => 'sumo_user_purchase_history',
                'class' => 'sumo_user_purchase_history',
                'options' => array(
                    '' => __('None', 'sumodiscounts'),
                    '1' => __('Minimum Number of Successful Orders', 'sumodiscounts'),
                    '2' => __('Minimum Amount spent on Site', 'sumodiscounts')
                ),
                'tooltip' => __('Restrict Discounts to user based on their number of purchases or total amount spent in site', 'sumodiscounts'),
            ),
            array(
                'name' => 'sumo_u_p_history_time',
                'type' => 'select',
                'label' => __('User Purchase History Time', 'sumodiscounts'),
                'id' => 'sumo_u_p_history_time',
                'class' => 'sumo_u_p_history_time',
                'options' => array(
                    '' => __('From Beginning', 'sumodiscounts'),
                    '1' => __('Specific Period', 'sumodiscounts')
                ),
                'tooltip' => __('Restrict Discounts to user based on their number of purchases or total amount spent in site', 'sumodiscounts'),
            ),
            array(
                'name' => array(
                    'sumo_uph_from_datepicker', 'sumo_uph_to_datepicker',
                ),
                'id' => array(
                    'sumo_uph_from_datepicker', 'sumo_uph_to_datepicker',
                ),
                'class' => array(
                    'sumo_uph_from_datepicker', 'sumo_uph_to_datepicker',
                ),
                'type' => 'sumo_uph_datepicker',
                'label' => array(
                    __('From', 'sumodiscounts') . ' &nbsp;', __('Till', 'sumodiscounts') . ' &nbsp;'
                ),
                'tooltip' => array(
                    __("The Date from which the User's Purchase History recorded", 'sumodiscounts'), __("The Date till which the User's Purchase History recorded", 'sumodiscounts'),
                ),
            ),
            array(
                'name' => 'sumo_no_of_orders_placed',
                'type' => 'number',
                'label' => __('Number of orders Placed', 'sumodiscounts'),
                'id' => 'sumo_no_of_orders_placed',
                'placeholder' => '',
                'class' => 'sumo_no_of_orders_placed',
                'tooltip' => __('Rule is applicable for users who has placed more than the number of orders specified.<br>Note: Successful orders refers to orders which are in Processing / Completed Status', 'sumodiscounts'),
            ),
            array(
                'name' => 'sumo_total_amount_spent_in_site',
                'type' => 'number',
                'label' => __('Total Amount Spent ', 'sumodiscounts') . get_woocommerce_currency_symbol(),
                'id' => 'sumo_total_amount_spent_in_site',
                'placeholder' => '',
                'class' => 'sumo_total_amount_spent_in_site',
                'tooltip' => __('Rule is applicable for users who has purchased more than the amount specified in the rule.', 'sumodiscounts'),
            )
        );
        $pricing_fields_for_carttotalpricing = array(
            array(
                'name' => array(
                    'sumo_pricing_rule_min_total',
                    'sumo_pricing_rule_max_total',
                    'sumo_pricing_rule_discount_type',
                    'sumo_pricing_rule_discount_value',
                ),
                'id' => array(
                    'sumo_pricing_rule_min_total',
                    'sumo_pricing_rule_max_total',
                    'sumo_pricing_rule_discount_type',
                    'sumo_pricing_rule_discount_value',
                ),
                'class' => array(
                    'sumo_pricing_rule_min_total',
                    'sumo_pricing_rule_max_total',
                    'sumo_pricing_rule_discount_type',
                    'sumo_pricing_rule_discount_value',
                ),
                'type' => 'cart_total_pricing',
                'label' => array(
                    __('Min Cart Total', 'sumodiscounts'), __('Max Cart Total', 'sumodiscounts'), __('Discount Type', 'sumodiscounts'), __('Value', 'sumodiscounts'),
                ),
                'tooltip' => array(
                    __('The minimum cart total which the user needs in order to get a Discount', 'sumodiscounts'), __('The maximum cart total which the user should not exceed in order to get a Discount', 'sumodiscounts'), __('The type of discount which is to be applied can be chosen', 'sumodiscounts'), __('Enter Value for discount', 'sumodiscounts'),
                ),
            ),
        );
        $pricing_cat_pro_field = array(
            array(
                'name' => 'sumo_enable_the_rule',
                'id' => 'sumo_enable_the_rule',
                'class' => 'sumo_enable_the_rule',
                'type' => 'checkbox',
                'label' => __('Enable this Rule', 'sumodiscounts'),
                'default' => 'yes',
                'tooltip' => __('Enable this checkbox, if you want to consider this rule for providing Discounts', 'sumodiscounts'),
            ),
            array(
                'name' => 'sumo_apply_this_rule_for_sale',
                'id' => 'sumo_apply_this_rule_for_sale',
                'class' => 'sumo_apply_this_rule_for_sale',
                'type' => 'checkbox',
                'label' => __('Apply this Rule for Product with Sale Price', 'sumodiscounts'),
                'default' => 'yes',
                'tooltip' => __('When enabled, Products with Sale Price will also be considered for providing discounts', 'sumodiscounts'),
            ),
            array(
                'name' => 'sumo_dynamic_rule_name',
                'id' => 'sumo_dynamic_rule_name',
                'class' => 'sumo_dynamic_rule_name',
                'type' => 'text',
                'label' => __('Rule Name', 'sumodiscounts'),
                'default' => __('Rule Description', 'sumodiscounts'),
                'placeholder' => __('Enter Name of this Rule', 'sumodiscounts'),
                'tooltip' => __('Enter a Name which can denote the purpose of creating this rule <br> Example: Discounts for Logged In Users', 'sumodiscounts'),
            ),
        );

        $pricing_cat_pro_field1 = array(
            array(
                'name' => array(
                    'sumo_pricing_from_datepicker', 'sumo_pricing_to_datepicker',
                ),
                'id' => array(
                    'sumo_pricing_from_datepicker', 'sumo_pricing_to_datepicker',
                ),
                'class' => array(
                    'sumo_pricing_from_datepicker', 'sumo_pricing_to_datepicker',
                ),
                'type' => 'datepicker',
                'label' => array(
                    __('Rule Valid from', 'sumodiscounts') . '&nbsp;', __('Rule Valid Till', 'sumodiscounts') . '&nbsp;'
                ),
                'tooltip' => array(
                    __('The Date from which the Discounts are valid', 'sumodiscounts'), __('The Date till which the Discounts are valid', 'sumodiscounts'),
                ),
            ),
            array(
                'name' => array(
                    'sumo_pricing_rule_week_monday',
                    'sumo_pricing_rule_week_tuesday',
                    'sumo_pricing_rule_week_wednesday',
                    'sumo_pricing_rule_week_thursday',
                    'sumo_pricing_rule_week_friday',
                    'sumo_pricing_rule_week_saturday',
                    'sumo_pricing_rule_week_sunday',
                ),
                'id' => array(
                    'sumo_pricing_rule_week_monday',
                    'sumo_pricing_rule_week_tuesday',
                    'sumo_pricing_rule_week_wednesday',
                    'sumo_pricing_rule_week_thursday',
                    'sumo_pricing_rule_week_friday',
                    'sumo_pricing_rule_week_saturday',
                    'sumo_pricing_rule_week_sunday',
                ),
                'class' => array(
                    'sumo_pricing_rule_week_monday',
                    'sumo_pricing_rule_week_tuesday',
                    'sumo_pricing_rule_week_wednesday',
                    'sumo_pricing_rule_week_thursday',
                    'sumo_pricing_rule_week_friday',
                    'sumo_pricing_rule_week_saturday',
                    'sumo_pricing_rule_week_sunday',
                ),
                'type' => 'weekdays',
                'week_days_title' => __('Rule is valid on the following days ', 'sumodiscounts'),
                'label' => array(
                    __('Monday', 'sumodiscounts'), __('Tuesday', 'sumodiscounts'), __('Wednesday', 'sumodiscounts'), __('Thursday', 'sumodiscounts'), __('Friday', 'sumodiscounts'), __('Saturday', 'sumodiscounts'), __('Sunday', 'sumodiscounts')
                ),
                'tooltip' => __('If you want to provide discounts only on certain days of a Week then select only those days.', 'sumodiscounts'),
            ),
            $allowfreeshipping,
            array(
                'name' => 'sumo_pricing_type',
                'type' => 'select',
                'label' => __('Discount Type ', 'sumodiscounts'),
                'id' => 'sumo_pricing_type',
                'class' => 'sumo_pricing_type',
                'options' => array(
                    '1' => __('% Discount', 'sumodiscounts'),
                    '2' => __('Fixed Discount', 'sumodiscounts'),
                    '3' => __('Fixed Price', 'sumodiscounts')
                ),
                'tooltip' => __('The type of discount which is to be applied can be chosen', 'sumodiscounts')
            ),
            array(
                'name' => 'sumo_discount_value',
                'type' => 'number',
                'label' => __('Value', 'sumodiscounts'),
                'id' => 'sumo_discount_value',
                'placeholder' => '',
                'class' => 'sumo_discount_value',
                'tooltip' => __('Enter Value for discount', 'sumodiscounts')
            ),
        );
        if ('quantity' == $ruletype) {
            $pricing_fields = array_merge($pricing_commonfield, $pricing_fields_for_qty_selection, $pricing_fields_user_filter, $user_purchase_history, $pricing_fields_for_productfilter, $condition_for_include, $pricing_fields_from_datepicker, $pricing_fields_for_qty);
        } elseif ('offer' == $ruletype) {
            $pricing_fields = array_merge($pricing_commonfield, $pricing_fields_user_filter, $user_purchase_history, $pricing_fields_for_productfilter, $condition_for_include, $pricing_fields_from_datepicker, $applicable_to, $pricing_fields_for_offer);
        } elseif ('quantity_pricing' == $ruletype) {
            $pricing_fields = $pricing_fields_for_qty;
        } elseif ('cart_total_pricing' == $ruletype) {
            $pricing_fields = array_merge($pricing_commonfield, $pricing_fields_user_filter, $user_purchase_history, $cartcriteria, $condition_for_include, $pricing_fields_from_datepicker, $pricing_fields_for_carttotalpricing);
        } elseif ('cart_total' == $ruletype) {
            $pricing_fields = $pricing_fields_for_carttotalpricing;
        } elseif ('specialoffer' == $ruletype) {
            $pricing_fields = $pricing_fields_for_offer;
        } elseif ('cat_pro_pricing' == $ruletype) {
            $pricing_fields = array_merge($pricing_cat_pro_field, $pricing_fields_user_filter, $pricing_fields_for_productfilter, $user_purchase_history, $pricing_cat_pro_field1);
        }
        return $pricing_fields;
    }

}

if (!function_exists('fpsd_display_data_after_saved')) {

    function fpsd_display_data_after_saved($uniqid, $ruletype, $nameforinputfield) {
        if ('quantity' == $ruletype) {
            $get_list_of_array = fpsd_generate_dynamic_rule_pricing_fields($ruletype);
            $get_data = get_option('sumo_pricing_rule_fields_for_qty');
            $get_data = fpsd_array_sort_by_key($get_data, (array) get_option('sumo_dynamic_pricing_drag_position_for_qty'));
            $get_data = $get_data[$uniqid];
        } elseif ('cart_total_pricing' == $ruletype) {
            $get_list_of_array = fpsd_generate_dynamic_rule_pricing_fields($ruletype);
            $get_data = get_option('sumo_pricing_rule_fields_for_cart');
            $get_data = fpsd_array_sort_by_key($get_data, (array) get_option('sumo_dynamic_pricing_drag_position_for_cart'));
            $get_data = $get_data[$uniqid];
        } elseif ('offer' == $ruletype) {
            $get_list_of_array = fpsd_generate_dynamic_rule_pricing_fields($ruletype);
            $get_data = get_option('sumo_pricing_rule_fields_for_offer');
            $get_data = fpsd_array_sort_by_key($get_data, (array) get_option('sumo_dynamic_pricing_drag_position_for_offer'));
            $get_data = $get_data[$uniqid];
        } elseif ('cat_pro_pricing' == $ruletype) {
            $get_list_of_array = fpsd_generate_dynamic_rule_pricing_fields($ruletype);
            $get_data = get_option('sumo_pricing_rule_fields_for_cat_pro');
            $get_data = fpsd_array_sort_by_key($get_data, (array) get_option('sumo_dynamic_pricing_drag_position_for_cat_pro'));
            $get_data = $get_data[$uniqid];
        }        
        ob_start();
        foreach ($get_list_of_array as $key => $new_fields) {
            if( !isset( $new_fields['type'] )){
                continue;
            }
            switch ($new_fields['type']) {
                case 'title':
                    ?>
                    <br>
                    <p class="form-field">
                        <b><?php esc_html_e($new_fields['label'], 'sumodiscounts'); ?></b>
                    </p>
                    <br>
                    <?php
                    break;
                case 'text':
                    ?>
                    <p class="form-field">
                        <b><?php esc_html_e($new_fields['label'], 'sumodiscounts'); ?></b>&nbsp;&nbsp;&nbsp;&nbsp;<span class="dashicons dashicons-info" title="<?php echo esc_attr($new_fields['tooltip']); ?>"></span><input name="<?php echo esc_attr($nameforinputfield); ?>[<?php echo esc_attr($uniqid); ?>][<?php echo esc_attr($new_fields['name']); ?>]" type="<?php echo esc_attr($new_fields['type']); ?>" value="<?php echo esc_attr($get_data[$new_fields['name']]); ?>" placeholder="<?php echo esc_attr($new_fields['placeholder']); ?>"/><br><br>
                    </p>
                    <?php
                    break;
                case 'number':
                    ?>
                    <p class="form-field">
                        <b><?php esc_html_e($new_fields['label'], 'sumodiscounts'); ?></b>&nbsp;&nbsp;&nbsp;&nbsp;<span class="dashicons dashicons-info" title="<?php echo esc_attr($new_fields['tooltip']); ?>"></span><input class="<?php echo esc_attr($new_fields['id']); ?>" name="<?php echo esc_attr($nameforinputfield); ?>[<?php echo esc_attr($uniqid); ?>][<?php echo esc_attr($new_fields['name']); ?>]" type="<?php echo esc_attr($new_fields['type']); ?>" value="<?php echo esc_attr($get_data[$new_fields['name']]); ?>" step="any" min="0.01"/><br><br>
                    </p>
                    <?php
                    break;
                case 'select':
                    $select_value = isset($get_data[$new_fields['name']]) ? $get_data[$new_fields['name']] : '';
                    ?>
                    <p class="form-field">
                        <b><?php esc_html_e($new_fields['label'], 'sumodiscounts'); ?></b>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
                        <span class="dashicons dashicons-info" title="<?php echo esc_attr(isset($new_fields['tooltip']) ? $new_fields['tooltip'] : ''); ?>"></span><select  class="<?php echo esc_attr($new_fields['class']); ?>" id="<?php echo esc_attr($new_fields['id']); ?>" name="<?php echo esc_attr($nameforinputfield); ?>[<?php echo esc_attr($uniqid); ?>][<?php echo esc_attr($new_fields['name']); ?>]">
                            <?php
                            foreach ($new_fields['options'] as $key => $options) {
                                ?>
                                <option value="<?php echo esc_attr($key); ?>" <?php echo esc_attr(selected($key, $select_value)); ?>><?php echo esc_attr($options); ?></option>
                                <?php
                            }
                            ?>
                        </select><br><br>
                    </p>
                    <?php
                    break;
                case 'checkbox':
                    $option_name = $new_fields['name'];
                    ?>
                    <p class="form-field">
                        <b><?php esc_html_e($new_fields['label'], 'sumodiscounts'); ?></b>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<span class="dashicons dashicons-info" title="<?php echo esc_attr($new_fields['tooltip']); ?>"></span><input type="checkbox" name="<?php echo esc_attr($nameforinputfield); ?>[<?php echo esc_attr($uniqid); ?>][<?php echo esc_attr($new_fields['name']); ?>]" value="yes"
                        <?php
                        if (isset($get_data[$option_name])) {
                            checked('yes', $get_data[$option_name]);
                        }
                        ?>
                                                                                                                                                                                                                            />
                        <br><br>
                    </p>
                    <?php
                    break;
                case 'datepicker':
                    ?>
                    <p class="form-field" >
                        <?php
                        $label_one = $new_fields['label'][0];
                        $label_two = $new_fields['label'][1];

                        $name_one = $new_fields['name'][0];
                        $name_two = $new_fields['name'][1];
                        ?>
                        <b><?php esc_html_e($label_one, 'sumodiscounts'); ?></b><span class="dashicons dashicons-info" title="<?php echo esc_attr($new_fields['tooltip'][0]); ?>"></span><input type="text" placeholder="dd-mm-yy" class="sp_date sumo_dash_icons_info" name="<?php echo esc_attr($nameforinputfield); ?>[<?php echo esc_attr($uniqid); ?>][<?php echo esc_attr($name_one); ?>]"  value="<?php echo esc_attr(isset($get_data[$name_one]) ? $get_data[$name_one] : '' ); ?>" id="from" />&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;

                        <b><?php esc_html_e($label_two, 'sumodiscounts'); ?></b><span class="dashicons dashicons-info" title="<?php echo esc_attr($new_fields['tooltip'][1]); ?>"></span><input type="text" placeholder="dd-mm-yy" class="sp_date sumo_dash_icons_info" name="<?php echo esc_attr($nameforinputfield); ?>[<?php echo esc_attr($uniqid); ?>][<?php echo esc_attr($name_two); ?>]" value="<?php echo esc_attr(isset($get_data[$name_two]) ? $get_data[$name_two] : '' ); ?>" id="to" />
                    </p>
                    <?php
                    break;
                case 'sumo_uph_datepicker':
                    ?>
                    <p class="form-field" >
                        <?php
                        $label_one = $new_fields['label'][0];
                        $label_two = $new_fields['label'][1];

                        $name_one = $new_fields['name'][0];
                        $name_two = $new_fields['name'][1];
                        ?>
                        <b><?php esc_html_e($label_one, 'sumodiscounts'); ?></b><span class="dashicons dashicons-info" title="<?php echo esc_attr($new_fields['tooltip'][0]); ?>"></span><input type="text" placeholder="yy-mm-dd" class="sp__date sumo_dash_icons_info" name="<?php echo esc_attr($nameforinputfield); ?>[<?php echo esc_attr($uniqid); ?>][<?php echo esc_attr($name_one); ?>]"  value="<?php echo esc_attr(isset($get_data[$name_one]) ? $get_data[$name_one] : '' ); ?>" id="sumo_uph_from_datepicker" />&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;

                        <b><?php esc_html_e($label_two, 'sumodiscounts'); ?></b><span class="dashicons dashicons-info" title="<?php echo esc_attr($new_fields['tooltip'][1]); ?>"></span><input type="text" placeholder="yy-mm-dd" class="sp__date sumo_dash_icons_info" name="<?php echo esc_attr($nameforinputfield); ?>[<?php echo esc_attr($uniqid); ?>][<?php echo esc_attr($name_two); ?>]" value="<?php echo esc_attr(isset($get_data[$name_two]) ? $get_data[$name_two] : '' ); ?>" id="sumo_uph_to_datepicker" />
                    </p>
                    <?php
                    break;
                case 'weekdays':
                    $label_name = $new_fields['label'];
                    $option_name = $new_fields['name'];
                    $title_name = $new_fields['week_days_title'];
                    ?>
                    <p class="form-field">
                        <label><?php esc_html_e($title_name, 'sumodiscounts'); ?><span class="dashicons dashicons-info" title="<?php echo esc_attr($new_fields['tooltip']); ?>"></span></label>
                        <?php
                        foreach ($option_name as $key => $eachname) {
                            ?>
                            <input type="checkbox" name="<?php echo esc_attr($nameforinputfield); ?>[<?php echo esc_attr($uniqid); ?>][<?php echo esc_attr($eachname); ?>]" value="1"
                            <?php
                            if (isset($get_data[$eachname])) {
                                checked('1', $get_data[$eachname]);
                            }
                            ?>
                                   /> <?php echo esc_html($new_fields['label'][$key]); ?><br>
                                   <?php
                               }
                               ?>
                    </p>
                    <?php
                    break;
                case 'multiselectincuser':
                    $classname = isset($new_fields['class']) ? $new_fields['class'] : '';
                    $includeuser = isset($get_data['sumo_pricing_apply_to_include_users']) ? $get_data['sumo_pricing_apply_to_include_users'] : '';
                    $label = '';
                    $id = '';
                    fpsd_select_users($id, $label, $classname, $uniqid, $nameforinputfield, $new_fields, $includeuser);
                    break;

                case 'multiselectexcuser':
                    $classname = isset($new_fields['class']) ? $new_fields['class'] : '';
                    $excludeuser = isset($get_data['sumo_pricing_apply_to_exclude_users']) ? $get_data['sumo_pricing_apply_to_exclude_users'] : '';
                    $label = '';
                    $id = '';
                    fpsd_select_users($id, $label, $classname, $uniqid, $nameforinputfield, $new_fields, $excludeuser);
                    break;

                case 'multiselect':
                    $classname = isset($new_fields['class']) ? $new_fields['class'] : '';
                    fpsd_select_userrole($classname, $uniqid, $nameforinputfield, $new_fields, $get_data);
                    break;

                case 'multiselect1':
                    $classname = isset($new_fields['class']) ? $new_fields['class'] : '';
                    fpsd_select_userrole($classname, $uniqid, $nameforinputfield, $new_fields, $get_data);
                    break;
                case 'multiselectincproduct':
                    $classname = isset($new_fields['class']) ? $new_fields['class'] : '';
                    if ('cart_total_pricing' == $ruletype) {
                        $includeproduct = isset($get_data['sumo_pricing_apply_to_include_products_for_cart']) ? $get_data['sumo_pricing_apply_to_include_products_for_cart'] : '';
                    } elseif ('quantity' == $ruletype || 'offer' == $ruletype || 'cat_pro_pricing' == $ruletype) {
                        $includeproduct = isset($get_data['sumo_pricing_apply_to_include_products']) ? $get_data['sumo_pricing_apply_to_include_products'] : '';
                    }
                    $label = '';
                    $id = '';
                    fpsd_select_product($id, $label, $classname, $uniqid, $nameforinputfield, $new_fields, $includeproduct);
                    break;
                case 'multiselectfreeproduct_soat':
                    $classname = isset($new_fields['class']) ? $new_fields['class'] : '';
                    if ('offer' == $ruletype) {
                        $freeproduct = isset($get_data['sumo_special_offer_apply_to_free_products']) ? $get_data['sumo_special_offer_apply_to_free_products'] : '';
                    }
                    $label = '';
                    $id = '';
                    fpsd_select_product($id, $label, $classname, $uniqid, $nameforinputfield, $new_fields, $freeproduct, false);
                    break;
                case 'multiselectincproduct_soat':
                    $classname = isset($new_fields['class']) ? $new_fields['class'] : '';
                    if ('offer' == $ruletype) {
                        $includeproduct = isset($get_data['sumo_special_offer_apply_to_include_products']) ? $get_data['sumo_special_offer_apply_to_include_products'] : '';
                    }
                    $label = '';
                    $id = '';
                    fpsd_select_product($id, $label, $classname, $uniqid, $nameforinputfield, $new_fields, $includeproduct);
                    break;

                case 'multiselectexcproduct_soat':
                    $classname = isset($new_fields['class']) ? $new_fields['class'] : '';
                    if ('offer' == $ruletype) {
                        $includeproduct = isset($get_data['sumo_special_offer_apply_to_exclude_products']) ? $get_data['sumo_special_offer_apply_to_exclude_products'] : '';
                    }
                    $label = '';
                    $id = '';
                    fpsd_select_product($id, $label, $classname, $uniqid, $nameforinputfield, $new_fields, $includeproduct);
                    break;

                case 'multiselectexcproduct':
                    $classname = isset($new_fields['class']) ? $new_fields['class'] : '';
                    if ('cart_total_pricing' == $ruletype) {
                        $excludeproduct = isset($get_data['sumo_pricing_apply_to_exclude_products_for_cart']) ? $get_data['sumo_pricing_apply_to_exclude_products_for_cart'] : '';
                    } elseif ('quantity' == $ruletype || 'offer' == $ruletype || 'cat_pro_pricing' == $ruletype) {
                        $excludeproduct = isset($get_data['sumo_pricing_apply_to_exclude_products']) ? $get_data['sumo_pricing_apply_to_exclude_products'] : '';
                    }
                    $label = '';
                    $id = '';
                    fpsd_select_product($id, $label, $classname, $uniqid, $nameforinputfield, $new_fields, $excludeproduct);
                    break;

                case 'multiselectincproductapplyon':
                    global $woocommerce;
                    $fieldclassname = isset($new_fields['class']) ? $new_fields['class'] : '';
                    $fieldid = $new_fields['id'];
                    $add_array = (float) WC()->version < (float) '3.0.0' ? '' : '[]';
                    $fieldname = $nameforinputfield . '[' . $uniqid . '][' . $new_fields['name'] . ']' . $add_array;
                    $selectedproduct = isset($get_data['sumo_pricing_apply_on_include_products']) ? $get_data['sumo_pricing_apply_on_include_products'] : '';
                    ?>
                    <p class="form-field">
                        <b>
                            <?php esc_html_e($new_fields['label'], 'sumodiscounts'); ?>
                        </b>
                        <?php if ((float) $woocommerce->version <= (float) ( '2.2.0' )) { ?>
                            <span class="dashicons dashicons-info" title="<?php echo esc_attr($new_fields['tooltip']); ?>"></span><select class="<?php echo esc_attr($fieldclassname); ?>" name="<?php echo esc_attr($fieldname); ?>"  id="<?php echo esc_attr($fieldid); ?>">
                                <?php
                                if ('' != $selectedproduct) {
                                    if (!empty($selectedproduct)) {
                                        $list_of_produts = (array) $selectedproduct;
                                        foreach ($list_of_produts as $rs_free_id) {
                                            $product = fpsd_get_product($rs_free_id);
                                            if ($product) {
                                                echo '<option value="' . esc_attr($rs_free_id) . '" ';
                                                selected(1, 1);
                                                echo '>' .
                                                ' #' .
                                                esc_attr($rs_free_id) .
                                                ' &ndash; ' .
                                                wp_kses_post(get_the_title($rs_free_id));
                                            }
                                        }
                                    }
                                } else {
                                    ?>
                                    <option value=""></option>
                                    <?php
                                }
                                ?>
                            </select>
                        <?php } else { ?>
                            <span class="dashicons dashicons-info" title="<?php echo esc_attr($new_fields['tooltip']); ?>"></span>
                            <?php if (WC()->version < (float) '3.0.0') { ?>
                                <input type="hidden" class="wc-product-search"  name="<?php echo esc_attr($fieldname); ?>" id="<?php echo esc_attr($fieldid); ?>" data-placeholder="<?php esc_attr_e('Search Products', 'sumodiscounts'); ?>"  data-allow_clear="true" data-selected="
                                <?php
                                $json_ids = array();
                                if (null !== $selectedproduct) {
                                    if (!is_array($selectedproduct)) {
                                        $product_ids = explode(',', $selectedproduct);
                                    } else {
                                        $product_ids = $selectedproduct;
                                    }
                                    foreach ($product_ids as $product_id) {
                                        if (isset($product_id)) {
                                            $product = fpsd_get_product($product_id);
                                            if (is_object($product)) {
                                                $json_ids[$product_id] = wp_kses_post($product->get_formatted_name());
                                            }
                                        }
                                    } echo esc_attr(json_encode($json_ids));
                                }
                                ?>
                                       " value="
                                       <?php
                                       if ('' != $selectedproduct) {
                                           echo esc_attr(implode(',', array_keys($json_ids)));
                                       } else {
                                           echo '';
                                       }
                                       ?>
                                       " />
                                       <?php
                                   } else {
                                       ?>
                                <select class="wc-product-search"  multiple="multiple" name="<?php echo esc_attr($fieldname); ?>" id="<?php echo esc_attr($fieldid); ?>" data-placeholder="<?php esc_attr_e('Search Products', 'sumodiscounts'); ?>"  data-allow_clear="true">
                                    <?php
                                    if (!is_array($selectedproduct)) {
                                        $selectedproduct = explode(',', $selectedproduct);
                                    }
                                    foreach ($selectedproduct as $each_product) {
                                        $product_obj = fpsd_get_product($each_product);
                                        if ($product_obj) {
                                            echo '<option value="' . esc_attr($each_product) . '"' . esc_attr(selected(1, 1)) . '>' . wp_kses_post($product_obj->get_formatted_name()) . '</option>';
                                        }
                                    }
                                    ?>
                                </select>
                                <?php
                            }
                        }
                        ?>
                    </p>
                    <?php
                    break;
                case 'multiselectinccategory':
                    $classname = isset($new_fields['class']) ? $new_fields['class'] : '';
                    fpsd_select_category($classname, $uniqid, $nameforinputfield, $new_fields, $get_data);
                    break;

                case 'multiselectexccategory':
                    $classname = isset($new_fields['class']) ? $new_fields['class'] : '';
                    fpsd_select_category($classname, $uniqid, $nameforinputfield, $new_fields, $get_data);
                    break;
                case 'multiselectinctag':
                    $classname = isset($new_fields['class']) ? $new_fields['class'] : '';
                    fpsd_function_to_select_tag($classname, $uniqid, $nameforinputfield, $new_fields, $get_data);
                    break;
                case 'multiselectexctag':
                    $classname = isset($new_fields['class']) ? $new_fields['class'] : '';
                    fpsd_function_to_select_tag($classname, $uniqid, $nameforinputfield, $new_fields, $get_data);
                    break;
                case 'multiselectincmemberplans':
                    if (class_exists('SUMOMemberships') && sumo_get_membership_levels()) {
                        global $woocommerce;
                        ?>
                        <p class="form-field">
                            <b>
                                <?php esc_html_e($new_fields['label'], 'sumodiscounts'); ?>
                            </b>
                            <?php
                            if ((float) WC()->version < (float) '3.0.0') {
                                ?>
                                <span class="dashicons dashicons-info" title="<?php echo esc_attr($new_fields['tooltip']); ?>"></span>
                                <input type="text" class="<?php echo esc_attr($new_fields['class']); ?> sumomembership_plans_select" name="<?php echo esc_attr($nameforinputfield); ?>[<?php echo esc_attr($uniqid); ?>][<?php echo esc_attr($new_fields['name']); ?>]"  id="<?php echo esc_attr($new_fields['id']); ?>"/>

                            <?php } else { ?>
                                <span class="dashicons dashicons-info" title="<?php echo esc_attr($new_fields['tooltip']); ?>"></span>
                                <?php
                                $add_array = (float) WC()->version < (float) '3.0.0' ? '' : '[]';
                                $name = $nameforinputfield . '[' . $uniqid . '][' . $new_fields['name'] . ']' . $add_array;
                                $type = isset($get_data['sumo_pricing_apply_to_user']) ? $get_data['sumo_pricing_apply_to_user'] : '7';
                                $include_plans = isset($get_data['sumo_pricing_apply_to_include_memberplans']) ? $get_data['sumo_pricing_apply_to_include_memberplans'] : array();   
                                ?>
                                <select name="<?php echo esc_attr($name); ?>" class="sumomembership_plans_select sumo_select_plans" multiple="multiple" id="<?php echo esc_attr($new_fields['id']); ?>" >
                                    <?php
                                    foreach ($include_plans as $include_plan) {
                                        echo '<option value="' . esc_attr($include_plan) . '"' . esc_attr(selected(1, 1)) . '>' . wp_kses_post(get_the_title($include_plan)) . '</option>';
                                    }
                                    ?>
                                </select>
                                <?php
                            }
                            ?>
                        </p>
                        <?php
                    }
                    break;
                    case 'multiselectexcmemberplans':
                    if (class_exists('SUMOMemberships') && sumo_get_membership_levels()) {
                        global $woocommerce;
                        ?>
                        <p class="form-field">
                            <b>
                                <?php esc_html_e($new_fields['label'], 'sumodiscounts'); ?>
                            </b>
                            <?php
                            if ((float) WC()->version < (float) '3.0.0') {
                                ?>
                                <span class="dashicons dashicons-info" title="<?php echo esc_attr($new_fields['tooltip']); ?>"></span>
                                <input type="text" class="<?php echo esc_attr($new_fields['class']); ?> sumomembership_plans_select" name="<?php echo esc_attr($nameforinputfield); ?>[<?php echo esc_attr($uniqid); ?>][<?php echo esc_attr($new_fields['name']); ?>]"  id="<?php echo esc_attr($new_fields['id']); ?>"/>

                            <?php } else { ?>
                                <span class="dashicons dashicons-info" title="<?php echo esc_attr($new_fields['tooltip']); ?>"></span>
                                <?php
                                $add_array = (float) WC()->version < (float) '3.0.0' ? '' : '[]';
                                $name = $nameforinputfield . '[' . $uniqid . '][' . $new_fields['name'] . ']' . $add_array;
                                $type = isset($get_data['sumo_pricing_apply_to_user']) ? $get_data['sumo_pricing_apply_to_user'] : '8';                                
                                $exclude_plans = isset($get_data['sumo_pricing_apply_to_exclude_memberplans']) ? $get_data['sumo_pricing_apply_to_exclude_memberplans'] : array();
                                ?>
                                <select name="<?php echo esc_attr($name); ?>" class="sumomembership_plans_select sumo_select_plans" multiple="multiple" id="<?php echo esc_attr($new_fields['id']); ?>" >
                                    <?php
                                    foreach ($exclude_plans as $exclude_plan) {
                                        echo '<option value="' . esc_attr($exclude_plan) . '"' . esc_attr(selected(1, 1)) . '>' . wp_kses_post(get_the_title($exclude_plan)) . '</option>';
                                    }
                                    ?>
                                </select>
                                <?php
                            }
                            ?>
                        </p>
                        <?php
                    }
                    break;

                case 'quantity_pricing':
                    $label_name = $new_fields['label'];
                    $option_name = $new_fields['name'];
                    $quantity_rule = isset($get_data['sumo_quantity_rule']) ? $get_data['sumo_quantity_rule'] : array();
                    ?>
                    <div class="sumo_quantity_rule">
                        <?php
                        if (is_array($quantity_rule) && !empty($quantity_rule)) {
                            foreach ($quantity_rule as $key => $value) {
                                $get_datas = $quantity_rule[$key];
                                ?>
                                <p class="form-field sumo_rule_form" >
                                    <label>
                                        <?php esc_html_e($new_fields['label'][0], 'sumodiscounts'); ?>
                                    </label>

                                    <span class="dashicons dashicons-info" title="<?php echo esc_attr($new_fields['tooltip'][0]); ?>"></span><input type="text" class="sumo_number_input" required="required"  name="<?php echo esc_attr($nameforinputfield); ?>[<?php echo esc_attr($uniqid); ?>][sumo_quantity_rule][<?php echo esc_attr($key); ?>][<?php echo esc_attr($new_fields['name'][0]); ?>]" value="<?php echo esc_attr($get_datas[$new_fields['name'][0]]); ?>"/>

                                    <label>
                                        <?php esc_html_e($new_fields['label'][1], 'sumodiscounts'); ?>
                                    </label>
                                    <span class="dashicons dashicons-info" title="<?php echo esc_attr($new_fields['tooltip'][1]); ?>"></span><input type="text" class="sumo_number_input" required="required"  name="<?php echo esc_attr($nameforinputfield); ?>[<?php echo esc_attr($uniqid); ?>][sumo_quantity_rule][<?php echo esc_attr($key); ?>][<?php echo esc_attr($new_fields['name'][1]); ?>]" value="<?php echo esc_attr($get_datas[$new_fields['name'][1]]); ?>"/>

                                    <label>
                                        <?php esc_html_e($new_fields['label'][2], 'sumodiscounts'); ?>
                                    </label>
                                    <span class="dashicons dashicons-info" title="<?php echo esc_attr($new_fields['tooltip'][2]); ?>"></span><select name="<?php echo esc_attr($nameforinputfield); ?>[<?php echo esc_attr($uniqid); ?>][sumo_quantity_rule][<?php echo esc_attr($key); ?>][<?php echo esc_attr($new_fields['name'][2]); ?>]">
                                        <option value="1" <?php echo selected('1', $get_datas[$new_fields['name'][2]]); ?>><?php esc_html_e('% Discount', 'sumodiscounts'); ?></option>
                                        <option value="2" <?php echo selected('2', $get_datas[$new_fields['name'][2]]); ?>><?php esc_html_e('Fixed Discount', 'sumodiscounts'); ?></option>
                                        <option value="3" <?php echo selected('3', $get_datas[$new_fields['name'][2]]); ?>><?php esc_html_e('Fixed Price', 'sumodiscounts'); ?></option>
                                    </select>

                                    <label>
                                        <?php esc_html_e($new_fields['label'][3], 'sumodiscounts'); ?>
                                    </label>

                                    <span class="dashicons dashicons-info" title="<?php echo esc_attr($new_fields['tooltip'][3]); ?>"></span>
                                    <input type="number" min=".01" step="any" required="required" class="sumo_number_input"  name="<?php echo esc_attr($nameforinputfield); ?>[<?php echo esc_attr($uniqid); ?>][sumo_quantity_rule][<?php echo esc_attr($key); ?>][<?php echo esc_attr($new_fields['name'][3]); ?>]" value="<?php echo esc_attr($get_datas[$new_fields['name'][3]]); ?>"/>


                                    <input type="checkbox" name="<?php echo esc_attr($nameforinputfield); ?>[<?php echo esc_attr($uniqid); ?>][sumo_quantity_rule][<?php echo esc_attr($key); ?>][<?php echo esc_attr($new_fields['name'][4]); ?>]" value="yes"
                                    <?php
                                    if (isset($get_datas['sumo_pricing_rule_repeat_discount'])) {
                                        checked('yes', $get_datas['sumo_pricing_rule_repeat_discount']);
                                    }
                                    ?>
                                           />
                                    <label>
                                        <b><?php esc_html_e($new_fields['label'][4], 'sumodiscounts'); ?></b><br><br>
                                    </label>
                                    <span class="sumo_delete_row button-secondary"><?php esc_html_e('Delete Row', 'sumodiscounts'); ?></span>
                                </p>
                                <?php
                            }
                        }
                        ?>
                    </div>
                    <span class="add_new_row_for_quantity button-primary" data-uniq_id="<?php echo esc_attr($uniqid); ?>"><?php esc_html_e('Add New Row', 'sumodiscounts'); ?></span>

                    <?php
                    break;
                case 'offer_pricing':
                    $label_name = $new_fields['label'];
                    $option_name = $new_fields['name'];
                    $quantity_rule = isset($get_data['sumo_offer_rule']) ? $get_data['sumo_offer_rule'] : array();
                    ?>
                    <div class="sumo_offer_rule">
                        <?php
                        if (is_array($quantity_rule) && !empty($quantity_rule)) {
                            foreach ($quantity_rule as $key => $value) {
                                $get_datas = $quantity_rule[$key];
                                ?>
                                <p class="form-field sumo_rule_form" >
                                    <label>
                                        <?php esc_html_e($new_fields['label'][0], 'sumodiscounts'); ?>
                                    </label>
                                    <input type="number" min="1" step="1" required="required" class="sumo_number_input"  name="<?php echo esc_attr($nameforinputfield); ?>[<?php echo esc_attr($uniqid); ?>][sumo_offer_rule][<?php echo esc_attr($key); ?>][<?php echo esc_attr($new_fields['name'][0]); ?>]" value="<?php echo esc_attr($get_datas[$new_fields['name'][0]]); ?>"/>

                                    <label>
                                        <?php esc_html_e($new_fields['label'][1], 'sumodiscounts'); ?>
                                    </label>
                                    <input type="number" min="1" step="1" required="required" class="sumo_number_input"   name="<?php echo esc_attr($nameforinputfield); ?>[<?php echo esc_attr($uniqid); ?>][sumo_offer_rule][<?php echo esc_attr($key); ?>][<?php echo esc_attr($new_fields['name'][1]); ?>]" value="<?php echo esc_attr($get_datas[$new_fields['name'][1]]); ?>"/>

                                    <label>
                                        <?php esc_html_e($new_fields['label'][2], 'sumodiscounts'); ?>
                                    </label>
                                    <select name="<?php echo esc_attr($nameforinputfield); ?>[<?php echo esc_attr($uniqid); ?>][sumo_offer_rule][<?php echo esc_attr($key); ?>][<?php echo esc_attr($new_fields['name'][2]); ?>]">
                                        <option value="1" <?php echo selected('1', $get_datas[$new_fields['name'][2]]); ?>><?php esc_html_e('% Discount', 'sumodiscounts'); ?></option>
                                        <option value="2" <?php echo selected('2', $get_datas[$new_fields['name'][2]]); ?>><?php esc_html_e('Fixed Discount', 'sumodiscounts'); ?></option>
                                        <option value="3" <?php echo selected('3', $get_datas[$new_fields['name'][2]]); ?>><?php esc_html_e('Fixed Price', 'sumodiscounts'); ?></option>
                                    </select>

                                    <label>
                                        <?php esc_html_e($new_fields['label'][3], 'sumodiscounts'); ?>
                                    </label>

                                    <input type="number" min=".01" step="any" required="required" class="sumo_number_input" name="<?php echo esc_attr($nameforinputfield); ?>[<?php echo esc_attr($uniqid); ?>][sumo_offer_rule][<?php echo esc_attr($key); ?>][<?php echo esc_attr($new_fields['name'][3]); ?>]" value="<?php echo esc_attr($get_datas[$new_fields['name'][3]]); ?>"/>

                                    <input type="checkbox" name="<?php echo esc_attr($nameforinputfield); ?>[<?php echo esc_attr($uniqid); ?>][sumo_offer_rule][<?php echo esc_attr($key); ?>][<?php echo esc_attr($new_fields['name'][4]); ?>]" value="yes"
                                    <?php
                                    if (isset($get_datas[$new_fields['name'][4]])) {
                                        checked('yes', $get_datas[$new_fields['name'][4]]);
                                    }
                                    ?>
                                           />
                                    <label>
                                        <?php esc_html_e($new_fields['label'][4], 'sumodiscounts'); ?>
                                    </label>
                                    <span class="sumo_delete_row button-secondary"><?php esc_html_e('Delete Row', 'sumodiscounts'); ?></span>
                                </p>
                                <?php
                            }
                        }
                        ?>
                    </div>
                    <span class="add_new_row_for_offer button-primary" data-uniq_id="<?php echo esc_attr($uniqid); ?>"><?php esc_html_e('Add New Row', 'sumodiscounts'); ?></span>
                    <?php
                    break;
                case 'cart_total_pricing':
                    $label_name = $new_fields['label'];
                    $option_name = $new_fields['name'];
                    $cart_total_rule = isset($get_data['sumo_cart_total_rule']) ? $get_data['sumo_cart_total_rule'] : array();
                    ?>
                    <div class="sumo_cart_total_rule">
                        <?php
                        if (is_array($cart_total_rule) && !empty($cart_total_rule)) {
                            foreach ($cart_total_rule as $key => $value) {
                                $get_datas = $cart_total_rule[$key];
                                ?>
                                <p class="form-field sumo_rule_form" >
                                    <label>
                                        <?php esc_html_e($new_fields['label'][0], 'sumodiscounts'); ?>
                                    </label>
                                    <span class="dashicons dashicons-info" title="<?php echo esc_attr($new_fields['tooltip'][0]); ?>"></span><input type="text" class="sumo_number_input" required="required"  name="<?php echo esc_attr($nameforinputfield); ?>[<?php echo esc_attr($uniqid); ?>][sumo_cart_total_rule][<?php echo esc_attr($key); ?>][<?php echo esc_attr($new_fields['name'][0]); ?>]" value="<?php echo esc_attr($get_datas[$new_fields['name'][0]]); ?>"/>

                                    <label>
                                        <?php esc_html_e($new_fields['label'][1], 'sumodiscounts'); ?>
                                    </label>
                                    <span class="dashicons dashicons-info" title="<?php echo esc_attr($new_fields['tooltip'][1]); ?>"></span><input type="text" class="sumo_number_input" required="required"  name="<?php echo esc_attr($nameforinputfield); ?>[<?php echo esc_attr($uniqid); ?>][sumo_cart_total_rule][<?php echo esc_attr($key); ?>][<?php echo esc_attr($new_fields['name'][1]); ?>]" value="<?php echo esc_attr($get_datas[$new_fields['name'][1]]); ?>"/>

                                    <label>
                                        <?php esc_html_e($new_fields['label'][2], 'sumodiscounts'); ?>
                                    </label>
                                    <span class="dashicons dashicons-info" title="<?php echo esc_attr($new_fields['tooltip'][2]); ?>"></span><select name="<?php echo esc_attr($nameforinputfield); ?>[<?php echo esc_attr($uniqid); ?>][sumo_cart_total_rule][<?php echo esc_attr($key); ?>][<?php echo esc_attr($new_fields['name'][2]); ?>]">
                                        <option value="1" <?php echo selected('1', $get_datas[$new_fields['name'][2]]); ?>>% Discount</option>
                                        <option value="2" <?php echo selected('2', $get_datas[$new_fields['name'][2]]); ?>>Fixed Discount</option>
                                    </select>

                                    <label>
                                        <?php esc_html_e($new_fields['label'][3], 'sumodiscounts'); ?>
                                    </label>

                                    <span class="dashicons dashicons-info" title="<?php echo esc_attr($new_fields['tooltip'][3]); ?>"></span><input type="number" class="sumo_number_input"  step="any" required="required" min=".01"  name="<?php echo esc_attr($nameforinputfield); ?>[<?php echo esc_attr($uniqid); ?>][sumo_cart_total_rule][<?php echo esc_attr($key); ?>][<?php echo esc_attr($new_fields['name'][3]); ?>]" value="<?php echo esc_attr($get_datas[$new_fields['name'][3]]); ?>"/>

                                    <span class="sumo_delete_row button-secondary"><?php esc_html_e('Delete Row', 'sumodiscounts'); ?></span>
                                </p>
                                <?php
                            }
                        }
                        ?>
                    </div>
                    <span class="add_new_row_for_cart_total button-primary" data-uniq_id="<?php echo esc_attr($uniqid); ?>"><?php esc_html_e('Add New Row', 'sumodiscounts'); ?></span>

                    <?php
                    break;
            }
        }
        $get_data = ob_get_clean();
        return $get_data;
    }

}

// Sort the Array Function
if (!function_exists('fpsd_array_sort_by_key')) {

    function fpsd_array_sort_by_key($array1, $array2) {
        $array3 = array();
        foreach ($array2 as $key) {
            if (isset($array1[$key])) {
                $array3[$key] = $array1[$key];
                unset($array1[$key]);
            }
        }
        return $array3 + $array1;
    }

}

if (!function_exists('fpsd_log_to_find_error')) {

    function fpsd_log_to_find_error($msg) {
        $bt = debug_backtrace();
        $caller = array_shift($bt);
        return $caller;
    }

}

if (!function_exists('fpsd_clear_session_values')) {

    function fpsd_clear_session_values() {
        if (!is_admin()) {
            global $woocommerce;
            $cart_contents = $woocommerce->cart->cart_contents;
            if (empty($cart_contents)) {
                WC()->session->__unset('cart_discount');
                WC()->session->__unset('cart_discount_value');
                WC()->session->__unset('applied_cart_discount_rule_id');
                WC()->session->__unset('applied_srp_discount_rule_id');
                WC()->session->__unset('applied_catpro_discount_rule_id');
                WC()->session->__unset('check_if_fee_exist');
            }
        }
    }

}
add_action('wp_head', 'fpsd_clear_session_values');

if (!function_exists('fpsd_product_and_category_filter')) {

    function fpsd_product_and_category_filter($productid, $newarray, $bool = false) {

        if (isset($newarray['product_type']) && '1' != $newarray['product_type'] && '2' != $newarray['product_type'] && '3' != $newarray['product_type']) {

            $category_product = fpsd_get_product($productid);
            $cat_productid = $productid;

            if ( is_object($category_product) && $category_product->is_type('variation')) {
                $cat_productid = fpsd_get_product_level_id($category_product);
            }
        }

        switch ($newarray['product_type']) {

            case '1':
                return true;
                break;

            case '2':
                if (fpsd_category_discount_include_products($productid, $newarray, $bool = false)) {
                    return true;
                }

                break;

            case '3':
                if (fpsd_category_discount_exclude_products($productid, $newarray, $bool = false)) {
                    return true;
                }

                break;

            case '4':
                if (fpsd_category_discount_all_categories($cat_productid, $newarray, $bool = false)) {
                    return true;
                }

                break;

            case '5':
                if (fpsd_category_discount_include_categories($cat_productid, $newarray, $bool = false)) {
                    return true;
                }

                break;

            case '6':
                if (fpsd_category_discount_exclude_categories($cat_productid, $newarray, $bool = false)) {
                    return true;
                }

                break;

            case '7':
                if (fpsd_category_discount_all_tags($cat_productid, $newarray, $bool = false)) {
                    return true;
                }

                break;

            case '8':
                if (fpsd_category_discount_include_tags($cat_productid, $newarray, $bool = false)) {
                    return true;
                }

                break;

            case '9':
                if (fpsd_category_discount_exclude_tags($cat_productid, $newarray, $bool = false)) {
                    return true;
                }

                break;
        }

        return false;
    }

}

if (!function_exists('fpsd_category_discount_include_products')) {

    function fpsd_category_discount_include_products($productid, $newarray, $bool = false) {

        $include_product_in_rule = $newarray['included_products'];

        if ('' != $include_product_in_rule) {

            if (is_array($include_product_in_rule)) {

                $incproductrule = $include_product_in_rule;
            } else {

                $incproductrule = explode(',', $include_product_in_rule);
            }

            if (isset($newarray['inc_condition']) && '2' == $newarray['inc_condition'] && $bool) {

                if (isset($newarray['products_in_cart']['product_ids'])) {

                    $array_sect = array_intersect(fpsd_dynamic_pricing_translated_array($incproductrule), $newarray['products_in_cart']['product_ids']);
                    $en_incproductrule = fpsd_dynamic_pricing_translated_array($incproductrule);
                    return ( $array_sect == $en_incproductrule );
                }
            } else if (isset($newarray['inc_condition']) && '3' == $newarray['inc_condition'] && $bool) {

                if (isset($newarray['products_in_cart']['product_ids'])) {

                    $array_sect = array_intersect(fpsd_dynamic_pricing_translated_array($incproductrule), $newarray['products_in_cart']['product_ids']);
                    $en_incproductrule = fpsd_dynamic_pricing_translated_array($incproductrule);
                    return ( $array_sect == $en_incproductrule && $array_sect == $newarray['products_in_cart']['product_ids'] );
                }
            } else {

                if (in_array($productid, fpsd_dynamic_pricing_translated_array($incproductrule))) {

                    return true;
                }
            }
        }

        return false;
    }

}

if (!function_exists('fpsd_category_discount_exclude_products')) {

    function fpsd_category_discount_exclude_products($productid, $newarray, $bool = false) {

        $exclude_product_in_rule = $newarray['excluded_products'];

        if ('' != $exclude_product_in_rule) {

            if (is_array($exclude_product_in_rule)) {

                $excproductrule = $exclude_product_in_rule;
            } else {

                $excproductrule = explode(',', $exclude_product_in_rule);
            }
            if (in_array($productid, fpsd_dynamic_pricing_translated_array($excproductrule))) {

                return false;
            } else {

                return true;
            }
        } else {

            return false;
        }
    }

}

if (!function_exists('fpsd_category_discount_all_categories')) {

    function fpsd_category_discount_all_categories($cat_productid, $newarray, $bool = false) {

        $categoryid = fpsd_get_custom_taxonomies($newarray, $cat_productid, 'product_cat');

        $product_cat = fpsd_dynamic_pricing_translated_array($categoryid);

        if (is_array($product_cat) && !empty($product_cat)) {

            return true;
        }

        return false;
    }

}

if (!function_exists('fpsd_category_discount_include_categories')) {

    function fpsd_category_discount_include_categories($cat_productid, $newarray, $bool = false) {

        $categoryid = fpsd_get_custom_taxonomies($newarray, $cat_productid, 'product_cat');

        $inc_cat_in_rule = $newarray['included_category'];

        if ('' != $inc_cat_in_rule && !empty($categoryid)) {
            if (is_array($inc_cat_in_rule)) {
                $inccatinrule = $inc_cat_in_rule;
            } else {
                $inccatinrule = explode(',', $inc_cat_in_rule);
            }
            if (isset($newarray['inc_condition']) && '2' == $newarray['inc_condition'] && $bool) {
                if (isset($newarray['products_in_cart']['category_ids'])) {
                    $array_sect = array_intersect(fpsd_dynamic_pricing_translated_array($inccatinrule), $newarray['products_in_cart']['category_ids']);
                    $en_inccatinrule = fpsd_dynamic_pricing_translated_array($inccatinrule);
                    return ( $array_sect == $en_inccatinrule );
                }
            } else if (isset($newarray['inc_condition']) && '3' == $newarray['inc_condition'] && $bool) {
                if (isset($newarray['products_in_cart']['category_ids'])) {
                    $array_sect = array_intersect(fpsd_dynamic_pricing_translated_array($inccatinrule), $newarray['products_in_cart']['category_ids']);
                    $en_inccatinrule = fpsd_dynamic_pricing_translated_array($inccatinrule);
                    return ( $array_sect == $en_inccatinrule && $array_sect == $newarray['products_in_cart']['category_ids'] );
                }
            } else {
                if (array_intersect($categoryid, fpsd_dynamic_pricing_translated_array($inccatinrule))) {
                    return true;
                }
            }
        }

        return false;
    }

}

if (!function_exists('fpsd_category_discount_exclude_categories')) {

    function fpsd_category_discount_exclude_categories($cat_productid, $newarray, $bool = false) {

        $categoryid = fpsd_get_custom_taxonomies($newarray, $cat_productid, 'product_cat');

        $exc_cat_in_rule = $newarray['excluded_category'];

        if ('' != $exc_cat_in_rule && !empty($categoryid)) {
            if (is_array($exc_cat_in_rule)) {
                $exccatinrule = $exc_cat_in_rule;
            } else {
                $exccatinrule = explode(',', $exc_cat_in_rule);
            }
            if (array_intersect($categoryid, fpsd_dynamic_pricing_translated_array($exccatinrule))) {
                return false;
            } else {
                return true;
            }
        } else {
            return false;
        }
    }

}

if (!function_exists('fpsd_category_discount_all_tags')) {

    function fpsd_category_discount_all_tags($cat_productid, $newarray, $bool = false) {

        $tag_id = fpsd_get_custom_taxonomies($newarray, $cat_productid, 'product_tag');

        $product_tag = fpsd_dynamic_pricing_translated_array($tag_id);

        if (is_array($product_tag) && !empty($product_tag)) {
            return true;
        } else {
            return false;
        }
    }

}

if (!function_exists('fpsd_category_discount_include_tags')) {

    function fpsd_category_discount_include_tags($cat_productid, $newarray, $bool = false) {

        $tag_id = fpsd_get_custom_taxonomies($newarray, $cat_productid, 'product_tag');
        $inc_tag_in_rule = $newarray['included_tag'];

        if ('' != $inc_tag_in_rule && !empty($tag_id)) {
            if (is_array($inc_tag_in_rule)) {
                $inctaginrule = $inc_tag_in_rule;
            } else {
                $inctaginrule = explode(',', $inc_tag_in_rule);
            }
            if (isset($newarray['inc_condition']) && '2' == $newarray['inc_condition'] && $bool) {
                if (isset($newarray['products_in_cart']['tag_ids'])) {
                    $array_sect = array_intersect(fpsd_dynamic_pricing_translated_array($inctaginrule), $newarray['products_in_cart']['tag_ids']);
                    $en_inctaginrule = fpsd_dynamic_pricing_translated_array($inctaginrule);
                    return ( $array_sect == $en_inctaginrule );
                }
            } else if (isset($newarray['inc_condition']) && '3' == $newarray['inc_condition'] && $bool) {
                if (isset($newarray['products_in_cart']['tag_ids'])) {
                    $array_sect = array_intersect(fpsd_dynamic_pricing_translated_array($inctaginrule), $newarray['products_in_cart']['tag_ids']);
                    $en_inctaginrule = fpsd_dynamic_pricing_translated_array($inctaginrule);
                    return ( $array_sect == $en_inctaginrule && $array_sect == $newarray['products_in_cart']['tag_ids'] );
                }
            } else {
                if (array_intersect($tag_id, fpsd_dynamic_pricing_translated_array($inctaginrule))) {
                    return true;
                }
            }
        }

        return false;
    }

}

if (!function_exists('fpsd_category_discount_exclude_tags')) {

    function fpsd_category_discount_exclude_tags($cat_productid, $newarray, $bool = false) {

        $tag_id = fpsd_get_custom_taxonomies($newarray, $cat_productid, 'product_tag');
        $exc_tag_in_rule = $newarray['excluded_tag'];

        if ('' != $exc_tag_in_rule && !empty($tag_id)) {
            if (is_array($exc_tag_in_rule)) {
                $exctaginrule = $exc_tag_in_rule;
            } else {
                $exctaginrule = explode(',', $exc_tag_in_rule);
            }
            if (array_intersect($tag_id, fpsd_dynamic_pricing_translated_array($exctaginrule))) {
                return false;
            } else {
                return true;
            }
        } else {
            return false;
        }
    }

}

if (!function_exists('fpsd_get_custom_taxonomies')) {

    function fpsd_get_custom_taxonomies($newarray, $cat_productid, $taxonomy_name) {

        $category = get_the_terms($cat_productid, $taxonomy_name);

        $categoryids = array();

        if (is_array($category) && !empty($category)) {

            foreach ($category as $categorys) {

                $categoryids[] = fpsd_dynamic_pricing_taxonomy_id_from_other_lang($categorys->term_id);
            }
        }
        return $categoryids;
    }

}

if (!function_exists('fpsd_check_special_offer_to_product_and_category')) {

    function fpsd_check_special_offer_to_product_and_category($productid, $newarray, $mycategory) {
        $categoryid = array();
        $tag_id = array();
        $category_product = fpsd_get_product($productid);
        if ( is_object($category_product) && $category_product->is_type('variation')) {
            $cat_productid = fpsd_get_product_level_id($category_product);
        } else {
            $cat_productid = $productid;
        }
        $category = get_the_terms($cat_productid, 'product_cat');
        if (is_array($category)) {
            if (!empty($category)) {
                foreach ($category as $categorys) {
                    $categoryid[] = fpsd_dynamic_pricing_taxonomy_id_from_other_lang($categorys->term_id);
                }
            }
        }
        $tag = get_the_terms($cat_productid, 'product_tag');
        if (is_array($tag)) {
            if (!empty($tag)) {
                foreach ($tag as $each_tag) {
                    $tag_id[] = fpsd_dynamic_pricing_taxonomy_id_from_other_lang($each_tag->term_id);
                }
            }
        }
        if ('0' == $newarray['product_type']) {
            return true;
        } elseif ('1' == $newarray['product_type']) {
            $include_product_in_rule = $newarray['included_products'];
            if ('' != $include_product_in_rule) {
                if (is_array($include_product_in_rule)) {
                    $incproductrule = $include_product_in_rule;
                } else {
                    $incproductrule = explode(',', $include_product_in_rule);
                }
                if (in_array($productid, fpsd_dynamic_pricing_translated_array($incproductrule))) {
                    return true;
                } else {
                    return false;
                }
            } else {
                return false;
            }
        } elseif ('2' == $newarray['product_type']) {
            $exclude_product_in_rule = $newarray['excluded_products'];
            if ('' != $exclude_product_in_rule) {
                if (is_array($exclude_product_in_rule)) {
                    $excproductrule = $exclude_product_in_rule;
                } else {
                    $excproductrule = explode(',', $exclude_product_in_rule);
                }
                if (in_array($productid, fpsd_dynamic_pricing_translated_array($excproductrule))) {
                    return false;
                } else {
                    return true;
                }
            } else {
                return false;
            }
        } elseif ('3' == $newarray['product_type']) {
            $product_cat = get_the_terms($cat_productid, 'product_cat');
            $product_cat1 = array();
            if (is_array($product_cat) && !empty($product_cat)) {
                foreach ($product_cat as $each_category) {
                    $product_cat1[] = fpsd_dynamic_pricing_taxonomy_id_from_other_lang($each_category->term_id);
                }
            }
            if (is_array($product_cat) && !empty($product_cat)) {
                if (is_array($mycategory) && !empty($mycategory)) {
                    $narray = array_intersect($mycategory, fpsd_dynamic_pricing_translated_array($product_cat1));
                    if (!empty($narray)) {
                        return true;
                    }
                }
            } else {
                return false;
            }
        } elseif ('4' == $newarray['product_type']) {
            $inc_cat_in_rule = $newarray['included_category'];
            if ('' != $inc_cat_in_rule) {
                if (is_array($inc_cat_in_rule)) {
                    $inccatinrule = $inc_cat_in_rule;
                } else {
                    $inccatinrule = explode(',', $inc_cat_in_rule);
                }
                if (array_intersect($categoryid, fpsd_dynamic_pricing_translated_array($inccatinrule))) {
                    return true;
                } else {
                    return false;
                }
            } else {
                return false;
            }
        } elseif ('5' == $newarray['product_type']) {
            $exc_cat_in_rule = $newarray['excluded_category'];
            if ('' != $exc_cat_in_rule) {
                if (is_array($exc_cat_in_rule)) {
                    $exccatinrule = $exc_cat_in_rule;
                } else {
                    $exccatinrule = explode(',', $exc_cat_in_rule);
                }
                if (array_intersect($categoryid, fpsd_dynamic_pricing_translated_array($exccatinrule))) {
                    return false;
                } else {
                    return true;
                }
            } else {
                return false;
            }
        } elseif ('6' == $newarray['product_type']) {
            $inc_tag_in_rule = $newarray['included_tag'];
            if ('' != $inc_tag_in_rule) {
                if (is_array($inc_tag_in_rule)) {
                    $inctaginrule = $inc_tag_in_rule;
                } else {
                    $inctaginrule = explode(',', $inc_tag_in_rule);
                }
                if (array_intersect($tag_id, fpsd_dynamic_pricing_translated_array($inctaginrule))) {
                    return true;
                } else {
                    return false;
                }
            } else {
                return false;
            }
        } elseif ('7' == $newarray['product_type']) {
            $exc_tag_in_rule = $newarray['excluded_tag'];
            if ('' != $exc_tag_in_rule) {
                if (is_array($exc_tag_in_rule)) {
                    $exctaginrule = $exc_tag_in_rule;
                } else {
                    $exctaginrule = explode(',', $exc_tag_in_rule);
                }
                if (array_intersect($tag_id, fpsd_dynamic_pricing_translated_array($exctaginrule))) {
                    return false;
                } else {
                    return true;
                }
            } else {
                return false;
            }
        }
    }

}

if (!function_exists('fpsd_user_and_userrole_filter')) {

    function fpsd_user_and_userrole_filter($userid, $uniq_id, $newarray, $rule) {
        if (fpsd_check_for_user_purchase_history($rule, $rule['sumo_user_purchase_history'], $rule['sumo_no_of_orders_placed'], $rule['sumo_total_amount_spent_in_site'], $userid)) {
            if ('1' == $newarray['check_type']) {
                return true;
            } elseif ('2' == $newarray['check_type']) {
                if (get_userdata($userid)) {
                    $userrole = get_userdata($userid)->roles;
                    if ('1' == $rule['sumo_pricing_apply_to_user']) {
                        return true;
                    } elseif ('2' == $rule['sumo_pricing_apply_to_user']) {
                        $include_users = !is_array($newarray['included_users']) ? explode(',', $newarray['included_users']) : $newarray['included_users'];
                        if (in_array($userid, $include_users)) {
                            return true;
                        }
                    } elseif ('3' == $rule['sumo_pricing_apply_to_user']) {
                        $exclude_users = !is_array($newarray['excluded_users']) ? explode(',', $newarray['excluded_users']) : $newarray['excluded_users'];
                        if (!in_array($userid, $exclude_users)) {
                            return true;
                        }
                    } elseif ('5' == $rule['sumo_pricing_apply_to_user']) {
                        $include_userroles = is_array($newarray['included_userroles']) ? $newarray['included_userroles'] : array();
                        $array_check = array_intersect($userrole, $include_userroles);
                        if (!empty($array_check)) {
                            return true;
                        }
                    } elseif ('6' == $rule['sumo_pricing_apply_to_user']) {
                        $exclude_userroles = is_array($newarray['excluded_userroles']) ? $newarray['excluded_userroles'] : array();
                        $array_check = array_intersect($userrole, $exclude_userroles);
                        if (empty($array_check)) {
                            return true;
                        }
                    } elseif ('7' == $rule['sumo_pricing_apply_to_user']) {

                        if (class_exists('SUMOMemberships') && sumo_get_membership_levels()) {
                            $plans = is_array($newarray['include_membership_plans']) ? $newarray['include_membership_plans'] : array();
                            $member_post_id = sumo_get_member_post_id(get_current_user_id());
                            if ($member_post_id > 0) {
                                if (!empty($plans)) {
                                     $bool = true;
                                    foreach ($plans as $plan_id) {
                                        $bool = sumo_plan_is_already_had($plan_id, $member_post_id);
                                          if ($bool) {
                                            break;
                                        }
                                    return true;
                                    }
                                } else {
                                    return false;
                                }
                            }
                        }
                    } elseif ('8' == $rule['sumo_pricing_apply_to_user']) {

                        if (class_exists('SUMOMemberships') && sumo_get_membership_levels()) {

                            $plans = is_array($newarray['exclude_membership_plans']) ? $newarray['exclude_membership_plans'] : array();
                            $member_post_id = sumo_get_member_post_id(get_current_user_id());
                            if ($member_post_id > 0) {
                                if (!empty($plans)) {
                                     $bool = false;
                                    foreach ($plans as $plan_id) {
                                          $bool = sumo_plan_is_already_had($plan_id, $member_post_id);
                                            if (!$bool) {
                                               break;
                                            }                                            
                                        return true;
                                    }
                                } else {
                                    return false;
                                }
                            }
                        }
                    }
                }
            } else {
                if (!get_userdata($userid)) {
                    return true;
                }
            }
        }
    }

}

if (!function_exists('fpsd_date_filter')) {

    function fpsd_date_filter($fromdate, $todate) {
        $currentdate = strtotime(date_i18n('d-m-Y'));
        if ($fromdate && $todate) {
            if (( $currentdate >= $fromdate ) && ( $currentdate <= $todate )) {
                return true;
            } else {
                return false;
            }
        } elseif ($todate) {
            if ($currentdate <= $todate) {
                return true;
            } else {
                return false;
            }
        } elseif ($fromdate) {
            if ($currentdate >= $fromdate) {
                return true;
            } else {
                return false;
            }
        } else {
            return true;
        }
    }

}

if (!function_exists('fpsd_day_filter')) {

    function fpsd_day_filter($tabname) {
        $currentday = gmdate('l');
        $currentdays = strtolower($currentday);

        $array = array(
            'monday' => get_option('sp_restrict_pricing_on_monday_at_' . $tabname),
            'tuesday' => get_option('sp_restrict_pricing_on_tuesday_at_' . $tabname),
            'wednesday' => get_option('sp_restrict_pricing_on_wednesday_at_' . $tabname),
            'thursday' => get_option('sp_restrict_pricing_on_thursday_at_' . $tabname),
            'friday' => get_option('sp_restrict_pricing_on_friday_at_' . $tabname),
            'saturday' => get_option('sp_restrict_pricing_on_saturday_at_' . $tabname),
            'sunday' => get_option('sp_restrict_pricing_on_sunday_at_' . $tabname),
        );
        foreach ($array as $key => $value) {
            if ('yes' == $value) {
                $weedays[] = $key;
            } else {
                $weedays[] = '';
            }
        }
        if (!in_array($currentdays, $weedays)) {
            return false;
        } else {
            return true;
        }
    }

}

if (!function_exists('fpsd_select_users')) {

    function fpsd_select_users($id, $label, $classname, $uniqid, $name, $new_fields, $get_data) {
        global $woocommerce;
        $fieldname = $name . '[' . $uniqid . '][' . $new_fields['name'] . ']';
        $fieldlabel = $new_fields['label'];
        $fieldid = $new_fields['id'];
        $fieldclassname = $classname;
        ?>
        <p class="form-field">
            <b>
                <?php esc_html_e($fieldlabel); ?>
            </b>
            <?php if ((float) $woocommerce->version <= (float) ( '2.2.0' )) { ?>
                <span class="dashicons dashicons-info" title="<?php echo esc_attr($new_fields['tooltip']); ?>"></span><select class="<?php echo esc_attr($fieldclassname); ?>" name="<?php echo esc_attr($fieldname); ?>[]"  multiple="multiple" id="<?php echo esc_attr($fieldid); ?>" >
                    <?php
                    $json_ids = array();
                    $getuser = $get_data;
                    if ('' != $getuser) {
                        $listofuser = $getuser;
                        if (!is_array($listofuser)) {
                            $userids = array_filter(array_map('absint', explode(',', $listofuser)));
                        } else {
                            $userids = $listofuser;
                        }

                        foreach ($userids as $userid) {
                            $user = get_user_by('id', $userid);
                            if ($user) {
                                ?>
                                <option value="<?php echo esc_attr($userid); ?>" selected="selected"><?php echo esc_html($user->display_name) . ' (#' . absint($user->ID) . ' &ndash; ' . esc_html($user->user_email) . ')'; ?></option>
                                <?php
                            }
                        }
                    }
                    ?>
                </select>
                <?php
            } else {
                ?>
                <span class="dashicons dashicons-info" title="<?php echo esc_attr($new_fields['tooltip']); ?>"></span>
                <?php if ((float) WC()->version < (float) '3.0.0') { ?>
                    <input type="hidden" class="wc-customer-search sumo_multiselect"  name="<?php echo esc_attr($fieldname); ?>" id="<?php echo esc_attr($fieldid); ?>" data-multiple="true" data-placeholder="<?php esc_attr_e('Search Users', 'sumodiscounts'); ?>" data-selected="
                    <?php
                    $json_ids = array();
                    $get_user_id = $get_data;
                    if (!is_array($get_user_id) && (!empty($get_user_id) )) {
                        $explode_users = array_filter(explode(',', $get_user_id));
                        foreach ($explode_users as $eachuser) {
                            $user = get_user_by('id', $eachuser);
                            if ($user) {
                                $json_ids[$user->ID] = esc_html($user->display_name) . '(#' . absint($user->ID) . ' &ndash; ' . esc_html($user->user_email) . ')';
                            }
                        }
                        echo esc_attr(json_encode($json_ids));
                    }
                    ?>
                           " value="<?php echo esc_attr(implode(',', array_keys($json_ids))); ?>" data-allow_clear="true" />
                           <?php
                       } else {
                           ?>
                    <select class="wc-customer-search" data-minimum_input_length="3"  name="<?php echo esc_attr($fieldname); ?>[]" id="<?php echo esc_attr($fieldid); ?>" multiple="true" data-placeholder="<?php esc_attr_e('Search Users', 'sumodiscounts'); ?>" >
                        <?php
                        $json_ids = array();
                        if (!is_array($get_data)) {
                            $get_user_id = explode(',', $get_data);
                        } else {
                            $get_user_id = $get_data;
                        }
                        $explode_users = array_filter($get_user_id);
                        foreach ($explode_users as $eachuser) {
                            $user = get_user_by('id', $eachuser);
                            if ($user) {
                                $user_string = esc_html($user->display_name) . '(#' . absint($user->ID) . ' &ndash; ' . esc_html($user->user_email) . ')';
                                echo '<option value="' . esc_attr($eachuser) . '"' . esc_attr(selected(1, 1)) . '>' . esc_attr($user_string) . '</option>';
                            }
                        }
                        ?>
                    </select>
                    <?php
                }
            }
            ?>
        </p>
        <?php
    }

}

if (!function_exists('fpsd_select_userrole')) {

    function fpsd_select_userrole($classname, $uniqid, $nameforinputfield, $new_fields, $get_data) {
        global $woocommerce;
        ?>
        <p class="form-field">
            <b>
                <?php esc_html_e($new_fields['label'], 'sumodiscounts'); ?>
            </b>
            <span class="dashicons dashicons-info" title="<?php echo esc_attr($new_fields['tooltip']); ?>"></span><select class="<?php echo esc_attr($classname); ?> sumo_multiselect"  name="<?php echo esc_attr($nameforinputfield); ?>[<?php echo esc_attr($uniqid); ?>][<?php echo esc_attr($new_fields['name']); ?>][]" id="<?php echo esc_attr($new_fields['id']); ?>" multiple="multiple">
                <?php
                if (is_array($new_fields['options'])) {
                    if (!empty($new_fields['options'])) {
                        foreach ($new_fields['options'] as $key => $options) {
                            ?>
                            <option value="<?php echo esc_attr($key); ?>" 
                            <?php
                            if (isset($get_data[$new_fields['name']])) {
                                foreach ($get_data[$new_fields['name']] as $value) {
                                    echo esc_attr(selected($key, $value));
                                }
                            }
                            ?>
                                    ><?php echo esc_html($options); ?></option>
                                    <?php
                                }
                            }
                        }
                        ?>
            </select>
        </p>
        <?php
    }

}

if (!function_exists('fpsd_select_product')) {

    function fpsd_select_product($id, $label, $classname, $uniqid, $nameforinputfield, $new_fields, $get_data, $multiple = true) {
        global $woocommerce;
        $add_array = (float) WC()->version < (float) '3.0.0' ? '' : '[]';
        $fieldname = $nameforinputfield . '[' . $uniqid . '][' . $new_fields['name'] . ']' . $add_array;
        $fieldlabel = $new_fields['label'];
        $fieldid = $new_fields['id'];
        $fieldclassname = $classname;
        $is_multiple = $multiple ? 'multiple="multiple"' : '';
        $data_multiple = $multiple ? 'data-multiple="multiple"' : '';
        ?>
        <p class="form-field">
            <b>
                <?php esc_html_e($fieldlabel, 'sumodiscounts'); ?>
            </b>
            <?php if ((float) $woocommerce->version <= (float) ( '2.2.0' )) { ?>
                <span class="dashicons dashicons-info" title="<?php echo esc_attr($new_fields['tooltip']); ?>"></span><select class="<?php echo esc_attr($fieldclassname); ?>" name="<?php echo esc_attr($fieldname); ?>"  <?php echo esc_attr($is_multiple); ?> id="<?php echo esc_attr($fieldid); ?>">
                    <?php
                    if ('' != $get_data) {
                        if (!empty($get_data)) {
                            $list_of_produts = (array) $get_data;
                            foreach ($list_of_produts as $rs_free_id) {
                                $product = fpsd_get_product($rs_free_id);
                                if ($product) {
                                    echo '<option value="' . esc_attr($rs_free_id) . '" ';
                                    esc_attr(selected(1, 1));
                                    echo '>' .
                                    ' #' .
                                    esc_attr($rs_free_id) .
                                    ' &ndash; ' .
                                    wp_kses_post(get_the_title($rs_free_id));
                                }
                            }
                        }
                    } else {
                        ?>
                        <option value=""></option>
                        <?php
                    }
                    ?>
                </select>
            <?php } else { ?>
                <span class="dashicons dashicons-info" title="<?php echo esc_attr($new_fields['tooltip']); ?>"></span>
                <?php if ((float) WC()->version < (float) '3.0.0') { ?>
                    <input type="hidden" class="wc-product-search sumo_multiselect"  name="<?php echo esc_attr($fieldname); ?>" id="<?php echo esc_attr($fieldid); ?>" <?php echo esc_attr($data_multiple); ?> data-placeholder="<?php esc_attr_e('Search Products', 'sumodiscounts'); ?>"  data-allow_clear="true" data-selected="
                    <?php
                    $json_ids = array();
                    if ('' != $get_data) {
                        $list_of_produts = $get_data;
                        if (!is_array($list_of_produts)) {
                            $product_ids = array_filter(array_map('absint', explode(',', $get_data)));
                        } else {
                            $product_ids = $list_of_produts;
                        }
                        if (null !== $product_ids) {
                            foreach ($product_ids as $product_id) {
                                if (isset($product_id)) {
                                    $product = fpsd_get_product($product_id);
                                    if (is_object($product)) {
                                        $json_ids[$product_id] = wp_kses_post($product->get_formatted_name());
                                    }
                                }
                            } echo esc_attr(json_encode($json_ids));
                        }
                    }
                    ?>
                           " value="<?php echo esc_attr(implode(',', array_keys($json_ids))); ?>" />
                           <?php
                       } else {
                           ?>
                    <select class="wc-product-search"  name="<?php echo esc_attr($fieldname); ?> sumo_multiselect" id="<?php echo esc_attr($fieldid); ?>" data-placeholder="<?php esc_attr_e('Search Products', 'sumodiscounts'); ?>" <?php echo esc_attr($is_multiple); ?>  data-allow_clear="true">
                        <?php
                        if ('' != $get_data) {
                            if (!empty($get_data)) {
                                if (!is_array($get_data)) {
                                    $list_of_produts = explode(',', $get_data);
                                } else {
                                    $list_of_produts = $get_data;
                                }
                                foreach ($list_of_produts as $each_product) {
                                    $product_obj = fpsd_get_product($each_product);
                                    if ($product_obj) {
                                        echo '<option value="' . esc_attr($each_product) . '" ' . esc_attr(selected(1, 1)) . '>' . wp_kses_post($product_obj->get_formatted_name()) . '</option>';
                                    }
                                }
                            }
                        }
                        ?>
                    </select>
                    <?php
                }
            }
            ?>
        </p>
        <?php
    }

}

if (!function_exists('fpsd_select_category')) {

    function fpsd_select_category($classname, $uniqid, $nameforinputfield, $new_fields, $get_data) {
        global $woocommerce;
        ?>
        <p class="form-field">
            <b>
                <?php esc_html_e($new_fields['label'], 'sumodiscounts'); ?>
            </b>
            <span class="dashicons dashicons-info" title="<?php echo esc_attr($new_fields['tooltip']); ?>"></span><select  class="<?php echo esc_attr($classname); ?> sumo_multiselect_cat sumo_multiselect" name="<?php echo esc_attr($nameforinputfield); ?>[<?php echo esc_attr($uniqid); ?>][<?php echo esc_attr($new_fields['name']); ?>][]" id="<?php echo esc_attr($new_fields['id']); ?>" multiple="multiple">
                <?php
                if (is_array($new_fields['options'])) {
                    if (!empty($new_fields['options'])) {
                        foreach ($new_fields['options'] as $key => $options) {
                            ?>
                            <option value="<?php echo esc_attr($key); ?>" 
                            <?php
                            if (isset($get_data[$new_fields['name']])) {
                                foreach ($get_data[$new_fields['name']] as $value) {
                                    echo esc_attr(selected($key, $value));
                                }
                            }
                            ?>
                                    ><?php echo esc_html($options); ?></option>
                                    <?php
                                }
                            }
                        }
                        ?>
            </select>
        </p>
        <?php
    }

}

if (!function_exists('fpsd_function_to_select_tag')) {

    function fpsd_function_to_select_tag($classname, $uniqid, $nameforinputfield, $new_fields, $get_data) {

        global $woocommerce;
        ?>
        <p class="form-field">
            <b>
                <?php esc_html_e($new_fields['label'], 'sumodiscounts'); ?>
            </b>
            <span class="dashicons dashicons-info" title="<?php echo esc_attr($new_fields['tooltip']); ?>"></span><select  class="<?php echo esc_attr($classname); ?> sumo_multiselect_cat sumo_multiselect"  name="<?php echo esc_attr($nameforinputfield); ?>[<?php echo esc_attr($uniqid); ?>][<?php echo esc_attr($new_fields['name']); ?>][]" id="<?php echo esc_attr($new_fields['id']); ?>" multiple="multiple">
                <?php
                if (is_array($new_fields['options'])) {
                    if (!empty($new_fields['options'])) {
                        foreach ($new_fields['options'] as $key => $options) {
                            ?>
                            <option value="<?php echo esc_attr($key); ?>" 
                            <?php
                            if (isset($get_data[$new_fields['name']])) {
                                foreach ($get_data[$new_fields['name']] as $value) {
                                    echo esc_attr(selected($key, $value));
                                }
                            }
                            ?>
                                    ><?php echo esc_html($options); ?></option>
                                    <?php
                                }
                            }
                        }
                        ?>
            </select>
        </p>
        <?php
    }

}

if (!function_exists('fpsd_select_users_for_tab')) {

    function fpsd_select_users_for_tab($id, $label, $classname, $name, $get_data) {
        global $woocommerce;
        $fieldname = $name;
        $fieldlabel = $label;
        $fieldid = $id;
        $fieldclassname = $classname;
        if ((float) $woocommerce->version <= (float) ( '2.2.0' )) {
            ?>
            <tr valign="top">
                <th class="titledesc" scope="row">
                    <label for="<?php echo esc_attr($fieldname); ?>"><?php esc_html_e($fieldlabel, 'sumodiscounts'); ?></label>
                </th>
                <td>
                    <select class="<?php echo esc_attr($fieldclassname); ?>" name="<?php echo esc_attr($fieldname); ?>[]"  multiple="multiple" id="<?php echo esc_attr($fieldid); ?>" >
                        <?php
                        $json_ids = array();
                        $getuser = $get_data;
                        if ('' != $getuser) {
                            $listofuser = $getuser;
                            if (!is_array($listofuser)) {
                                $userids = array_filter(array_map('absint', explode(',', $listofuser)));
                            } else {
                                $userids = $listofuser;
                            }

                            foreach ($userids as $userid) {
                                $user = get_user_by('id', $userid);
                                if ($user) {
                                    ?>
                                    <option value="<?php echo esc_attr($userid); ?>" selected="selected"><?php echo esc_html($user->display_name) . ' (#' . absint($user->ID) . ' &ndash; ' . esc_html($user->user_email) . ')'; ?></option>
                                    <?php
                                }
                            }
                        }
                        ?>
                    </select>
                </td>
            </tr>
        <?php } else { ?>
            <tr valign="top">
                <th class="titledesc" scope="row">
                    <label for="<?php echo esc_attr($fieldname); ?>"><?php esc_html_e($fieldlabel); ?></label>
                </th>
                <td>
                    <?php if ((float) WC()->version < (float) '3.0.0') { ?>
                        <input type="hidden" class="wc-customer-search" name="<?php echo esc_attr($fieldname); ?>[]" id="<?php echo esc_attr($fieldid); ?>" data-multiple="true" data-placeholder="<?php esc_attr_e('Search Users', 'sumodiscounts'); ?>" data-selected="
                        <?php
                        $json_ids = array();
                        $get_user_id = $get_data;
                        if (!is_array($get_user_id) && (!empty($get_user_id) )) {
                            $explode_users = array_filter(explode(',', $get_user_id));
                            foreach ($explode_users as $eachuser) {
                                $user = get_user_by('id', $eachuser);
                                if ($user) {
                                    $json_ids[$user->ID] = esc_html($user->display_name) . '(#' . absint($user->ID) . ' &ndash; ' . esc_html($user->user_email) . ')';
                                }
                            }
                            echo esc_attr(json_encode($json_ids));
                        }
                        ?>
                               " value="<?php echo esc_attr(implode(',', array_keys($json_ids))); ?>" data-allow_clear="true" />
                               <?php
                           } else {
                               ?>
                        <select class="wc-customer-search sumo_multiselect" data-minimum_input_length="3"  name="<?php echo esc_attr($fieldname); ?>[]" id="<?php echo esc_attr($fieldid); ?>" multiple="true" data-placeholder="<?php esc_attr_e('Search Users', 'sumodiscounts'); ?>">
                            <?php
                            $json_ids = array();
                            if (!is_array($get_data)) {
                                $get_user_id = explode(',', $get_data);
                            } else {
                                $get_user_id = $get_data;
                            }
                            $explode_users = array_filter($get_user_id);
                            foreach ($explode_users as $eachuser) {
                                $user = get_user_by('id', $eachuser);
                                if ($user) {
                                    $user_string = esc_html($user->display_name) . '(#' . absint($user->ID) . ' &ndash; ' . esc_html($user->user_email) . ')';
                                    echo '<option value="' . esc_attr($eachuser) . '" ' . esc_attr(selected(1, 1)) . '>' . esc_attr($user_string) . '</option>';
                                }
                            }
                            ?>
                        </select>
                        <?php
                    }
                    ?>
                </td>
            </tr>
        <?php } ?>

        <?php
    }

}

if (!function_exists('fpsd_select_product_for_tab')) {

    function fpsd_select_product_for_tab($id, $label, $classname, $nameforinputfield, $get_data) {
        global $woocommerce;
        $add_array = (float) WC()->version < (float) '3.0.0' ? '' : '[]';
        $fieldname = $nameforinputfield . $add_array;
        $fieldlabel = $label;
        $fieldid = $id;
        $fieldclassname = $classname;
        if ((float) $woocommerce->version <= (float) ( '2.2.0' )) {
            ?>
            <tr valign="top">
                <th class="titledesc" scope="row">
                    <label for="<?php echo esc_attr($fieldname); ?>"><?php esc_html_e($fieldlabel, 'sumodiscounts'); ?></label>
                </th>
                <td>
                    <select class="<?php echo esc_attr($fieldclassname); ?>" name="<?php echo esc_attr($fieldname); ?>[]"  multiple="multiple" id="<?php echo esc_attr($fieldid); ?>">
                        <?php
                        if ('' != $get_data) {
                            if (!empty($get_data)) {
                                $list_of_produts = (array) $get_data;
                                foreach ($list_of_produts as $rs_free_id) {
                                    $product = fpsd_get_product($rs_free_id);
                                    if ($product) {
                                        echo '<option value="' . esc_attr($rs_free_id) . '" ';
                                        esc_attr(selected(1, 1));
                                        echo '>' .
                                        ' #' .
                                        esc_html($rs_free_id) . ' &ndash; ' . wp_kses_post(get_the_title($rs_free_id));
                                    }
                                }
                            }
                        } else {
                            ?>
                            <option value=""></option>
                            <?php
                        }
                        ?>
                    </select>
                </td>
            </tr>
        <?php } else { ?>
            <tr valign="top">
                <th class="titledesc" scope="row">
                    <label for="<?php echo esc_attr($fieldname); ?>"><?php esc_html_e($fieldlabel, 'sumodiscounts'); ?></label>
                </th>
                <td>
                    <?php if ((float) WC()->version < (float) '3.0.0') { ?>
                        <input type="hidden" class="wc-product-search" name="<?php echo esc_attr($fieldname); ?>" id="<?php echo esc_attr($fieldid); ?>" data-multiple="true" data-placeholder="<?php esc_attr_e('Search Products', 'sumodiscounts'); ?>"  data-allow_clear="true" data-selected="
                        <?php
                        $json_ids = array();
                        if ('' != $get_data) {
                            $list_of_produts = $get_data;
                            if (!is_array($list_of_produts)) {
                                $product_ids = array_filter(array_map('absint', explode(',', $get_data)));
                            } else {
                                $product_ids = $list_of_produts;
                            }
                            if (null !== $product_ids) {
                                foreach ($product_ids as $product_id) {
                                    if (isset($product_id)) {
                                        $product = fpsd_get_product($product_id);
                                        if (is_object($product)) {
                                            $json_ids[$product_id] = wp_kses_post($product->get_formatted_name());
                                        }
                                    }
                                } echo esc_attr(json_encode($json_ids));
                            }
                        }
                        ?>
                               " value="<?php echo esc_attr(implode(',', array_keys($json_ids))); ?>" />
                               <?php
                           } else {
                               ?>
                        <select class="wc-product-search"  name="<?php echo esc_attr($fieldname); ?>" id="<?php echo esc_attr($fieldid); ?>" multiple="multiple" data-placeholder="<?php esc_attr_e('Search Products', 'sumodiscounts'); ?>"  data-allow_clear="true">
                            <?php
                            if ('' != $get_data) {
                                if (!empty($get_data)) {
                                    if (!is_array($get_data)) {
                                        $list_of_produts = explode(',', $get_data);
                                    } else {
                                        $list_of_produts = $get_data;
                                    }
                                    foreach ($list_of_produts as $each_product) {
                                        $product_obj = fpsd_get_product($each_product);
                                        if ($product_obj) {
                                            echo '<option value="' . esc_attr($each_product) . '" ' . esc_attr(selected(1, 1)) . '>' . wp_kses_post($product_obj->get_formatted_name()) . '</option>';
                                        }
                                    }
                                }
                            }
                            ?>
                        </select>
                        <?php
                    }
                    ?>
                </td>
            </tr>
        <?php } ?>
        </p>
        <?php
    }

}

if (!function_exists('fpsd_get_no_of_orders_placed')) {

    function fpsd_get_no_of_orders_placed($user_id, $purchase_period, $from_date, $to_date) {
        global $wpdb;
        $post_query = new FPSD_Query($wpdb->prefix . 'posts', 'p');
        $post_query->select('DISTINCT `p`.ID')
                ->leftJoin($wpdb->prefix . 'postmeta', 'pm', '`p`.ID = `pm`.post_id')
                ->whereIn('`p`.post_status', array('wc-completed', 'wc-processing'))
                ->whereIn('`p`.post_type', wc_get_order_types('order-count'))
                ->where('`pm`.meta_key', '_customer_user')
                ->where('`pm`.meta_value', $user_id);

        if (!empty($from_date)) {
            $post_query->wheregte('`p`.post_date', $from_date . " 00:00:01");
        }

        if (!empty($to_date)) {
            $post_query->wherelte('`p`.post_date', $to_date . " 23:59:59");
        }

        $result = $post_query->fetchCol('`p`.ID');

        return count($result);
    }

}

if (!function_exists('fpsd_check_for_user_purchase_history')) {

    function fpsd_check_for_user_purchase_history($rule, $userpurchasehistype, $nooforderrequire, $minamtspent, $userid) {
        if (get_userdata($userid)) {
            if ('' == $userpurchasehistype) {
                return true;
            } elseif ('1' == $userpurchasehistype) {
                $no_of_orders_placed = fpsd_get_no_of_orders_placed($userid, $rule['sumo_u_p_history_time'], $rule['sumo_uph_from_datepicker'], $rule['sumo_uph_to_datepicker']);
                if ($no_of_orders_placed >= (int) $nooforderrequire) {
                    return true;
                } else {
                    return false;
                }
            } elseif ('2' == $userpurchasehistype) {
                $amount_spented = (float) fpsd_get_customer_total_spent($userid, $rule['sumo_u_p_history_time'], $rule['sumo_uph_from_datepicker'], $rule['sumo_uph_to_datepicker']);
                if ($amount_spented >= (float) $minamtspent) {
                    return true;
                }
            }
        } else {
            return true;
        }
    }

}

if (!function_exists('fpsd_get_customer_total_spent')) {

    function fpsd_get_customer_total_spent($user_id, $purchase_period, $from_date, $to_date) {
        global $wpdb;
        $post_query = new FPSD_Query($wpdb->prefix . 'postmeta', 'pm');
        $post_query->select('DISTINCT `pm`.meta_value')
                ->leftJoin($wpdb->prefix . 'posts', 'p', '`p`.ID = `pm`.post_id')
                ->leftJoin($wpdb->prefix . 'postmeta', 'pm1', '`p`.ID = `pm1`.post_id')
                ->whereIn('`p`.post_status', array('wc-completed', 'wc-processing'))
                ->whereIn('`p`.post_type', wc_get_order_types('reports'))
                ->where('`pm`.meta_key', '_order_total')
                ->where('`pm1`.meta_key', '_customer_user')
                ->where('`pm1`.meta_value', $user_id);

        if (!empty($from_date)) {
            $post_query->wheregte('`p`.post_date', $from_date . " 00:00:01");
        }

        if (!empty($to_date)) {
            $post_query->wherelte('`p`.post_date', $to_date . " 23:59:59");
        }

        $spent = $post_query->fetchCol('`pm`.meta_value');
        return array_sum($spent);
    }

}

if (!function_exists('fpsd_wc_price')) {

    function fpsd_wc_price($price) {
        if (function_exists('wc_price')) {
            return wc_price($price);
        } else {
            if (function_exists('woocommerce_price')) {
                return woocommerce_price($price);
            }
        }
    }

}

if (!function_exists('fpsd_product_search')) {


    function fpsd_product_search($name, $id, $multiple = true) {
        $data_multiple = $multiple ? 'data-multiple="true"' : '';
        $is_mulitple = $multiple ? 'multiple="true"' : '';
        if ((float) WC()->version < (float) '3.0.0') {
            ?>
            <input type="hidden" class="wc-product-search" name="<?php echo esc_attr($name); ?>" id="<?php echo esc_attr($id); ?>" <?php echo esc_attr($data_multiple); ?> data-placeholder="<?php esc_attr_e('Search Products', 'sumodiscounts'); ?>"  value="" data-allow_clear="true" />
            <?php
        } else {
            ?>
            <select class="wc-product-search" name="<?php echo esc_attr($name); ?>" id="<?php echo esc_attr($id); ?>" <?php echo esc_attr($is_mulitple); ?> data-placeholder="<?php esc_attr_e('Search Products', 'sumodiscounts'); ?>"  value="" data-allow_clear="true" ></select>
            <?php
        }
    }

}
if (!function_exists('fpsd_customer_search')) {

    function fpsd_customer_search($name, $id) {
        if ((float) WC()->version < (float) '3.0.0') {
            ?>
            <input type="hidden" class="wc-customer-search" name="<?php echo esc_attr($name); ?>" id="<?php echo esc_attr($id); ?>" data-multiple="true" data-placeholder="<?php esc_attr_e('Search Users', 'sumodiscounts'); ?>"  value="" data-allow_clear="true" />
            <?php
        } else {
            ?>
            <select class="wc-customer-search" data-minimum_input_length="3" name="<?php echo esc_attr($name); ?>[]" id="<?php echo esc_attr($id); ?>" multiple="true" data-placeholder="<?php esc_attr_e('Search Users', 'sumodiscounts'); ?>"  value="" data-allow_clear="true" ></select>
            <?php
        }
    }

}

if (!function_exists('fpsd_deprecated_hooks')) {

    function fpsd_deprecated_hooks($hook_name) {
        if ((float) WC()->version >= (float) '3.0.0') {
            $deprecated_hooks = array(
                'woocommerce_structured_data_order' => 'woocommerce_email_order_schema_markup',
                'woocommerce_add_to_cart_fragments' => 'add_to_cart_fragments',
                'woocommerce_add_to_cart_redirect' => 'add_to_cart_redirect',
                'woocommerce_product_get_width' => 'woocommerce_product_width',
                'woocommerce_product_get_height' => 'woocommerce_product_height',
                'woocommerce_product_get_length' => 'woocommerce_product_length',
                'woocommerce_product_get_weight' => 'woocommerce_product_weight',
                'woocommerce_product_get_sku' => 'woocommerce_get_sku',
                'woocommerce_product_get_price' => 'woocommerce_get_price',
                'woocommerce_product_get_regular_price' => 'woocommerce_get_regular_price',
                'woocommerce_product_get_sale_price' => 'woocommerce_get_sale_price',
                'woocommerce_product_get_tax_class' => 'woocommerce_product_tax_class',
                'woocommerce_product_get_stock_quantity' => 'woocommerce_get_stock_quantity',
                'woocommerce_product_get_attributes' => 'woocommerce_get_product_attributes',
                'woocommerce_product_get_gallery_image_ids' => 'woocommerce_product_gallery_attachment_ids',
                'woocommerce_product_get_review_count' => 'woocommerce_product_review_count',
                'woocommerce_product_get_downloads' => 'woocommerce_product_files',
                'woocommerce_order_get_currency' => 'woocommerce_get_currency',
                'woocommerce_order_get_discount_total' => 'woocommerce_order_amount_discount_total',
                'woocommerce_order_get_discount_tax' => 'woocommerce_order_amount_discount_tax',
                'woocommerce_order_get_shipping_total' => 'woocommerce_order_amount_shipping_total',
                'woocommerce_order_get_shipping_tax' => 'woocommerce_order_amount_shipping_tax',
                'woocommerce_order_get_cart_tax' => 'woocommerce_order_amount_cart_tax',
                'woocommerce_order_get_total' => 'woocommerce_order_amount_total',
                'woocommerce_order_get_total_tax' => 'woocommerce_order_amount_total_tax',
                'woocommerce_order_get_total_discount' => 'woocommerce_order_amount_total_discount',
                'woocommerce_order_get_subtotal' => 'woocommerce_order_amount_subtotal',
                'woocommerce_order_get_tax_totals' => 'woocommerce_order_tax_totals',
                'woocommerce_get_order_refund_get_amount' => 'woocommerce_refund_amount',
                'woocommerce_get_order_refund_get_reason' => 'woocommerce_refund_reason',
                'default_checkout_billing_country' => 'default_checkout_country',
                'default_checkout_billing_state' => 'default_checkout_state',
                'default_checkout_billing_postcode' => 'default_checkout_postcode',
            );
            $key = array_search($hook_name, $deprecated_hooks);
        } else {
            $key = $hook_name;
        }
        return $key;
    }

}

if (!function_exists('fpsd_get_product_id')) {

    function fpsd_get_product_id($product) {
        if (!is_object($product)) {
            return;
        }

        if ((float) WC()->version >= '3.0.0') {
            $product_id = $product->is_type('variation') ? $product->get_parent_id() : $product->get_id();
        } else {
            $product_id = $product->variation_id ? $product->variation_id : $product->id;
        }

        return $product_id;
    }

}

if (!function_exists('fpsd_get_product_level_id')) {

    function fpsd_get_product_level_id($product) {
        if ((float) WC()->version >= '3.0.0') {
            $product_id = $product->is_type('variation') ? $product->get_parent_id() : $product->get_id();
        } else {
            $product_id = $product->id;
        }
        return $product_id;
    }

}
if (!function_exists('fpsd_get_product')) {

    function fpsd_get_product($product_id) {
        if (function_exists('wc_get_product')) {
            $product_object = wc_get_product($product_id);
        } else {
            $product_object = get_product($product_id);
        }
        return $product_object;
    }

}

if (!function_exists('fpsd_get_variation_object')) {

    function fpsd_get_variation_object($product_id, $parent_object) {
        if ((float) WC()->version >= (float) '3.0.0') {
            $product_object = wc_get_product($product_id);
        } else {
            $product_object = $parent_object->get_child($product_id);
        }
        return $product_object;
    }

}

if (!function_exists('fpsd_get_price_including_tax')) {

    function fpsd_get_price_including_tax($product, $qty, $price) {
        if ((float) WC()->version < (float) '3.0.0') {
            $price = $product->get_price_including_tax($qty, $price);
        } else {
            $price = wc_get_price_including_tax($product, array('qty' => $qty, 'price' => $price));
        }
        return $price;
    }

}

if (!function_exists('fpsd_get_price_excluding_tax')) {

    function fpsd_get_price_excluding_tax($product, $qty, $price) {
        if ((float) WC()->version < (float) '3.0.0') {
            $price = $product->get_price_excluding_tax($qty, $price);
        } else {
            $price = wc_get_price_excluding_tax($product, array('qty' => $qty, 'price' => $price));
        }
        return $price;
    }

}

if (!function_exists('fpsd_dynamic_pricing_product_id_from_other_lang')) {

    function fpsd_dynamic_pricing_product_id_from_other_lang($product_id) {
        global $sitepress;
        $id_from_other_lang = '';
        if (is_plugin_active('sitepress-multilingual-cms/sitepress.php') && is_object($sitepress)) {
            $trid = $sitepress->get_element_trid($product_id);
            $translations = $sitepress->get_element_translations($trid);
            foreach ($translations as $translation) {
                if (ICL_LANGUAGE_CODE == $translation->language_code) {
                    $id_from_other_lang = $translation->element_id;
                }
            }
            $product_id = $id_from_other_lang ? $id_from_other_lang : $product_id;
        }
        return $product_id;
    }

}

if (!function_exists('fpsd_dynamic_pricing_taxonomy_id_from_other_lang')) {

    function fpsd_dynamic_pricing_taxonomy_id_from_other_lang($taxonomy_id) {
        global $sitepress;
        $id_from_other_lang = '';
        if (is_plugin_active('sitepress-multilingual-cms/sitepress.php') && is_object($sitepress)) {
            $taxonomy_lang = icl_object_id($taxonomy_id, 'category', true, ICL_LANGUAGE_CODE); //7
            $taxonomy = get_term_by('term_taxonomy_id', $taxonomy_lang, 'category');
            $taxonomy_id = $taxonomy->term_id;
        }
        return $taxonomy_id;
    }

}

if (!function_exists('fpsd_dynamic_pricing_translated_array')) {

    function fpsd_dynamic_pricing_translated_array($array) {

        $translated_array = array();
        if (!empty($array)) {
            foreach ($array as $id) {
                $int_id = (int) $id;
                if (term_exists($int_id)) {
                    $translated_array[] = fpsd_dynamic_pricing_taxonomy_id_from_other_lang($int_id);
                } else {
                    $translated_array[] = fpsd_dynamic_pricing_product_id_from_other_lang($int_id);
                }
            }
        }
        return $translated_array;
    }

}

if (!function_exists('fpsd_dynamic_pricing_cart_quantities')) {

    function fpsd_dynamic_pricing_cart_quantities() {
        $quantities = WC()->cart->get_cart_item_quantities();
        $sdp_quantities = array();
        foreach ($quantities as $product_id => $quantity) {
            $sdp_quantities[fpsd_dynamic_pricing_product_id_from_other_lang($product_id)] = $quantity;
        }
        return $sdp_quantities;
    }

}

if (!function_exists('fpsd_dynamic_pricing_cart_contents')) {

    function fpsd_dynamic_pricing_cart_contents() {
        $items = WC()->cart->get_cart();
        $product_ids_in_cart = array();
        $categories_in_cart = array();
        $tags_in_cart = array();
        foreach ($items as $item => $values) {
            $pro_id = $values['variation_id'] ? $values['variation_id'] : $values['product_id'];
            $category = get_the_terms($values['product_id'], 'product_cat');
            if (is_array($category)) {
                if (!empty($category)) {
                    foreach ($category as $categorys) {
                        $categories_in_cart[] = fpsd_dynamic_pricing_taxonomy_id_from_other_lang($categorys->term_id);
                    }
                }
            }
            $tag = get_the_terms($values['product_id'], 'product_tag');
            if (is_array($tag)) {
                if (!empty($tag)) {
                    foreach ($tag as $each_tag) {
                        $tags_in_cart[] = fpsd_dynamic_pricing_taxonomy_id_from_other_lang($each_tag->term_id);
                    }
                }
            }
            $product_ids_in_cart[] = $pro_id;
        }
        return array('product_ids' => $product_ids_in_cart, 'category_ids' => $categories_in_cart, 'tag_ids' => $tags_in_cart);
    }

}

if (!function_exists('fpsd_check_if_free_shipping_enabled')) {

    function fpsd_check_if_free_shipping_enabled() {
        global $woocommerce;
        $shipping_methods = $woocommerce->shipping->load_shipping_methods();
        if (!isset($shipping_methods['free_shipping'])) {
            return false;
        }

        if ('yes' == $shipping_methods['free_shipping']->enabled) {
            return true;
        }

        return false;
    }

}

if (!function_exists('fpsd_get_wpml_product_id')) {

    /**
     * Get WPML product id.
     *
     * @return int
     * */
    function fpsd_get_wpml_product_id($product_id) {

        global $sitepress;

        $wpml_product_id = 0;
        // wpml_object_id_filter method from sitepress-multilingual-cms.
        if (is_object($sitepress) && function_exists('wpml_object_id_filter') && method_exists($sitepress, 'get_default_language')) {
            $wpml_product_id = wpml_object_id_filter($product_id, 'product', false, $sitepress->get_default_language());
        }

        return $wpml_product_id;
    }

}

if (!function_exists('fpsd_get_template')) {

	/**
	 * Get the other templates from themes.
	 * 
         * @since 6.1.0
	 * @return void
	 */
	function fpsd_get_template( $template_name, $args = array()) {
		wc_get_template($template_name, $args, FP_SD_PLUGIN_BASE_NAME . '/', FP_SD_PLUGIN_PATH . '/templates/');
	}

}

if (!function_exists('fpsd_get_template_html')) {

	/**
	 *  Like fpsd_get_template, but returns the HTML instead of outputting.
	 *
         *  @since 6.1.0
	 *  @return mixed
	 */
	function fpsd_get_template_html( $template_name, $args = array()) {

		ob_start();
		fpsd_get_template($template_name, $args);
		return ob_get_clean();
	}

}