<?php

/**
 * Compatibility - Sumo subscriptions.
 * 
 * Tested upto: 15.4.8
 *
 * @since 6.4.0
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit ; // Exit if accessed directly.
}

if ( ! class_exists( 'FPSD_Sumo_Subscriptions_Compatibility' ) ) {

	/**
	 * Class FPSD_Sumo_Subscriptions_Compatibility.
	 * 
	 * @since 6.4.0
	 */
	class FPSD_Sumo_Subscriptions_Compatibility extends FPSD_Compatibility {

		/**
		 * Class Constructor.
		 * 
		 * @since 6.4.0
		 */
		public function __construct() {
			$this->id = 'sumo_subscriptions' ;

			parent::__construct() ;
		}

		/**
		 * Is plugin enabled?.
		 *
		 * @since 6.4.0
		 * @return bool
		 * */
		public function is_plugin_enabled() {
			return class_exists( 'SUMOSubscriptions' ) ;
		}

		/**
		 * Front end action.
		 * 
		 * @since 6.4.0
		 */
		public function actions() {
			// Alter the product price based on sumo discounts.
			add_filter( 'sumosubscriptions_product_price_msg_for_subsc_fee', array( __CLASS__, 'alter_product_price_based_on_sumo_discounts' ), 10, 3 );
		}

		/**
		 * Alter the subscription product price based on sumo discounts.
		 * 
		 * @since 6.4.0
		 * @param float $price
		 * @param int $product_id
		 * @param object $product
		 * @return float
		 */
		public static function alter_product_price_based_on_sumo_discounts( $price, $product_id, $product ) {
						
			return fpsd_apply_sitewide_discount($price , $product) ;
		}
	}

}
