<?php

/**
 * Frontend Assets.
 * */
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}
if ( ! class_exists( 'FP_SD_Fronend_Assets' ) ) {

	/**
	 * Class.
	 */
	class FP_SD_Fronend_Assets {

		/**
		 * Suffix.
		 *
		 * @var string
		 */
		private static $suffix;

		/**
		 * Class Initialization.
		 */
		public static function init() {

			self::$suffix = defined( 'SCRIPT_DEBUG' ) && SCRIPT_DEBUG ? '' : '.min';

			add_action( 'wp_enqueue_scripts', array( __CLASS__, 'external_js_files' ), 20 );
		}

		/**
		 * Enqueue external JS files.
		 */
		public static function external_js_files() {

			// Frontend.
			wp_register_script( 'fpsd-frontend', FP_SD_PLUGIN_URL . '/js/frontend/variation-form.js', array( 'jquery' ), FP_SD_VERSION );
			wp_register_script( 'sumodiscounts_frontend', FP_SD_PLUGIN_URL . '/js/frontend/frontend.js', array( 'jquery' ), FP_SD_VERSION );
			wp_localize_script(
				'sumodiscounts_frontend',
				'fp_sd_args',
				array(
					'sd_ajax_nonce'                  => wp_create_nonce( 'secure_ajax_sd' ),
					'ajaxurl'                        => admin_url( 'admin-ajax.php' ),
					'checkout_page'                  => is_checkout(),
					'check_quantity_pricing_enabled' => ! empty( get_option( 'sumo_pricing_tab_sorting' ) ) && is_array( get_option( 'sumo_pricing_tab_sorting' ) ) ? 'yes' : 'no',
					'check_quantity_discount_table_enabled' => get_option( 'sumo_enable_quantity_pricing_table', 'disable' ),
				)
			);

			wp_enqueue_script( 'sumodiscounts_frontend' );
			wp_register_style( 'sumodiscounts_enqueue_styles', plugins_url( 'sumodiscounts/css/mywpstyle.css' ), array(), FP_SD_VERSION );
			wp_enqueue_style( 'sumodiscounts_enqueue_styles' );
		}

	}

	FP_SD_Fronend_Assets::init();
}
