<?php

/**
 * Compatibility.
 * 
 * @since 6.4.0
 */
if (!defined('ABSPATH')) {
	exit; // Exit if accessed directly.
}

if (!class_exists('FPSD_Compatibility')) {

	/**
	 * Abstract.
	 */
	abstract class FPSD_Compatibility {

		/**
		 * ID.
		 *
		 * @var string.
		 * @since 6.4.0
		 * */
		protected $id;

		/**
		 * Plugin slug.
		 *
		 * @var string.
		 * @since 6.4.0
		 * */
		protected $plugin_slug = 'fpsd';

		/**
		 * Class Constructor.
		 * 
		 * @since 6.4.0
		 * */
		public function __construct() {
			$this->process_actions();
		}

		/**
		 * Get the ID.
		 *
		 * @since 6.4.0
		 * @return string.
		 * */
		public function get_id() {
			return $this->id;
		}

		/**
		 * Is enabled?.
		 *
		 * @since 6.4.0
		 * @return bool.
		 * */
		public function is_enabled() {
			return $this->is_plugin_enabled();
		}

		/**
		 * Is plugin enabled?.
		 *
		 * @since 6.4.0
		 * @return bool.
		 * */
		public function is_plugin_enabled() {
			return true;
		}

		/**
		 * Actions.
		 * 
		 * @since 6.4.0
		 * */
		public function process_actions() {
			if (!$this->is_enabled()) {
				return;
			}

			$this->actions();

			if (is_admin()) {
				$this->admin_action();

				// Add action for external js files in backend
				add_action('admin_enqueue_scripts', array( $this, 'admin_enqueue_scripts' ));
			}

			if (!is_admin() || defined('DOING_AJAX')) {
				$this->frontend_action();

				// Add action for external js files in backend
				add_action('wp_enqueue_scripts', array( $this, 'frontend_enqueue_scripts' ));
			}
		}

		/**
		 * Admin Actions.
		 * 
		 * @since 6.4.0
		 * */
		public function admin_action() {
		}

		/**
		 * Actions.
		 * 
		 * @since 6.4.0
		 * */
		public function actions() {
		}

		/**
		 * Frontend Actions.
		 * 
		 * @since 6.4.0
		 * */
		public function frontend_action() {
		}

		/**
		 * Enqueue admin scripts.
		 * 
		 * @since 6.4.0
		 * */
		public function admin_enqueue_scripts() {
			$suffix = defined('SCRIPT_DEBUG') && SCRIPT_DEBUG ? '' : '.min';

			$this->admin_external_js_files($suffix);
			$this->admin_external_css_files($suffix);
		}

		/**
		 * Enqueue Frontend scripts.
		 * 
		 * @since 6.4.0
		 * */
		public function frontend_enqueue_scripts() {
			$suffix = defined('SCRIPT_DEBUG') && SCRIPT_DEBUG ? '' : '.min';

			$this->frontend_external_js_files($suffix);
			$this->frontend_external_css_files($suffix);
		}

		/**
		 * Enqueue frontend JS files.
		 * 
		 * @since 6.4.0
		 * */
		public function frontend_external_js_files( $suffix ) {
		}

		/**
		 * Enqueue frontend CSS files.
		 * 
		 * @since 6.4.0
		 * */
		public function frontend_external_css_files( $suffix ) {
		}

		/**
		 * Enqueue admin JS files.
		 * 
		 * @since 6.4.0
		 * */
		public function admin_external_js_files( $suffix ) {
		}

		/**
		 * Enqueue admin CSS files.
		 * 
		 * @since 6.4.0
		 * */
		public function admin_external_css_files( $suffix ) {
		}
	}

}
