<?php
/**
 * Quantity Pricing Settings Tabs
 *
 * @package Sumo Discounts\Settings Tabs
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

if ( ! class_exists( 'SUMOQuantityPricing' ) ) {

	/**
	 * Class SUMOQuantityPricing
	 */
	class SUMOQuantityPricing {

		/**
		 * Construct the Class
		 */
		public function __construct() {

			add_action( 'init', array( $this, 'sumo_pricing_default_settings' ), 103 ); // call the init function to update the default settings on page load.
			// make it appear in SUMO Discounts Discounts Rule.
			add_action( 'woocommerce_sp_settings_tabs_array', array( $this, 'initialize_tab' ) );
			// Initialize Admin Fields in Discounts Rule.
			add_action( 'woocommerce_sp_settings_tabs_sumo_quantity_pricing', array( $this, 'initialize_visual_appearance_admin_fields' ) );
			// Initialize Update Fields in Discounts Rule.
			add_action( 'woocommerce_update_options_sumo_quantity_pricing', array( $this, 'update_data_from_admin_fields' ) );
			// Add Custom Type of Field Option.
			add_action( 'woocommerce_admin_field_sumo_quantity_pricing_rule', array( $this, 'sumo_quantity_pricing_rule' ) );
			add_action( 'wp_ajax_sumo_pricing_rule_sortable_for_qty', array( $this, 'admin_request_from_ajax_sortable' ) );
			add_action( 'wp_ajax_sumo_pricing_uniqid_for_qty', array( $this, 'ajax_function_response_alteration_html' ) );
		}

		/**
		 * Function to Define Name of the Tab
		 *
		 * @since 1.0
		 * @param Array $settings_tab Settings Tabs.
		 * @return Array
		 */
		public static function initialize_tab( $settings_tab ) {
			if ( ! is_array( $settings_tab ) ) {
				$settings_tab = (array) $settings_tab;
			}

			$settings_tab['sumo_quantity_pricing'] = __( 'Quantity Discounts', 'sumodiscounts' );
			
			return array_filter( $settings_tab );
		}

		// Initialize Admin Fields in SUMO Discounts

		public static function initialize_admin_fields() {
			global $woocommerce;
			return apply_filters(
				'woocommerce_quantity_pricing_rule',
				array(
					array(
						'name' => __( 'Quantity Discounts', 'sumodiscounts' ),
						'type' => 'title',
						'id'   => '_sp_pricing_rule_settings',
					),
					array(
						'name'    => __( 'Rule Priority', 'sumodiscounts' ),
						'type'    => 'select',
						'id'      => 'sumo_quantity_pricing_priority_settings',
						'newids'  => 'sumo_quantity_pricing_priority_settings',
						'class'   => 'sumo_quantity_pricing_priority_settings',
						'options' => array(
							'1' => __( 'First Matched Rule', 'sumodiscounts' ),
							'2' => __( 'Last Matched Rule', 'sumodiscounts' ),
							'3' => __( 'Minimum Discount', 'sumodiscounts' ),
							'4' => __( 'Maximum Discount', 'sumodiscounts' ),
						),
					),
					array(
						'type' => 'sectionend',
						'id'   => '_sp_pricing_rule_settings',
					),
					array(
						'type' => 'sumo_quantity_pricing_rule',
					),
				)
			);
		}

		// Make it appear visually in SUMO Discounts

		public static function initialize_visual_appearance_admin_fields() {
			woocommerce_admin_fields( self::initialize_admin_fields() );
		}

		// Update the Settings of SUMO Discounts

		public static function update_data_from_admin_fields( $post ) {                       
			woocommerce_update_options( self::initialize_admin_fields() );
			$sumo_pricing_rule_fields_for_qty = isset( $_REQUEST['sumo_pricing_rule_fields_for_qty'] ) ? wc_clean( wp_unslash( $_REQUEST['sumo_pricing_rule_fields_for_qty'] ) ) : array();
			update_option( 'sumo_pricing_rule_fields_for_qty', $sumo_pricing_rule_fields_for_qty );
		}

		/*
		 * Initialize the Default Settings by looping this function
		 */

		public static function sumo_pricing_default_settings() {
			global $woocommerce;
			foreach ( self::initialize_admin_fields() as $setting ) {
				if ( isset( $setting['newids'] ) && isset( $setting['std'] ) ) {
					add_option( $setting['newids'], $setting['std'] );
				}
			}
		}

		// Declare the Options
		public static function sumo_quantity_pricing_rule() {
			$actionforsorting     = 'sumo_pricing_rule_sortable_for_qty';
			$actionforaddrule     = 'sumo_pricing_uniqid_for_qty';
			$classforaddlocalrule = 'add_new_row_for_quantity';
			$get_saved_data       = get_option( 'sumo_pricing_rule_fields_for_qty' );
			$pricingtype          = 'quantity';
			$array                = array(
				'actionforsorting'     => $actionforsorting,
				'actionforaddrule'     => $actionforaddrule,
				'classforaddlocalrule' => $classforaddlocalrule,
				'get_saved_data'       => $get_saved_data,
				'pricing_type'         => $pricingtype,
				'nameforinputfield'    => 'sumo_pricing_rule_fields_for_qty',
			);
			fpsd_to_add_settings_for_rule( $array );
		}

		public static function admin_request_from_ajax_sortable() {
			check_ajax_referer( 'sumo-discounts-sorting-nonce', 'sumo_discount_security' );

			if ( isset( $_REQUEST ) ) {
				update_option( 'sumo_dynamic_pricing_drag_position_for_qty', isset( $_REQUEST['data'] ) ? wc_clean( wp_unslash( array( 'data' ) ) ) : array() );
				exit();
			}
		}

		// Sort Div with Sortable Manner
		public static function ajax_function_response_alteration_html() {
			check_ajax_referer( 'sumo-discounts-rule-nonce', 'sumo_discount_security' );

			if ( isset( $_REQUEST ) ) {
				$phpuniqid = uniqid();
				$uniqid    = isset( $_REQUEST['uniq_id'] ) ? wc_clean( wp_unslash( $_REQUEST['uniq_id'] ) ) : '';                                
				if ( isset( $_REQUEST['rule_type'] ) && ( 'quantity' == wc_clean( wp_unslash( $_REQUEST['rule_type'] ) ) ) ) {
					$new_array = array(
						'unique_id'         => $uniqid,
						'phpunique_id'      => $phpuniqid,
						'nameforfields'     => 'sumo_quantity_rule',
						'rule_type'         => 'quantity_pricing',
						'nameforinputfield' => 'sumo_pricing_rule_fields_for_qty',
					);
					echo do_shortcode( fpsd_local_rule_function( $new_array ) );
				} else {
					$new_array = array(
						'unique_id'         => $uniqid,
						'phpunique_id'      => $phpuniqid,
						'nameforfields'     => 'sumo_quantity_rule',
						'rule_type'         => 'quantity',
						'nameforinputfield' => 'sumo_pricing_rule_fields_for_qty',
					);
					echo do_shortcode( fpsd_array_to_field_conversion( $new_array ) );
				}
			}
			exit();
		}

	}

	new SUMOQuantityPricing();
}
