(function( $ ) {
	'use strict';

    var ajaxCheckQueueInterval = parseInt( wpve.queue_interval );

    if( wpve.can_fetch_transcoding ){
        /**
         *
         * Query the encode queue
         *
         * @since  1.0.0
         * 
         */
        setInterval( function(){

            var requestUrl = wpve.rest_url + '/fetch-encoding';

            if( wpve.enable_admin_ajax ){
                requestUrl = wpve.admin_ajax_url + '?action=check_encode_queue';
            }        

            var jqxhr = $.ajax({
                url: requestUrl,
                type: 'GET',
                beforeSend: function( jqXHR ) {
                    jqXHR.setRequestHeader('X-WP-Nonce', wpve.rest_nonce );
                }
            })
            .done( function( responseData, textStatus, jqXHR ){
                let displayButton = false;
                /**
                 *
                 * Action trigger
                 *
                 * @since 1.0.0
                 * 
                 */
                
                $( document.body ).trigger( 'get_encoding_queue', [ responseData, textStatus, jqXHR ] );
                
                if( responseData ){

                    var attachments = responseData;

                    if( wpve.enable_admin_ajax ){
                        attachments = $.parseJSON( attachments );
                    }

                    for ( var i = 0; i < attachments.length; ++i ) {

                        var el = $( 'td.column-state .wpve-enqueue[data-attachment-id='+attachments[i].ID+']' );
                        var td = el.closest( 'td' );

                        //if( el.length !== 0 ){
                            if( attachments[i].encode_log_status == true ){
                                var percentage = parseInt( attachments[i].percentage );

                                if( percentage < 100 ){

                                    if( el.find( 'progress' ).length !== 0 ){
                                        el.find( '.progress-bar' )
                                        .css( 'width', attachments[i].percentage + '%' )
                                        .html(  attachments[i].percentage + '% ' + wpve.encoding );
                                    }
                                    else{
                                        var progress = '';

                                        progress += '<div style="height: 20px;" data-attachment-id="'+attachments[i].ID+'" data-parent-post="'+attachments[i].parent+'" class="progress wpve-progress">';
                                            progress += '<div class="progress-bar bg-success progress-bar-striped progress-bar-animated px-2" style="width: '+attachments[i].percentage+'%">';

                                                progress += attachments[i].percentage + '% ' + wpve.encoding;

                                            progress += '</div>';
                                        progress += '</div>';

                                        el.html( progress );
                                    }
                                }else{
                                    el.replaceWith( '<div class="badge bg-success badge-encoded">'+ wpve.encoded +'</div>' );
                                    displayButton = true;
                                }
                            }
                            else{
                                if( attachments[i].status == 'waiting' && attachments[i].encode_log != '' ){
                                    el.replaceWith( '<div class="badge bg-danger">'+ attachments[i].encode_log_status +'</div>' );
                                    displayButton = true;
                                } 
                            }

                            if( displayButton === true ){
                                td
                                .find( 'button.button-encode' )
                                .removeAttr( 'disabled' );
                            }
                        //}
                    }
                }
                
            });

        }, ajaxCheckQueueInterval );
    }

    /**
     *
     * Single video encode button handler
     *
     * @since  1.0.0
     * 
     */
    $( document ).on( 'click', '.button-encode', function( event ){

        event.preventDefault();

        var button = $(this);
        var wrapper = button.closest( '.encode-status' );

        var action = button.hasClass( 'button-reencode' ) ? 'requeue' : 'queue';

        var jqxhr = $.ajax({
            url: wpve.rest_url + '/' + action,
            data: {
                attachment_id : button.attr( 'data-attachment-id' ),
                parent: button.attr( 'data-parent-post' )
            },
            type: 'POST',
            beforeSend: function( jqXHR ) {
                jqXHR.setRequestHeader( 'X-WP-Nonce', wpve.rest_nonce );

                if( button.hasClass( 'button-reencode' ) ){
                    // Reset the progress
                    wrapper.find( '.encode-status__progress' ).html('');
                }

                button.attr( 'disabled', 'disabled' );
            }
        })

        .done( function( responseData, textStatus, jqXHR ){

            var output = '<div data-attachment-id="'+button.attr( 'data-attachment-id' )+'" data-parent-post="'+button.attr( 'data-parent-post' )+'" class="wpve-enqueue">';
                output += '<span class="badge bg-info>';
                    output += wpve.queued;
                output += '</span>';
            output += '<div>';

            // Reencode button
            if( ! button.hasClass( 'button-reencode' ) ){
                button.replaceWith( output );
            }

            wrapper.find( '.encode-status__progress' ).html(output);
            
            $( document.body ).trigger( 'add_queue_item', [ responseData, textStatus, jqXHR ] );
        })

        .error( function( textStatus, jqXHR ){
            button.removeAttr( 'disabled' );
            alert( textStatus.statusText );
        } );
    } );

})( jQuery );
