<?php
/**
 * Define the Youtube Importer functionality
 *
 *
 * @link       https://themeforest.net/user/phpface
 * @since      2.0
 *
 * @package    Streamtube_Core
 * @subpackage Streamtube_Core/includes
 */

/**
 *
 * @since      1.0.0
 * @package    Streamtube_Core
 * @subpackage Streamtube_Core/includes
 * @author     phpface <nttoanbrvt@gmail.com>
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

class StreamTube_Core_Youtube_Importer_Post_Type {
	/**
	 *
	 * Define advertising admin menu slug
	 *
	 * @since 2.0
	 * 
	 */
	const POST_TYPE = 'youtube_importer';

	/**
	 *
	 * Register post type
	 * 
	 */
	public function post_type() {
		$labels = array(
			'name'          => esc_html__( 'YouTube Importers', 'streamtube-core' ),
			'singular_name' => esc_html__( 'YouTube Importer', 'streamtube-core' )
		);

		$args = array(
			'label'                 => esc_html__( 'YouTube Importer', 'streamtube-core' ),
			'labels'                => $labels,
			'description'           => '',
			'public'                => true,
			'publicly_queryable'    => true,
			'show_ui'               => true,
			'show_in_rest'          => true,
			'rest_base'             => '',
			'rest_controller_class' => 'WP_REST_Posts_Controller',
			'has_archive'           => false,
			'show_in_menu'          => 'edit.php?post_type=video',
			'show_in_nav_menus'     => false,
			'delete_with_user'      => false,
			'exclude_from_search'   => true,
			'capability_type'       => 'yt_importer',
			'map_meta_cap'          => true,
			'capabilities'          => array(
				'add_schedule'             => 'add_yt_importer_schedule',
				'bulk_import'              => 'bulk_yt_importer_videos',
				'import_others_channels'   => 'import_others_yt_channels',
				'import_others_playlists'  => 'import_others_yt_playlists',
				'import_to_others_cpts'    => 'import_yt_importer_others_cpts',
				'import_tags'              => 'import_yt_importer_tags',
				'import_to_others_authors' => 'import_yt_importer_to_others_authors',
				'search_videos'            => 'search_yt_videos',
				'view_schedule_url'        => 'view_yt_importer_schedule_url'
			),
			'hierarchical'          => false,
			'rewrite'               => array(
				'slug'       => self::POST_TYPE,
				'with_front' => true
			),
			'query_var'             => true,
			'supports'              => array(
				'title',
				'excerpt',
				'author'
			),
			'menu_icon'             => 'icon-youtube',
			'show_ui_frontend'      => true
		);

		register_post_type( self::POST_TYPE, $args );
	}

	/**
	 * Removes support for specific features from the custom post type.
	 *
	 * This method disables support for the following features:
	 * - 'live_chat': Removes live chat functionality.
	 * - 'wpstatistics': Disables WP Statistics integration.
	 * - 'location': Removes location-related functionality.
	 *
	 * @return void
	 */
	public function remove_post_type_support() {
		remove_post_type_support( self::POST_TYPE, 'live_chat' );
		remove_post_type_support( self::POST_TYPE, 'wpstatistics' );
		remove_post_type_support( self::POST_TYPE, 'location' );
	}
}