<?php

if( ! defined( 'ABSPATH' ) ){
    exit;
}

wp_enqueue_style( 'select2' );
wp_enqueue_script( 'select2' );

global $post;

$importer = streamtube_core()->get()->yt_importer;

$settings = $importer->admin->get_settings( $post->ID );

$post_type_cap = get_post_type_object( $post->post_type )->cap;

$lists = $importer->get_importable_lists();
?>
<?php printf(
	'<table class="%s yt-settings-table wp-list-table" id="yt-settings-table">',
	is_admin() ? 'form-table' : 'table'
);?>
	
	<tbody>

		<tr id="row-enable">
			<th scope="row">
				<label for="enable">
					<?php esc_html_e( 'Enable', 'streamtube-core' );?>
				</label>
			</th>

			<td>
				<label for="enable">
					<?php printf(
						'<input name="yt_importer[enable]" type="checkbox" id="enable" %s>',
						checked( 'on', $settings['enable'], false )
					);?>
					<?php esc_html_e( 'Enable this importer', 'streamtube-core' );?>
				</label>
			</td>			
		</tr>

		<tr id="row-authentication">
			<th scope="row">
				<label for="apikey">
					<?php esc_html_e( 'Authentication', 'streamtube-core' );?>
				</label>
			</th>

			<td>

				<?php if( $importer->oauth ): ?>
					<?php
					if( $settings['oauth'] ){

						echo '<div class="d-flex align-items-start gap-3">';

							printf(
								'<span class="badge bg-success">%s</span>',
								esc_html__( 'Connected', 'streamtube-core' )
							);

							printf(
								'<a class="badge bg-danger text-white text-decoration-none" href="%s">%s</a>',
								esc_url( $importer->create_revoke_token_url()),
								esc_html__( 'Disconnect', 'streamtube-core' )
							);
						echo '</div>';
					}else{
						printf(
							'<a href="%s" class="text-white text-capitalize %s">%s</a>',
							esc_url( $importer->create_oauth_url()),
							is_admin() ? 'button button-secondary' : 'btn btn-danger btn-sm',
							esc_html__( 'Connect your youtube account', 'streamtube-core' )
						);
					}?>
				<?php else: ?>
					<?php printf(
						'<input name="yt_importer[apikey]" type="text" id="apikey" value="%s" class="regular-text w-100 form-control">',
						esc_attr( $settings['apikey'] )
					);?>

					<?php if( current_user_can( 'manage_options' ) ): ?>
						<p class="description">
							<?php printf(
								esc_html__( 'Set a custom API key or use default key from %s.', 'streamtube-core' ),
								sprintf( 
									'<a href="%s">%s</a>',
									esc_url( admin_url( '/customize.php?autofocus[section]=google_creds' ) ),
									esc_html__( 'Google APIs', 'streamtube-core' )
								)
							);?>
						</p>
					<?php endif;?>
				<?php endif;?>
			</td>			
		</tr>	

		<tr id="row-channelId">

			<th scope="row">
				<label for="channelId">
					<?php esc_html_e( 'Channel/Playlist ID', 'streamtube-core' );?>
				</label>
			</th>	
			
			<td>		

			<?php if( current_user_can( $post_type_cap->import_others_channels ) || current_user_can( $post_type_cap->import_others_playlists ) ): ?>

				<?php printf(
					'<input name="yt_importer[channelId]" type="search" id="channelId" list="channelId-suggestions" value="%s" class="regular-text w-100 form-control">',
					esc_attr( trim( $settings['channelId'] ) )
				);?>

				<?php if( $lists ) : ?>
					<datalist id="channelId-suggestions">
						<?php
						foreach ( $lists as $list => $value) {
							printf(
								'<option value="%s">%s</option>',
								esc_attr( $list ),
								esc_html( $value )
							);
						}
						?>
					</datalist>
				<?php endif;?>

			<?php else:?>

				<select name="yt_importer[channelId]" class="regular-text w-100 form-control select-select2">
					<?php if( $lists ) : ?>

						<?php printf(
							'<option value="">%s</option>',
							esc_html__( 'Select a channel/playlist.', 'streamtube-core' )
						);?>

						<?php
						foreach ( $lists as $list => $value) {
							printf(
								'<option %s value="%s">%s</option>',
								selected( $list, trim( $settings['channelId'] ), false ),
								esc_attr( $list ),
								esc_html( $value )
							);
						}
						?>		
					<?php else:?>

						<?php printf(
							'<option value="">%s</option>',
							esc_html__( 'You have no channels or playlists available.', 'streamtube-core' )
						);?>

					<?php endif;?>				
				</select>

			<?php endif;?>

			</td>		
		</tr>

		<tr id="row-forMine">
			<th scope="row">
				<label for="forMine">
					<?php esc_html_e( 'My own videos', 'streamtube-core' );?>
				</label>
			</th>

			<td>
				<label>
					<?php printf(
						'<input name="yt_importer[forMine]" type="checkbox" id="forMine" value="true" %s>',
						checked( wp_validate_boolean( $settings['forMine'] ), true, false )
					);?>
					<?php esc_html_e( 'Only search my own videos.', 'streamtube-core' );?>
				</label>
			</td>
		</tr>		
		
		<?php if( current_user_can( $post_type_cap->search_videos ) ): ?>
			<tr id="row-q">
				<th scope="row">
					<label for="q">
						<?php esc_html_e( 'Search', 'streamtube-core' );?>
					</label>
				</th>

				<td>
					<?php printf(
						'<input name="yt_importer[q]" type="search" id="q" value="%s" class="regular-text w-100 form-control">',
						esc_attr( $settings['q'] )
					);?>
					<p class="description">
						<?php esc_html_e( 'Search videos with keyword.', 'streamtube-core' );?>
					</p>
				</td>			
			</tr>			

			<tr id="row-maxResults">
				<th scope="row">
					<label for="maxResults">
						<?php esc_html_e( 'Max Results', 'streamtube-core' );?>
					</label>
				</th>

				<td>
					<?php printf(
						'<input name="yt_importer[maxResults]" type="number" id="maxResults" value="%s" class="regular-text w-100 form-control">',
						esc_attr( $settings['maxResults'] )
					);?>
					<p class="description">
						<?php esc_html_e( 'Max Results per request.', 'streamtube-core' );?>
					</p>
				</td>			
			</tr>

			<tr id="row-type">
				<th scope="row">
					<label for="type">
						<?php esc_html_e( 'Type', 'streamtube-core' );?>
					</label>
				</th>

				<td>
					<select name="yt_importer[type]" id="type" class="regular-text w-100 form-control select-select2">

						<?php foreach ( $importer->options->get_types() as $key => $value ) {
							printf(
								'<option %s value="%s">%s</option>',
								selected( $key, $settings['type'], false ),
								esc_attr( $key ),
								esc_html( $value )
							);
						}?>

					</select>
				</td>			
			</tr>

			<tr id="row-eventType">
				<th scope="row">
					<label for="eventType">
						<?php esc_html_e( 'Event Type', 'streamtube-core' );?>
					</label>
				</th>

				<td>
					<select name="yt_importer[eventType]" id="eventType" class="regular-text w-100 form-control select-select2">

						<?php foreach ( $importer->options->get_event_type() as $key => $value ) {
							printf(
								'<option %s value="%s">%s</option>',
								selected( $key, $settings['eventType'], false ),
								esc_attr( $key ),
								esc_html( $value )
							);
						}?>

					</select>

					<p class="description">
						<?php esc_html_e( 'Restricts a search to broadcast events, support Video type only.', 'streamtube-core' );?>
					</p>
				</td>			
			</tr>		

			<tr id="row-videoType">
				<th scope="row">
					<label for="videoType">
						<?php esc_html_e( 'Video Type', 'streamtube-core' );?>
					</label>
				</th>

				<td>
					<select name="yt_importer[videoType]" id="videoType" class="regular-text w-100 form-control select-select2">

						<?php foreach ( $importer->options->get_video_types() as $key => $value ) {
							printf(
								'<option %s value="%s">%s</option>',
								selected( $key, $settings['videoType'], false ),
								esc_attr( $key ),
								esc_html( $value )
							);
						}?>

					</select>
				</td>			
			</tr>

			<tr id="row-safeSearch">
				<th scope="row">
					<label for="safeSearch">
						<?php esc_html_e( 'Safe Search', 'streamtube-core' );?>
					</label>
				</th>

				<td>
					<select name="yt_importer[safeSearch]" id="safeSearch" class="regular-text w-100 form-control select-select2">

						<?php foreach ( $importer->options->get_safe_search() as $key => $value ) {
							printf(
								'<option %s value="%s">%s</option>',
								selected( $key, $settings['safeSearch'], false ),
								esc_attr( $key ),
								esc_html( $value )
							);
						}?>

					</select>
				</td>			
			</tr>

			<tr id="row-videoDefinition">
				<th scope="row">
					<label for="videoDefinition">
						<?php esc_html_e( 'Video Definition', 'streamtube-core' );?>
					</label>
				</th>

				<td>
					<select name="yt_importer[videoDefinition]" id="videoDefinition" class="regular-text w-100 form-control select-select2">

						<?php foreach ( $importer->options->get_video_definition() as $key => $value ) {
							printf(
								'<option %s value="%s">%s</option>',
								selected( $key, $settings['videoDefinition'], false ),
								esc_attr( $key ),
								esc_html( $value )
							);
						}?>

					</select>
				</td>			
			</tr>

			<tr id="row-videoDimension">
				<th scope="row">
					<label for="videoDimension">
						<?php esc_html_e( 'Video Dimension', 'streamtube-core' );?>
					</label>
				</th>

				<td>
					<select name="yt_importer[videoDimension]" id="videoDimension" class="regular-text w-100 form-control select-select2">

						<?php foreach ( $importer->options->get_video_dimension() as $key => $value ) {
							printf(
								'<option %s value="%s">%s</option>',
								selected( $key, $settings['videoDimension'], false ),
								esc_attr( $key ),
								esc_html( $value )
							);
						}?>

					</select>
				</td>			
			</tr>

			<tr id="row-videoDuration">
				<th scope="row">
					<label for="videoDuration">
						<?php esc_html_e( 'Video Duration', 'streamtube-core' );?>
					</label>
				</th>

				<td>
					<select name="yt_importer[videoDuration]" id="videoDuration" class="regular-text w-100 form-control select-select2">

						<?php foreach ( $importer->options->get_video_duration() as $key => $value ) {
							printf(
								'<option %s value="%s">%s</option>',
								selected( $key, $settings['videoDuration'], false ),
								esc_attr( $key ),
								esc_html( $value )
							);
						}?>

					</select>
				</td>			
			</tr>

			<tr id="row-videoLicense">
				<th scope="row">
					<label for="videoLicense">
						<?php esc_html_e( 'Video License', 'streamtube-core' );?>
					</label>
				</th>

				<td>
					<select name="yt_importer[videoLicense]" id="videoLicense" class="regular-text w-100 form-control select-select2">

						<?php foreach ( $importer->options->get_video_license() as $key => $value ) {
							printf(
								'<option %s value="%s">%s</option>',
								selected( $key, $settings['videoLicense'], false ),
								esc_attr( $key ),
								esc_html( $value )
							);
						}?>

					</select>
				</td>			
			</tr>		

			<tr id="row-publishedAfter">
				<th scope="row">
					<label for="publishedAfter">
						<?php esc_html_e( 'Published After', 'streamtube-core' );?>
					</label>
				</th>

				<td>
					<?php printf(
						'<input name="yt_importer[publishedAfter]" type="datetime-local" id="publishedAfter" value="%s" class="regular-text w-100 form-control">',
						esc_attr( $settings['publishedAfter'] )
					);?>
					<p class="description">
						<?php esc_html_e( 'Only contain resources created at or after the specified time.', 'streamtube-core' );?>
					</p>
				</td>			
			</tr>

			<tr id="row-publishedBefore">
				<th scope="row">
					<label for="publishedBefore">
						<?php esc_html_e( 'Published Before', 'streamtube-core' );?>
					</label>
				</th>

				<td>
					<?php printf(
						'<input name="yt_importer[publishedBefore]" type="datetime-local" id="publishedBefore" value="%s" class="regular-text w-100 form-control">',
						esc_attr( $settings['publishedBefore'] )
					);?>
					<p class="description">
						<?php esc_html_e( 'Only contain resources created before or at the specified time.', 'streamtube-core' );?>
					</p>
				</td>			
			</tr>

			<tr id="row-regionCode">
				<th scope="row">
					<label for="regionCode">
						<?php esc_html_e( 'Region Code', 'streamtube-core' );?>
					</label>
				</th>

				<td>
					<select name="yt_importer[regionCode]" id="regionCode" class="regular-text w-100 form-control select-select2">
						<option value=""><?php esc_html__( 'Search', 'streamtube-core' );?></option>
						<?php if( $codes = streamtube_core_get_iso31661alpha2() ){
							foreach ( $codes as $code => $name ) {
								printf(
									'<option %s value="%s">%s</option>',
									selected( $code, $settings['regionCode'], false ),
									esc_attr( $code ),
									esc_html( $name )
								);
							}
						}?>
					</select>
				</td>			
			</tr>

			<tr id="row-relevanceLanguage">
				<th scope="row">
					<label for="relevanceLanguage">
						<?php esc_html_e( 'Relevance Language', 'streamtube-core' );?>
					</label>
				</th>

				<td>
					<select name="yt_importer[relevanceLanguage]" id="relevanceLanguage" class="regular-text w-100 form-control select-select2">

						<option value=""><?php esc_html__( 'Search', 'streamtube-core' );?></option>

						<?php if( $languages = streamtube_core_get_language_options() ){
							foreach ( $languages as $language => $name ) {
								printf(
									'<option %s value="%s">%s</option>',
									selected( $language, $settings['relevanceLanguage'], false ),
									esc_attr( $language ),
									esc_html( $name )
								);
							}
						}?>
					</select>
				</td>			
			</tr>

			<tr id="row-order">
				<th scope="row">
					<label for="order">
						<?php esc_html_e( 'Order', 'streamtube-core' );?>
					</label>
				</th>

				<td>
					<select name="yt_importer[order]" id="order" class="regular-text w-100 form-control select-select2">

						<?php foreach ( $importer->options->get_orders() as $key => $value ) {
							printf(
								'<option %s value="%s">%s</option>',
								selected( $key, $settings['order'], false ),
								esc_attr( $key ),
								esc_html( $value )
							);
						}?>

					</select>
				</td>			
			</tr>

			<tr id="row-order_playlist_date">
				<th scope="row">
					<label for="order_playlist_date">
						<?php esc_html_e( 'Order By Playlist Date', 'streamtube-core' );?>
					</label>
				</th>

				<td>
					<label for="order_playlist_date">
						<?php printf(
							'<input name="yt_importer[order_playlist_date]" type="checkbox" id="order_playlist_date" %s>',
							checked( 'on', $settings['order_playlist_date'], false )
						);?>
					</label>
				</td>				
				
			</tr>

			<tr id="row-order_asc">
				<th scope="row">
					<label for="order_asc">
						<?php esc_html_e( 'Sort In Ascending Order', 'streamtube-core' );?>
					</label>
				</th>

				<td>
					<label for="order_asc">
						<?php printf(
							'<input name="yt_importer[order_asc]" type="checkbox" id="order_asc" %s>',
							checked( 'on', $settings['order_asc'], false )
						);?>
						<?php esc_html_e( 'Applies Only To Playlist', 'streamtube-core' );?>
					</label>
				</td>				
				
			</tr>

		<?php endif;?>

	</tbody>

</table>

<script type="text/javascript">
	jQuery( document ).ready(function() {
		jQuery( '.select-select2' ).select2({
            allowClear : true,
            placeholder : '<?php esc_js( esc_html__( 'Search', 'streamtube-core' ) ); ?>'
		});
	});
</script>

<?php

printf(
	'<input type="hidden" name="save_importer" value="%s">',
	esc_attr( wp_create_nonce( 'save_importer_nonce' ) )
);