<?php

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

global $post;

$importer = streamtube_core()->get()->yt_importer;

$settings = $importer->admin->get_settings( $post->ID );

$post_type_cap     = get_post_type_object( $post->post_type )->cap;
$can_schedule      = user_can( $post->post_author, $post_type_cap->add_schedule );
$view_schedule_url = user_can( $post->post_author, $post_type_cap->view_schedule_url );

if ( ! $can_schedule && ! $view_schedule_url ) {
	streamtube_core_the_notice(
		esc_html__( 'Owner does not have permission to schedule this importer.', 'streamtube-core' ),
		'warning'
	);
}

if ( $can_schedule || $view_schedule_url ) :
	?>
	<p>
		<?php
		printf(
			esc_html__( 'Import %s videos for each scheduled event', 'streamtube-core' ),
			sprintf(
				'<input style="max-width: 70px; margin: 0 .5rem" type="number" name="yt_importer[update_number]" class="regular-text w-auto d-inline-block form-control video-number bg-light" value="%s">',
				$settings['update_number']
			)
		); ?>

		<?php if ( $can_schedule ) : ?>
		<p>
			<?php esc_html_e( 'And run it', 'streamtube-core' ); ?>
			<select class="ms-1 bg-light form-control regular-text w-auto d-inline-block" name="yt_importer[cron_interval]"
				value="<?php echo esc_attr( $settings['cron_interval'] ) ?>">
				<option value="" <?php selected( '', $settings['cron_interval'], true ); ?>>
					<?php esc_html_e( 'None', 'streamtube-core' ); ?>
				</option>
				<?php foreach ( $importer->get_schedules() as $key => $value ) : ?>
					<?php printf(
						'<option %s value="%s">%s</option>',
						selected( $key, $settings['cron_interval'], false ),
						esc_attr( $key ),
						esc_html( $value['display'] )
					); ?>
				<?php endforeach ?>
			</select>

			<?php
			if ( wp_next_scheduled( 'streamtube_youtube_imports', array( $post->ID ) ) ) {
				printf(
					'<span class="badge bg-success">%s</span>',
					esc_html__( 'Scheduled', 'streamtube-core' )
				);
			} else {
				printf(
					'<span class="badge bg-warning">%s</span>',
					esc_html__( 'Not scheduled', 'streamtube-core' )
				);
			} ?>
		</p>
	<?php endif; ?>

	</p>

	<?php if ( ! defined( 'DISABLE_WP_CRON' ) || ( defined( 'DISABLE_WP_CRON' ) && DISABLE_WP_CRON === true ) && $can_schedule ) : ?>
		<p class="text-muted">
			<?php esc_html_e( 'Scheduling will run automatically in the background.', 'streamtube-core' ); ?>
		</p>
	<?php endif ?>

	<hr />
<?php endif; ?>

<?php if ( $view_schedule_url ) : ?>
	<p>
		<label for="cron_tag_url"><?php esc_html_e( 'CronTab URL', 'streamtube-core' ); ?></label>
		<?php printf(
			'<input onclick="javascript:this.select()" readonly type="text" id="cron_tag_url" value="%s" class="regular-text w-100 form-control">',
			esc_attr( add_query_arg( array(
				'key' => $settings['cron_tag_key']
			), get_permalink( $post->ID ) ) )
		); ?>
		<?php printf(
			'<input type="hidden" name="yt_importer[cron_tag_key]" id="cron_tag_key" value="%s">',
			esc_attr( $settings['cron_tag_key'] )
		); ?>
	</p>
	<p class="description">
		<?php esc_html_e( 'Open this URL to import content manually.', 'streamtube-core' ); ?>
	</p>
<?php endif; ?>