<?php

if( ! defined( 'ABSPATH' ) ){
    exit;
}

global $post;

$importer 			= streamtube_core()->get()->yt_importer;
$imported_videos 	= $importer->get_imported_videos( $post->ID );
$settings 			= $importer->admin->get_settings( $post->ID );

$view_all_url = '';
if( is_admin() ){
	$view_all_url = add_query_arg( array(
		'post_type'		=>	$settings['post_type'],
		'importer_id'	=>	$post->ID
	), admin_url( 'edit.php' ) );
}else{
	$view_all_url = add_query_arg( array(
		'importer_id'	=>	$post->ID
	), trailingslashit( get_author_posts_url( get_current_user_id() ) ) . 'dashboard/' . $settings['post_type'] );	
}

if( $imported_videos ){
	?>
	<div id="yt-imported-videos">
		<ul class="yt-video-list border"><?php
		for ( $i=0; $i < count( $imported_videos ); $i++) { 
			load_template( plugin_dir_path( __FILE__ ) . 'imported-video.php', false, $imported_videos[$i] );
		}
		?>
		</ul>
	</div>
	<?php

	printf(
		'<a class="btn btn-primary button button-primary button-block d-block w-100 text-center" href="%s">%s</a>',
		esc_url( $view_all_url ),
		esc_html__( 'View all', 'streamtube-core' )
	);
}else{
	printf(
		'<p class="text-muted">%s</p>',
		esc_html__( 'No videos.', 'streamtube-core' )
	);
}