<?php
if( ! defined('ABSPATH' ) ){
    exit;
}

if( isset( $_REQUEST['post_id'] ) && ! StreamTube_Core_Permission::can_edit_post( $_REQUEST['post_id'] ) ){
	streamtube_core_the_notice(
		esc_html__( 'You do not have permission to view the statistics for this post.', 'streamtube-core' ),
		'danger'
	);

	return;
}

add_thickbox();

streamtube_core_the_dashboard_content_start();

	printf( '<div id="wp-statistics-%1$s" class="wp-statistics-wrap wp-statistics-wrap-%1$s">', esc_attr( $args['page_url'] ) );

		// Determine the class name
		$className = $args['callback'];

		// Check if the class exists and has a 'view' method
		if (class_exists($className) && method_exists( $className, 'view')) {
		    // Check if the class has an 'instance' method
		    if ( method_exists( $className, 'instance' ) ) {

		    	ob_start();

		        $className::instance()->view();

		        echo apply_filters( 'streamtube/core/wpstatistics/view', ob_get_clean(), $args );

		    } else {
		        // Handle the case where the class does not have an 'instance' method
		        esc_html_e('Error: The class does not have an instance method.', 'streamtube-core');
		    }
		} else {
		    // Handle the case where the class or method does not exist
		    esc_html_e('Error: The class or method does not exist.', 'streamtube-core');
		}

	echo '</div>';

streamtube_core_the_dashboard_content_end();