<?php
if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly
}

use WP_STATISTICS\Helper;

// Get the current tab and taxonomy from the request
$tab 				= isset($_REQUEST['tab']) ? sanitize_text_field(wp_unslash($_REQUEST['tab'])) : '';
$current_taxonomy 	= isset($_REQUEST['tx']) ? sanitize_text_field(wp_unslash($_REQUEST['tx'])) : 'category';

// Exit if the tab is not 'category'
if ($tab !== 'category') {
    return;
}

// Remove all query arguments from the current URL
$base_url = remove_query_arg(array_keys($_REQUEST), $_SERVER['REQUEST_URI']);

// Get the list of taxonomies
$taxonomies = Helper::get_list_taxonomy(true);

// Generate the navigation menu
if (!empty($taxonomies)) :
?>
<ul class="nav nav-tabs">
    <?php
    foreach ($taxonomies as $taxonomy => $name) {
        // Determine if the current taxonomy is active
        $is_active = ($current_taxonomy === $taxonomy) ? ' active' : '';

        // Generate the URL for the taxonomy
        $taxonomy_url = add_query_arg( array( 'tab' => $tab, 'tx' => $taxonomy ), $base_url);

        // Output the navigation item
        printf(
            '<li class="nav-item">
                <a class="text-body small nav-link%s" aria-current="page" href="%s">%s</a>
            </li>',
            esc_attr($is_active),
            esc_url($taxonomy_url),
            esc_html($name)
        );
    }
    ?>
</ul>
<?php
endif;
?>