<?php
if( ! defined( 'ABSPATH' ) ){
	exit;
}

$url = remove_query_arg( array_keys( $_REQUEST ), $_SERVER['REQUEST_URI'] );

if( isset( $_REQUEST['type'] ) ){
	$url = add_query_arg( array( 'type' => $_REQUEST['type'] ), $url );
}

$current = isset( $_REQUEST['pt'] ) ? wp_unslash( $_REQUEST['pt'] ) : 'all';
?>

<ul class="nav nav-tabs">
<?php

$post_types = streamtube_core_get_statistics_post_types( true );

$post_types = array_merge( array( 'all' => esc_html__( 'All', 'streamtube-core' ) ), $post_types );

foreach ( $post_types as $post_type => $value ) {
	?>
	<li class="nav-item">

		<?php printf(
			'<a class="text-body small nav-link%s" aria-current="page" href="%s">%s</a>',
			$current === $post_type ? ' active' : '',
			$post_type !== 'all' ? esc_url( add_query_arg( array( 'pt' => $post_type ) ) ) : $url,
			$post_type !== 'all' ? get_post_type_object( $post_type )->labels->name : $value
		);?>

	</li>
	<?php
}
?>
</ul>