<?php
if( ! defined( 'ABSPATH' ) ){
	exit;
}

$http_data = wp_parse_args( $_REQUEST, array(
	'orderby'		=>	'',
	'date_range'	=>	'total'
) );

extract( $http_data );

$date_range_label 	= esc_html__( 'All time', 'streamtube-core' );
$date_ranges 		= streamtube_core_get_date_ranges();

if( isset( $date_ranges[ $date_range ] ) ){
	$date_range_label = $date_ranges[ $date_range ];
}

if( in_array( $orderby , array( 'hits', 'post_view', 'views' )) ):?>
	<div class="date-range dropdown">
		<button class="btn shadow-none dropdown-toggle text-secondary p-2" data-bs-toggle="dropdown" data-bs-display="static" aria-expanded="false">
			<?php echo '<strong>'. $date_range_label .'</strong>'; ?>
		</button>		
		<ul class="dropdown-menu dropdown-menu-end animate slideIn">
		    <?php
		    foreach ( $date_ranges as $range => $value) :
		        printf(
		            '<li><a class="py-2 dropdown-item small %s" href="%s">%s</a></li>',
		            ($date_range == $range) ? 'active' : '',
		            esc_url(add_query_arg([
		                'date_range' 	=> $range
		            ])),
		            isset( $date_ranges[ $range ] ) ? $date_ranges[ $range ] : esc_html__( 'Unknown', 'streamtube-core' )
		        );
		    endforeach;
		    ?>
		</ul>
	</div>
<?php endif;