<?php
if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly
}

use WP_STATISTICS\Helper;
use WP_STATISTICS\Menus;
use WP_Statistics\Utils\Request;

$postId           = Request::get('post_id');
$postAuthor       = get_post_field('post_author', $postId);
$postType         = get_post_type($postId);
$postTypeSingular = Helper::getPostTypeName($postType, true);
?>

<div class="wps-content-analytics-header align-items-start">
    <?php if ( has_post_thumbnail($postId)) : ?>
        <div class="post-thumbnail ratio ratio-16x9 rounded overflow-hidden bg-dark">
            <img src="<?php echo esc_url(get_the_post_thumbnail_url($postId)); ?>">
        </div>
    <?php endif; ?>
    
    <div>
        <div class="wps-content-analytics-header__title">
            <h2 class="wps_title"><?php echo esc_html(get_the_title($postId)); ?></h2>
            <a href="<?php echo esc_url(get_the_permalink($postId)); ?>" target="_blank" title="<?php echo esc_attr(get_the_title($postId)); ?>"></a>
        </div>
        <div class="wps-content-analytics-header__info">
            <?php
            $className = in_array($postType, ['post', 'page'], true) ? $postType : 'custom';

            printf(
                '<span class="wps-content-analytics-header__type wps-content-analytics-header__type--%1$s"><a href="%2$s">%3$s</a></span>',
                esc_attr($className),
                esc_url( 
                    add_query_arg(
                        array(
                            'tab'   =>  $postType
                        ),
                        streamtube_core_statistics_page_url( 'content-analytics' )
                    ) 
                ),
                esc_html($postTypeSingular),
            )
            ?>
            <span class="wps-content-analytics-header__date_published"><?php echo esc_html(get_the_date(Helper::getDefaultDateFormat(true), $postId)); ?></span>
            <span class="wps-content-analytics-header__date_updated"><span><?php echo esc_html__('Updated on', 'wp-statistics'); ?></span> <?php echo esc_html(get_the_modified_date(Helper::getDefaultDateFormat(true), $postId)); ?></span>
            <span class="wps-content-analytics-header__author">
                <span><?php echo esc_html__('Author:', 'wp-statistics') ?></span>
                <?php printf(
                    '<a href="%s">%s</a>',
                    Helper::isAddOnActive('data-plus') ? esc_url( add_query_arg(
                            array(
                                'type' => 'single-author', 
                                'author_id' => $postAuthor
                            ),
                            streamtube_core_statistics_page_url( 'author-analytics' )
                        )
                    ) : '#',
                    get_the_author_meta('display_name', $postAuthor)
                );?>
            </span>
        </div>
        <div class="wps-content-analytics-header__tags">
            <?php

            $taxonomies = get_post_taxonomies($postId);
            $termCount  = 0;

            foreach ($taxonomies as $taxonomy) {
                $terms = get_the_terms($postId, $taxonomy);
                if ($terms) {
                    foreach ($terms as $term) {
                        ++$termCount;

                        $termClass = '';

                        if ($termCount > 8) {
                            $termClass = 'extra-item';
                        }

                        printf(
                            '<a href="%1$s" class="%2$s">%3$s</a>',
                            esc_url( add_query_arg( array(
                                'type' => 'single', 
                                'term_id' => $term->term_id
                            ), streamtube_core_statistics_page_url( 'category-analytics' ) ) ),
                            esc_attr($termClass),
                            esc_html($term->name)
                        );
                    }
                }
            }
            ?>

            <?php
            if ($termCount > 8) {
                printf(
                    '<a class="wps-content-analytics-header__tags--more js-toggle-content-tags">%s</a>',
                    esc_html__('Show more', 'wp-statistics')
                );
            }
            ?>
        </div>
    </div>
</div>