<?php
if( ! defined('ABSPATH') ){
    exit;
}

use WP_Statistics\Service\Charts\DataProvider\SocialMediaChartDataProvider;

class StreamTube_Core_WP_Statistics_SocialMediaChartDataProvider extends SocialMediaChartDataProvider{
	
    public function __construct($args){
        parent::__construct($args);

        // Set default values
        $this->args = wp_parse_args($args, [
            'source_channel' => ['social', 'paid_social'],
        ]);

        // Group by source_name
        $this->args['group_by'] = ['source_name', 'last_counter'];

        // Rest per_page to get all results
        $this->args['per_page'] = false;

        $this->visitorsModel = new StreamTube_Core_WP_Statistics_VisitorsModel();
    }    	
}