<?php
if( ! defined('ABSPATH') ){
    exit;
}

use WP_Statistics\Components\DateRange;
use WP_STATISTICS\TimeZone;
use WP_Statistics\Service\Charts\DataProvider\SearchEngineChartDataProvider;

class StreamTube_Core_WP_Statistics_SearchEngineChartDataProvider extends SearchEngineChartDataProvider{

    public function __construct($args)
    {
        parent::__construct($args);

        // Set default values
        $this->args = wp_parse_args($args, [
            'source_channel' => ['search', 'paid_search'],
        ]);

        // Group by source_name
        $this->args['group_by'] = ['source_name', 'last_counter'];

        // Rest per_page to get all results
        $this->args['per_page'] = false;

        $this->visitorsModel = new StreamTube_Core_WP_Statistics_VisitorsModel();
    }       
}