<?php
/**
 * Define the TrafficSummary functionality
 *
 * https://wordpress.org/plugins/wp-statistics/
 *
 * @link       https://themeforest.net/user/phpface
 * @since      1.0.0
 *
 * @package    Streamtube_Core
 * @subpackage Streamtube_Core/includes
 */

if( ! defined('ABSPATH' ) ){
    return;
}
use WP_Statistics\Components\View;
use WP_Statistics\Models\OnlineModel;
use WP_Statistics\Models\VisitorsModel;
use WP_Statistics\Models\ViewsModel;
use WP_Statistics\Service\Admin\Metabox\Metaboxes\TrafficSummary;

class StreamTube_Core_WP_Statistics_TrafficSummary extends TrafficSummary{

    protected $visitorsModel;

    protected $viewsModel;

    protected $onlineModel;

    public function __construct(){
        $this->visitorsModel    = new VisitorsModel();
        $this->viewsModel       = new ViewsModel();
        $this->onlineModel      = new OnlineModel(); 
    }

    public function getData(){
        $args = [
            'ignore_post_type'  => false,
            'include_total'     => true
        ];

        $view_all_statistics = StreamTube_Core_WP_Statistics_Permission::view_all_statistics();

        if( ! $view_all_statistics ){
            $args = array_merge( $args, array(
                'author_id'     =>  get_current_user_id()
            ) );
        }

        $visitors = $this->visitorsModel->getVisitorsSummary($args);

        if( $view_all_statistics ){
            $views = $this->visitorsModel->getHitsSummary($args);    
        }else{
            $views = $this->viewsModel->getViewsSummary($args);
        }
        
        $data = [
            'online'    => $this->onlineModel->countOnlines($args),
            'visitors'  => array_values(wp_list_pluck($visitors, 'visitors')),
            'hits'      => array_values(wp_list_pluck($views, $view_all_statistics ? 'hits' : 'views')),
            'labels'    => array_values(wp_list_pluck($views, 'label')),
            'keys'      => array_keys($views),
        ];

        $output = View::load('metabox/traffic-summary', ['data' => $data], true);

        return $output;        
    }
}