<?php
/**
 * Define the MostVisitedPages functionality
 *
 * https://wordpress.org/plugins/wp-statistics/
 *
 * @link       https://themeforest.net/user/phpface
 * @since      1.0.0
 *
 * @package    Streamtube_Core
 * @subpackage Streamtube_Core/includes
 */

if( ! defined('ABSPATH' ) ){
    return;
}

use WP_Statistics\Components\View;
use WP_Statistics\Utils\Query;
use WP_Statistics\Service\Admin\Metabox\Metaboxes\MostVisitedPages;

class StreamTube_Core_WP_Statistics_MostVisitedPages extends MostVisitedPages{

    public function get_resource_types(){
        $resource_type  = array();
        $post_types     = array_keys( streamtube_core_get_statistics_post_types() );

        for ( $i=0;  $i < count( $post_types );  $i++) { 
            if( ! in_array( $post_types[$i] , array( 'post', 'page', 'attachment' ) ) ){
                $resource_type[] = 'post_type_' . $post_types[$i];
            }else{
                $resource_type[] = $post_types[$i];
            }
        }

        return $resource_type;
    }

    public function getData(){

        $args = $this->getFilters();

        $args = wp_parse_args( $args, array(
            'fields'        => array( 'pages.id', 'pages.uri', 'pages.type', 'SUM(pages.count) as views' ),
            'resource_id'   => array(),
            'date'          => '',
            'page'          => 1,
            'per_page'      => 10
        ));

        if( ! StreamTube_Core_WP_Statistics_Permission::view_all_statistics() ){
            $args = array_merge( $args, array(
                'resource_type' => $this->get_resource_types(),
                'post_type'     => array_keys( streamtube_core_get_statistics_post_types() ),                 
                'author_id'     => get_current_user_id()
            ) );
        }

        /**
         *
         * Filter args
         * 
         */
        $args = apply_filters( 'streamtube/core/wpstatistics/metabox/mostvisitedpages', $args );

        // If resource_id and resource_type are empty, get all views including 404, categories, home, etc...
        if (empty($args['resource_id']) && empty($args['resource_type']) && empty( $args['author_id'] )) {
            $queries = [];

            $queries[] = Query::select($args['fields'])
                ->from('pages')
                ->where('id', '!=', '0')
                ->whereDate('date', $args['date'])
                ->groupBy('id')
                ->getQuery();

            $queries[] = Query::select($args['fields'])
                ->from('pages')
                ->where('id', '=', '0')
                ->whereDate('date', $args['date'])
                ->groupBy(['uri', 'type'])
                ->getQuery();

            $data = Query::union($queries)
                ->perPage($args['page'], $args['per_page'])
                ->orderBy('views', 'DESC')
                ->getAll();
        } else {

            $query = Query::select($args['fields'])
                ->from('pages')
                ->where('id', 'IN', $args['resource_id'])
                ->where('pages.type', 'IN', $args['resource_type'])
                ->whereDate('pages.date', $args['date'])
                ->perPage( $args['page'], $args['per_page'])
                ->orderBy('views', 'DESC')
                ->groupBy('pages.id, pages.uri, pages.type' );

            $query->join( 'posts', ['pages.id', 'posts.ID'] )
            ->where('posts.post_author', '=', $args['author_id'])
            ->where('posts.post_type', 'IN', $args['post_type'] )
            ->where('posts.post_status', 'IN', array( 'publish', 'unlist' ) );

            $data = $query->getAll();
        }
        
        $output = View::load('metabox/most-visited-pages', ['data' => $data, 'args' => $args], true);

        return $output;
    }    
}