<?php
/**
 * Define the LatestVisitor functionality
 *
 * https://wordpress.org/plugins/wp-statistics/
 *
 * @link       https://themeforest.net/user/phpface
 * @since      1.0.0
 *
 * @package    Streamtube_Core
 * @subpackage Streamtube_Core/includes
 */

if( ! defined('ABSPATH' ) ){
    exit;
}

use WP_Statistics\Service\Admin\Metabox\Metaboxes\LatestVisitor;

class StreamTube_Core_WP_Statistics_LatestVisitor extends LatestVisitor{

    public function canViewAll(){
        return StreamTube_Core_WP_Statistics_Permission::view_all_statistics();
    }

    public function isPublic(){
        return $this->canViewAll();
    }      

    public function getData(){
        $args = ['ignore_date' => true];
        $data = $this->dataProvider->getLatestVisitorsData($args);

        ob_start();

        load_template( STREAMTUBE_CORE_WP_STATISTICS_PATH . '/public/metabox/latest-visitor.php', true, ['data' => $data] );

        return ob_get_clean();
    }    
}