<?php
/**
 * Define the GlobalVisitorDistribution functionality
 *
 * https://wordpress.org/plugins/wp-statistics/
 *
 * @link       https://themeforest.net/user/phpface
 * @since      1.0.0
 *
 * @package    Streamtube_Core
 * @subpackage Streamtube_Core/includes
 */

if( ! defined('ABSPATH' ) ){
    exit;
}
use WP_Statistics\Components\View;
use WP_Statistics\Service\Admin\Metabox\Metaboxes\GlobalVisitorDistribution;

class StreamTube_Core_WP_Statistics_GlobalVisitorDistribution extends GlobalVisitorDistribution{

    public function canViewAll(){
        return StreamTube_Core_WP_Statistics_Permission::view_all_statistics();
    }  

    public function getData(){
        $args = array_merge( $this->getFilters(), array(
            'author_id' =>  ! $this->canViewAll() ? get_current_user_id() : ''
        ) );

        $data = $this->dataProvider->getMapChartData($args);

        $output = View::load('metabox/global-visitor-distribution',  ['data' => $data], true);

        return [
            'data'      => $data,
            'output'    => $output
        ];
    }    
}    