<?php
/**
 * Define the DailyTrafficTrend functionality
 *
 * https://wordpress.org/plugins/wp-statistics/
 *
 * @link       https://themeforest.net/user/phpface
 * @since      1.0.0
 *
 * @package    Streamtube_Core
 * @subpackage Streamtube_Core/includes
 */

if( ! defined('ABSPATH' ) ){
    exit;
}

use WP_Statistics\Components\View;
use WP_Statistics\Components\DateRange;
use WP_Statistics\Service\Admin\Metabox\Metaboxes\DailyTrafficTrend;

class StreamTube_Core_WP_Statistics_DailyTrafficTrend extends DailyTrafficTrend{

    public function canViewAll(){
        return StreamTube_Core_WP_Statistics_Permission::view_all_statistics();
    }    

    public function getData(){
        $args = $this->getFilters();

        if( ! $this->canViewAll() ){
            $args = array_merge( $args, array(
                'author_id' =>  get_current_user_id()
            ) );

            $TrafficChartDataProvider = new StreamTube_Core_WP_Statistics_TrafficChartDataProvider(
                array_merge( 
                    $args,
                    [
                        'prev_data' => true
                    ]
                )
            );

            $data = $TrafficChartDataProvider->getData();            
        }else{
            $data   = $this->dataProvider->getTrafficChartData( $args );
        }

        $output = View::load('metabox/daily-traffic-trend', [], true);

        return [
            'data'      => $data,
            'output'    => $output
        ];
    }   
}