<?php
/**
 * Define the CurrentlyOnline functionality
 *
 * https://wordpress.org/plugins/wp-statistics/
 *
 * @link       https://themeforest.net/user/phpface
 * @since      1.0.0
 *
 * @package    Streamtube_Core
 * @subpackage Streamtube_Core/includes
 */

if( ! defined('ABSPATH' ) ){
    exit;
}

use WP_Statistics\Components\View;
use WP_Statistics\Service\Admin\Metabox\Metaboxes\CurrentlyOnline;

class StreamTube_Core_WP_Statistics_CurrentlyOnline extends CurrentlyOnline{

    public function canViewAll(){
        return StreamTube_Core_WP_Statistics_Permission::view_all_statistics();
    }

    public function isPublic(){
        return $this->canViewAll();
    }      
}    