<?php
if( ! defined('ABSPATH') ){
    exit;
}
use WP_STATISTICS\Menus;
use WP_STATISTICS\Option;
use WP_STATISTICS\Admin_Assets;
use WP_Statistics\Utils\Request;
use WP_STATISTICS\Admin_Template;
use WP_Statistics\Components\View;
use WP_Statistics\Models\VisitorsModel;
use WP_Statistics\Service\Admin\VisitorInsights\Views\TabsView;

class StreamTube_Core_WP_Statistics_Visitors_TabsView extends TabsView{

    protected $defaultTab = 'visitors';
    protected $tabs = [
        'visitors',
        'views'
    ];

    public function __construct(){

        $this->isTrackLoggedInUsersEnabled = Option::get('visitors_log') ? true : false;

        if( $this->canViewAll() ){
            $this->tabs = array_merge( $this->tabs, array(
                'online',
                'top-visitors'
            ) );        

            if ( $this->isTrackLoggedInUsersEnabled) {
                $this->tabs[] = 'logged-in-users';
            }              
        }      

        parent::__construct();
    }

    /**
     *
     * Check if current user can view all statistics
     * 
     */
    public function canViewAll(){
        return StreamTube_Core_WP_Statistics_Permission::view_all_statistics();
    }    

    public function getVisitorsData(){

        $args = array(
            'page_info'     => true,
            'user_info'     => true
        );

        $visitorsModel = new VisitorsModel();

        if( ! $this->canViewAll() ){
            $args = array_merge( $args, array(
                'page_info'     =>  false,
                'post_type'     =>  array_keys( streamtube_core_get_statistics_post_types() ),
                'resource_type' =>  streamtube_core_get_statistics_resource_types(),
                'author_id'     =>  get_current_user_id()
            ) );
        }

        $data['data'] = $visitorsModel->getVisitorsData( $args );

        return $data;
    }

    public function getViewsData(){

        $args = array();

        if( ! $this->canViewAll() ){
            $args = array_merge( $args, array(
                'author_id' =>  get_current_user_id()
            ) );

            $TrafficChartDataProvider = new StreamTube_Core_WP_Statistics_TrafficChartDataProvider(
                array_merge( 
                    $args,
                    [
                        'prev_data' => true
                    ]
                )
            );

            $data = $TrafficChartDataProvider->getData();

            if( $data ){
                $data['traffic_chart_data'] = $data;
            }
        }else{
            $data   = $this->dataProvider->getChartsData();
        }

        wp_localize_script(Admin_Assets::$prefix, 'Wp_Statistics_Visitors_Object', $data );

        return $this->getVisitorsData();
    }

    public function render(){
        try {
            $currentTab = $this->getCurrentTab();
            $data       = $this->getTabData();
            $filters    = $this->getActiveFilters();

            $tabs = [
                [
                    'link'  => Menus::admin_url('visitors', ['tab' => 'visitors']),
                    'title' => esc_html__('Visitors', 'wp-statistics'),
                    'class' => $this->isTab('visitors') ? 'current' : '',
                ],                
                [
                    'link'  => Menus::admin_url('visitors', ['tab' => 'views']),
                    'title' => esc_html__('Views', 'wp-statistics'),
                    'class' => $this->isTab('views') ? 'current' : ''
                ]
            ];

            if( $this->canViewAll() ){
                $tabs = array_merge( $tabs, array(

                    [
                        'link'  => Menus::admin_url('visitors', ['tab' => 'online']),
                        'title' => esc_html__('Online Visitors', 'wp-statistics'),
                        'class' => $this->isTab('online') ? 'current wps-tab-link__online-visitors' : 'wps-tab-link__online-visitors',
                    ],
                    [
                        'link'  => Menus::admin_url('visitors', ['tab' => 'top-visitors']),
                        'title' => esc_html__('Top Visitors', 'wp-statistics'),
                        'class' => $this->isTab('top-visitors') ? 'current' : '',
                    ],
                    [
                        'link'    => Menus::admin_url('visitors', ['tab' => 'logged-in-users']),
                        'title'   => esc_html__('Logged-in Users', 'wp-statistics'),
                        'tooltip' => esc_html__('Track engagement from logged-in users.', 'wp-statistics'),
                        'class'   => $this->isTab('logged-in-users') ? 'current' : '',
                        'hidden'  => !$this->isTrackLoggedInUsersEnabled
                    ]
                ) );
            }

            $args = [
                'title'      => esc_html__('Visitor Insights', 'wp-statistics'),
                'pageName'   => Menus::get_page_slug('visitors'),
                'custom_get' => array_merge(['tab' => $currentTab], $filters),
                'DateRang'   => Admin_Template::DateRange(),
                'data'       => $data,
                'pagination' => Admin_Template::paginate_links([
                    'total' => isset($data['total']) ? $data['total'] : 0,
                    'echo'  => false
                ]),
                'tabs'       => $tabs
            ];

            if ($this->isTab('visitors')) {
                $args['filters'] = ['visitors'];
            }

            if ($this->isTab('logged-in-users')) {
                $args['filters'] = ['user-role'];
            }

            if (!$this->isTab('online')) {
                $args['hasDateRang'] = true;
            }

            if ($this->isTab('online')) {
                $args['real_time_button'] = true;
            }

            Admin_Template::get_template(['layout/header', 'layout/tabbed-page-header'], $args);
   
            if( file_exists( STREAMTUBE_CORE_WP_STATISTICS_PATH .  "/public/visitor-insights/$currentTab.php" ) ){
                load_template( STREAMTUBE_CORE_WP_STATISTICS_PATH .  "/public/visitor-insights/$currentTab.php", true, $args );    
            }else{
                View::load( "pages/visitor-insights/$currentTab", $args );
            }

            Admin_Template::get_template(['layout/postbox.hide', 'layout/visitors.filter', 'layout/footer'], $args);
        } catch (Exception $e) {
            Notice::renderNotice($e->getMessage(), $e->getCode(), 'error');
        }
    }

}