<?php
if( ! defined('ABSPATH') ){
    exit;
}

use WP_Statistics\Utils\Request;
use WP_STATISTICS\Admin_Template;
use WP_Statistics\Components\View;
use WP_Statistics\Utils\Query;
use WP_Statistics\Models\VisitorsModel;
use WP_Statistics\Exception\SystemErrorException;
use WP_Statistics\Service\Admin\VisitorInsights\Views\SingleVisitorView;

class StreamTube_Core_WP_Statistics_Visitors_SingleView extends SingleVisitorView{

    protected $visitorsModel;

    public function __construct(){
        $this->visitor_id = Request::get('visitor_id');

        if ( empty($this->visitor_id)) {
            throw new SystemErrorException(esc_html__('Please provide a valid visitor ID.', 'wp-statistics'));
        }

        $this->visitorsModel = new VisitorsModel();
    }    

    public function canViewAll(){
        return StreamTube_Core_WP_Statistics_Permission::view_all_statistics();
    }        

    public function getVisitorJourney($args = array()){

        $args = wp_parse_args( $args, [
            'author_id'     => $this->canViewAll() ? '' : get_current_user_id(),
            'visitor_id'    => $this->visitor_id,
            'ignore_date'   => true,
            'post_type'     => array_keys( streamtube_core_get_statistics_post_types() )
        ]);

        $result = Query::select([
            'visitor_relationships.date',
            'visitor_relationships.page_id',
        ])
            ->from('visitor_relationships')
            ->where('visitor_relationships.visitor_id', '=', $args['visitor_id'])
            ->orderBy('visitor_relationships.date')
            ->perPage( 1, apply_filters( 'streamtube/core/wpstatistics/recent_views_limit', 20 ) );

        if( $args['author_id'] ){
            $result
                ->join( 'pages', [ 'pages.page_id', 'visitor_relationships.page_id' ], [], 'LEFT' )
                ->join( 'posts', [ 'posts.ID', 'pages.id' ], [], 'LEFT' )
                ->where( 'posts.post_type', 'IN', $args['post_type'] )
                ->where('visitor_relationships.visitor_id', '=', $args['visitor_id'])
                ->where( 'posts.post_author', '=', $args['author_id'] );
        }

        return $result->getAll();
    }

    public function render(){

        $visitor = $this->visitorsModel->getVisitorData( ['visitor_id' => $this->visitor_id] );
        $visitor_journey = $this->getVisitorJourney();

        $visitorData = compact( 'visitor', 'visitor_journey' );

        $title       = $this->getTitle($visitorData);

        $args = [
            'title'          => $title,
            'backUrl'        => remove_query_arg( array_keys( $_REQUEST ), $_SERVER['REQUEST_URI'] ),
            'backTitle'      => esc_html__('Visitor Insights', 'wp-statistics'),
            'searchBoxTitle' => esc_html__('IP, Hash, Username, or Email', 'wp-statistics'),
            'data'           => $visitorData
        ];

        Admin_Template::get_template(['layout/header', 'layout/title'], $args);
        
        load_template( STREAMTUBE_CORE_WP_STATISTICS_PATH .  '/public/visitor-insights/single-visitor.php', true, $args );

        Admin_Template::get_template(['layout/footer'], $args);
    }
}