<?php
if( ! defined('ABSPATH') ){
	exit;
}

use WP_STATISTICS\Helper;
use WP_Statistics\Utils\Request;
use WP_Statistics\Service\Admin\ContentAnalytics\Views\TabsView;
use WP_Statistics\Service\Admin\ContentAnalytics\ContentAnalyticsDataProvider;

class StreamTube_Core_WP_Statistics_ContentAnalytics_TabsView extends TabsView{

	protected $defaultTab = 'video';

    public function __construct(){

    	$post_type =  Request::get( 'tab', $this->defaultTab ) ?? $this->defaultTab;

    	if( ! isset( $_REQUEST['tab'] ) ){
    		$_REQUEST['tab'] = $post_type;
    	}

    	if( ! isset( $_GET['page'] ) ){
    		$_GET['page'] = 'wps_content-analytics_page';
    	}

    	$args = compact( 'post_type' );

    	if( $post_type && ! current_user_can( get_post_type_object( $post_type )->cap->edit_others_posts ) ){
    		$args['author_id'] = get_current_user_id();
    	}

        $this->dataProvider = new ContentAnalyticsDataProvider($args);

        $this->tabs = streamtube_core_get_statistics_post_types();
    }

	public function getTabs() {
	    $tabs = [];
	    $post_types = streamtube_core_get_statistics_post_types( true );

	    // Check if 'video' exists in the post types
	    if (isset($post_types['video'])) {
	        // Add the 'video' tab first
	        $tabs[] = [
	            'link'  => add_query_arg(['tab' => 'video']),
	            'title' => Helper::getPostTypeName('video'),
	            'class' => $this->isTab('video') ? 'current' : ''
	        ];

	        // Remove 'video' from the post types array to avoid duplication
	        unset($post_types['video']);
	    }

	    // Process the remaining post types
	    foreach ($post_types as $postType) {
	        $tabs[] = [
	            'link'  => add_query_arg(['tab' => $postType]),
	            'title' => Helper::getPostTypeName($postType),
	            'class' => $this->isTab($postType) ? 'current' : ''
	        ];
	    }

	    return $tabs;
	}   


    public function isLockedTab( $tab = '' ){

    	$isLocked = true;

    	if( $tab && StreamTube_Core_Permission::can_create_posts( $tab ) ){
    		$isLocked = false;
    	}

    	return apply_filters( 'streamtube/core/wpstatistics/is_locked_post_type', $isLocked, $tab );
    }   
}