(function($) {
    "use strict";

    $( document ).on( 'click', 'button#search-product-capabilities', function(e){
        e.preventDefault();
        let list = $( 'ul#xcapabilities-search-list' );

        let button = $(this);
        let capability = $( 'input[name=search-capabilities]' ).val();

        button.attr( 'disabled', 'disabled' );

        $.post( streamtube.ajax_url,{
            'action'        : 'streamtube/core/search_capabilities',
            'capability'    : capability,
            '_wpnonce'      : streamtube._wpnonce
        }, function( response ){
            if( response.success == false ){
                if( streamtube.is_admin ){
                    alert( response.data[0].message );
                }else{
                    $.showToast( response.data, 'danger' );
                }
            }else{
                let capabilities = response.data;

                list.html('');

                if( capabilities ){
                    for (var i = 0; i < capabilities.length; i++) {
                        let _capability = '';

                        _capability += '<li class="capability border-bottom" id="'+ capabilities[i] +'"><p class="form-field"><label>'+ capabilities[i] +'</label>';
                            _capability += '<button data-value="'+ capabilities[i] +'" type="button" class="button button-small button-secondary button-add-capability p-1"><span class="dashicons dashicons-plus-alt2"></span></button>';
                        _capability += '</p></li>';

                        list.append( _capability );
                    }
                }
            }

            button.removeAttr( 'disabled' );
        } );
    } );

    $( document ).on( 'click', 'button.button-add-capability', function(e){
        e.preventDefault();

        let button = $(this);
        let li = button.closest( 'li' );
        let list = $( 'ul#xcapabilities-list' );

        let capability = button.attr( 'data-value' );

        let _capability = '';

        _capability += '<li class="capability border-bottom" id="'+ capability +'"><p class="form-field"><label>'+ capability +'</label>';
            _capability += '<input type="hidden" value="'+ capability +'" name="xcapabilities[]">';
            _capability += '<button data-value="'+ capability +'" type="button" class="button button-small button-secondary button-remove-capability bg-danger p-1"><span class="dashicons dashicons-minus text-white"></span></button>';
        _capability += '</p></li>';

        if( list.find( 'li#' + capability ).length === 0 ){
            list.append( _capability ); 
        }

        li.remove();

    } );

    $( document ).on( 'click', 'button.button-remove-capability', function(e){
        e.preventDefault();

        $(this).closest('li').remove();
    } );    

})(jQuery);