<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}
/**
 * Integrates WooCommerce Bookings with Streamtube Core.
 */
class Streamtube_Core_Woocommerce_Booking {

	/**
	 * Instance of WC_Bookings_Admin.
	 *
	 * @var WC_Bookings_Admin|null
	 */
	private $WC_Bookings_Admin = null;

	/**
	 * Constructor.
	 */
	public function __construct() {
	}

	/**
	 *
	 * WooCommerce Booking supports importing sample booking template
	 * Which redirects to WP backend after imported
	 * We catch this action and keep focus on frontend side
	 * 
	 * @param  [type] $link    [description]
	 * @param  [type] $post_id [description]
	 * @param  [type] $context [description]
	 * @return [type]          [description]
	 */
	public function filter_get_edit_post_link( $link, $post_id, $context ) {
		if ( wp_doing_ajax() && $_REQUEST['action'] === 'wc_bookings_get_product_template' ) {
			if ( preg_match( '/product\/([0-9]+|\?view=add-post)/', wp_get_referer() ) ) {
				$link = untrailingslashit( get_author_posts_url( get_current_user_id() ) ) . '/dashboard/product/' . $post_id;
			}
		}

		return $link;
	}

	/**
	 * Retrieves an instance of WC_Bookings_Admin.
	 *
	 * @return WC_Bookings_Admin|null
	 */
	private function get_wc_bookings_admin() {
		if ( null === $this->WC_Bookings_Admin && class_exists( 'WC_Bookings_Admin' ) ) {
			$this->WC_Bookings_Admin = new WC_Bookings_Admin();
		}
		return $this->WC_Bookings_Admin;
	}

	/**
	 * Initializes booking tabs.
	 *
	 * @return mixed|null
	 */
	public function init_tabs() {
		$wc_bookings_admin = $this->get_wc_bookings_admin();
		if ( ! is_admin() && $wc_bookings_admin ) {
			return $wc_bookings_admin->init_tabs();
		}
		return null;
	}

	/**
	 * Enqueues WooCommerce Bookings scripts and styles on the product dashboard.
	 */
	public function enqueue_scripts() {
		global $wp_query, $current_screen, $temp_current_screen;

		if ( isset( $wp_query->query_vars['dashboard'] ) && preg_match( '/product\/([0-9]+|\?view=add-post)/', $_SERVER['REQUEST_URI'] ) ) {

			if ( ! function_exists( 'wc_get_screen_ids' ) ) {
				require_once dirname( WC_PLUGIN_FILE ) . '/includes/admin/wc-admin-functions.php';
			}

			if ( $current_screen ) {
				// Store the original screen object.
				$temp_current_screen = $current_screen;
			}

			$wc_bookings_admin = $this->get_wc_bookings_admin();

			if ( $wc_bookings_admin ) {

				// Temporarily set the screen to 'edit-product' to load WooCommerce assets.
				set_current_screen( 'edit-product' );
				$wc_bookings_admin->styles_and_scripts();
				// Restore the original screen object.
				unset( $GLOBALS['current_screen'] );
			}

			if ( $temp_current_screen ) {
				// Restore the original screen object after processing.
				$GLOBALS['current_screen'] = $temp_current_screen;
			}
		}
	}
}