<?php
/**
 * Define the Storage functionality
 *
 *
 * @link       https://themeforest.net/user/phpface
 * @since      1.0.0
 *
 * @package    Streamtube_Core
 * @subpackage Streamtube_Core/includes
 */

/**
 *
 * @since      1.0.8
 * @package    Streamtube_Core
 * @subpackage Streamtube_Core/includes
 * @author     phpface <nttoanbrvt@gmail.com>
 */

if( ! defined('ABSPATH' ) ){
    exit;
}

function streamtube_core_get_storage_capacity_list(){

    global $streamtube;

    $url = wp_doing_ajax() ? wp_get_referer() : $_SERVER['REQUEST_URI'];

    ob_start();

    foreach ( $streamtube->get()->storage->get_quota_capacities() as $capability => $value ): ?>
        
        <?php printf(
            '<li class="bg-white border-bottom list-group-item capability-item capability-%s">',
            esc_attr( $capability )
        );?>
            <p class="text-body fw-bold"><?php echo $capability; ?></p>

            <?php
            printf(
                '<span class="text-success me-2">%s</span>',
                $value['formated']
            );
            ?>

            <?php printf(
                '<a class="ajax-elm text-danger small text-decoration-none" data-action="%s" data-nonce="%s" data-params="%s" href="#" data-confirm="%s">%s</a>',
                'streamtube/core/delete_capability',
                esc_attr( wp_create_nonce( 'delete-capability-' . $capability ) ),
                esc_attr( $capability ),
                esc_attr__( 'Delete Capacity - Warning! Be careful - deleting critical capacity could crash some plugin or other custom code.\n\n***Deleting this capacity will also remove any reference quotas manually assigned to users, as well as those purchased by users.\n\n***Feel free to delete this capacity if it is newly created, has not been assigned to any roles or users, or has not been used for any purpose.', 'streamtube-core' ),
                esc_html__( 'Delete', 'streamtube-core' )
            );?>
        </li>

    <?php endforeach;

    return ob_get_clean();
}