<?php
if( ! defined('ABSPATH' ) ){
    exit;
}

$page 		= StreamTube_Core_PMPro::PAGE_SLUG;

$mylevels 	= pmpro_getMembershipLevelsForUser();

streamtube_core_the_dashboard_head( esc_html__( 'Paid Membership', 'streamtube-core' ) );

streamtube_core_the_dashboard_content_start();
?>
	<?php if ( empty( $mylevels ) ): ?>
		<?php
		/**
		 *
		 * Fires before Plans
		 *
		 * @since 2.2
		 * 
		 */
		do_action( 'streamtube/core/pmpro/dashboard/membership/plans/before' );

		$levels_output = '';

		$levels_page_id = get_option( 'pmpro_levels_page_id' );

		if( $levels_page_id && streamtube_core_is_page_built_by_elementor( $levels_page_id ) ){
			echo streamtube_core_get_elementor_builder_content( $levels_page_id );
			
		}else{
			$levels_output = streamtube_core()->get()->pmpro->_shortcode_membership_levels(
				apply_filters( 'streamtube/core/shortcode/membership_levels_args', array() )
			);
		}

		/**
		 *
		 * Filter the output of levels
		 *
		 * @since 2.2
		 * 
		 */
		$levels_output = apply_filters( 'streamtube/core/pmpro/dashboard/membership/levels_output', $levels_output );

		if( $levels_output ){
			echo $levels_output;
		}

		/**
		 *
		 * Fires after Plans
		 *
		 * @since 2.2
		 * 
		 */
		do_action( 'streamtube/core/pmpro/dashboard/membership/plans/after' );
		?>
	<?php else: ?>

		<?php 
		streamtube_core()->get()->user_dashboard->the_menu( array(
			'user_id'		=>	get_current_user_id(),
			'base_url'		=>	get_author_posts_url( get_current_user_id() ),
			'menu_classes'	=>	'nav-tabs secondary-nav',
			'item_classes'	=>	'text-secondary d-flex align-items-center'
		), $page );?>

		<div class="bg-white p-4 border-start border-right border-bottom border-end">
			<?php 

			$part = untrailingslashit( get_query_var( 'dashboard' ) );

			switch ( $part ) {
				case 'membership/billing':
					include_once 'billing.php';
				break;

				case 'membership/invoices':
					include_once 'invoices.php';
				break;

				case 'membership/invite-codes':
					include_once 'invite-codes.php';
				break;

				case 'membership/affiliates':
					include_once 'affiliates.php';
				break;													
				
				default:
					include_once 'subscription.php';
				break;
			}
			?>
		</div>	

	<?php endif;

streamtube_core_the_dashboard_content_end();	