<?php
if( ! defined('ABSPATH' ) ){
    exit;
}

streamtube_core_the_dashboard_head( esc_html__( 'Withdrawal', 'streamtube-core' ) );

streamtube_core_the_dashboard_content_start();
?>
    <div class="withdraw-points">
        <?php
        /**
         *
         * Fires before table
         *
         * 
         */
        do_action( 'streamtube/core/dashboard/withdraw/table/before' );
        ?>  
        <?php
            if( function_exists( 'mycred_render_cashcred' ) ){
                $output = mycred_render_cashcred( apply_filters(
                    'streamtube/core/mycred/cashcred/withdraw_args',
                    array(
                        'insufficient'  =>  sprintf(
                            '<div class="not-found p-3 text-center text-muted fw-normal h6"><p>%s</p></div>',
                            esc_html__( 'Insufficient Points for Withdrawal', 'streamtube-core' )
                        )
                    )
                ) );

                $find_replace = array(
                    '<form method="post" class="mycred-cashcred-form" action="">',
                    sprintf(
                        '<form method="post" class="mycred-cashcred-form" action="">%s',
                        wp_nonce_field( 'withdraw_on_dashboard', 'withdraw_on_dashboard', true, false )
                    )
                );

                $output = str_replace( $find_replace[0], $find_replace[1], $output );

                echo $output;
            }
        ?>
        <?php
        /**
         *
         * Fires before table
         *
         * 
         */
        do_action( 'streamtube/core/dashboard/withdraw/table/after' );
        ?>      
    </div>
<?php streamtube_core_the_dashboard_content_end();