<?php
/**
 * Define the directorist functionality
 *
 *
 * @link       https://themeforest.net/user/phpface
 * @since      1.1
 *
 * @package    Streamtube_Core
 * @subpackage Streamtube_Core/includes
 */

/**
 *
 * @since      1.0.0
 * @package    Streamtube_Core
 * @subpackage Streamtube_Core/includes
 * @author     phpface <nttoanbrvt@gmail.com>
 */

if( ! defined('ABSPATH' ) ){
    exit;
}

class StreamTube_Core_Directorist{

    public function parse_request( $wp ){
        if( isset( $wp->query_vars['author_name'] ) && isset( $wp->query_vars['listings'] ) ){
            $wp->query_vars['author_id'] = get_user_by( 'slug', $wp->query_vars['author_name'] )->ID;
        }
    }

    /**
     *
     * Fix directorist paged
     *
     */
    public function filter_author_directorist_pagination( $navigation, $links, $query_results, $paged ){
        $largeNumber = 999999999;
        $total = ( isset( $query_results->total_pages ) ) ? $query_results->total_pages : $query_results->max_num_pages;

        $links = paginate_links(array(
            'format'    => '?paged=%#%',
            'current'   => max( 1, $paged ),
            'total'     => $total,
            'prev_text' => apply_filters('directorist_pagination_prev_text', directorist_icon( 'fas fa-chevron-left', false )),
            'next_text' => apply_filters('directorist_pagination_next_text', directorist_icon( 'fas fa-chevron-right', false )),
        ));

        if ( $links ) {
            $navigation = '<nav class="directorist-pagination" aria-label="Listings Pagination">'.$links.'</nav>';
        }

        return $navigation;
    }

    /**
     *
     * Display listing user profile tab and content
     * 
     */
    public function register_profile_menu_listing( $items ){
        $items['listings'] = array(
            'title'         =>  esc_html__( 'Listings', 'streamtube-core' ),
            'icon'          =>  'icon-star-half-alt',
            'callback'      =>  function(){
                load_template( trailingslashit( plugin_dir_path( __FILE__ ) ) . 'profile/listing.php' );
            },              
            'widgetizer'    =>  true,
            'priority'      =>  70
        );
        return $items;
    }

    /**
     *
     * Enqueue scripts and css
     * 
     */
    public function enqueue_scripts(){
        wp_enqueue_style( 
            'streamtube-core-directorist',
            plugin_dir_url( __FILE__ ) . 'assets/style.css', 
            array( 'directorist-main-style' ), 
            filemtime( plugin_dir_path( __FILE__ ) . 'assets/style.css' )
        );
    }
}