<?php
/**
 * Define the BunnyCDN Settings functionality
 *
 *
 * @link       https://themeforest.net/user/phpface
 * @since      2.1
 *
 * @package    Streamtube_Core
 * @subpackage Streamtube_Core/includes
 */

/**
 *
 * @since      2.1
 * @package    Streamtube_Core
 * @subpackage Streamtube_Core/includes
 * @author     phpface <nttoanbrvt@gmail.com>
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

class Streamtube_Core_BunnyCDN_Settings {
	/**
	 *
	 * Get settings
	 *
	 * @since 2.1
	 * 
	 */
	public static function get_settings() {

		$webhook_key = md5( uniqid() );

		$taxonomies = get_object_taxonomies( 'video', 'object' );

		$settings = (array) get_option( '_bunnycdn' );

		$settings = wp_parse_args( $settings, array(
			'enable'                        => '',
			'upload_type'                   => 'auto',
			'is_connected'                  => '',
			'libraryId'                     => '',
			'AccessKey'                     => '',
			'cdn_hostname'                  => '',
			'token_auth_key'                => '',
			'token_expires'                 => 3600,
			'auto_import_uploads'           => '',
			'auto_import_author_id'         => '1',
			'auto_import_post_status'       => 'publish',
			'auto_import_auto_cat'          => '',
			'webhook_key'                   => $webhook_key,
			'allow_formats'                 => '4mv,amv,avi,flv,m4p,m4v,mkv,mov,mp3,mp4,mpeg,mpg,mxf,ogg,ts,vod,wav,webm,wmv',
			'sync_type'                     => 'fetching',
			'curl_path'                     => get_option( 'system_curl_path', '/usr/bin/curl' ),
			'tsp'                           => '',
			'tsp_path'                      => get_option( 'system_tsp_path', '/usr/bin/tsp' ),
			'delete_original'               => '',
			'animation_image'               => '',
			'auto_import_thumbnail'         => '',
			'bunny_player'                  => '',
			'auto_publish'                  => '',
			'author_notify_publish'         => '',
			'author_notify_publish_subject' => 'Your {post_name} is now on {website_name}',
			'author_notify_publish_content' => self::get_default_notify_publish_content(),
			'author_notify_fail'            => '',
			'author_notify_fail_subject'    => 'Your {post_name} encoding failed on {website_name}',
			'author_notify_fail_content'    => self::get_default_notify_encoding_fail_content()
		) );

		if ( ! $settings['webhook_key'] ) {
			$settings['webhook_key'] = $webhook_key;
		}

		if ( ! array_key_exists( 'upload_type', $settings ) || empty( $settings['upload_type'] ) ) {
			$settings['upload_type'] = 'auto';
		}

		if ( ! array_key_exists( 'upload_handler', $settings ) || empty( $settings['upload_handler'] ) ) {
			$settings['upload_handler'] = 'resumable';
		}

		if ( ! array_key_exists( 'file_organize', $settings ) ) {
			$settings['file_organize'] = '1';
		}

		foreach ( $taxonomies as $tax => $object ) {
			if ( ! array_key_exists( 'auto_import_tax_' . $tax, $settings ) ) {
				$settings[ 'auto_import_tax_' . $tax ] = '';
			}
		}

		return $settings;
	}

	/**
	 *
	 * Default Notify Public Content
	 * 
	 * @return string
	 *
	 * @since 2.1
	 * 
	 */
	public static function get_default_notify_publish_content() {
		$content = 'Your video {post_name} is now ready to watch on {website_name}' . "\r\n\r\n";

		$content .= '{post_url}' . "\r\n\r\n";

		return $content;
	}

	/**
	 *
	 * Default Notify Encoding Failed Content
	 * 
	 * @return string
	 *
	 * @since 2.1
	 * 
	 */
	public static function get_default_notify_encoding_fail_content() {
		$content = 'Your video {post_name} encoding failed on %s' . "\r\n\r\n";

		$content .= '{post_url}' . "\r\n\r\n";

		return $content;
	}
}