<?php
// If this file is called directly, abort.
if ( ! defined( 'WPINC' ) ) {
	die;
}

/**
 * Define the rest functionality.
 *
 *
 * @since      1.0.6
 * @package    Streamtube_Core
 * @subpackage Streamtube_Core/includes
 * @author     phpface <nttoanbrvt@gmail.com>
 */

class StreamTube_Core_Bunny_Rest_Controller extends StreamTube_Core_Rest_API{
	protected $path     =   '/bunny';

    /**
     * @since 1.0.6
     */
    public function rest_api_init(){

        register_rest_route(
            "{$this->namespace}{$this->version}",
            $this->path . '/import', 
            array(
                'methods'   =>  WP_REST_Server::CREATABLE,
                'callback'  =>  array( $this , 'create_import' ),
                'args'		=>	array(
                	'guid'	=>	array(
                		'validate_callback'	=>	function( $param, $request, $key ){
                			return is_string( $param );
                		}
                	),
                    'size'      =>  array(
                        'validate_callback' =>  function( $param, $request, $key ){
                            return is_string( $param ) || is_numeric( $param );
                        }
                    ),
                    'type'      =>  array(
                        'validate_callback' =>  function( $param, $request, $key ){
                            return is_string( $param );
                        }
                    ),
                    'status'   =>  array(
                        'validate_callback' =>  function( $param, $request, $key ){
                            return is_string( $param );
                        }
                    )
                ),
                'permission_callback'   =>  function( $request ){
                    return Streamtube_Core_Permission::can_upload();
                }
            )
        ); 

        register_rest_route(
            "{$this->namespace}{$this->version}",
            $this->path . '/token', 
            array(
                'methods'   =>  WP_REST_Server::CREATABLE,
                'callback'  =>  array( $this , 'create_token' ),
                'args'      =>  array(
                    'name'  =>  array(
                        'validate_callback' =>  function( $param, $request, $key ){
                            return ( is_string( $param ) || is_number( $param ) ) && ! empty( $param );
                        }
                    ),                    
                    'size'  =>  array(
                        'validate_callback' =>  function( $param, $request, $key ){
                            return ( is_string( $param ) || is_number( $param ) ) && ! empty( $param );
                        }
                    ),
                    'type'  =>  array(
                        'validate_callback' =>  function( $param, $request, $key ){
                            return is_string( $param );
                        }
                    )                    
                ),                
                'permission_callback'   =>  function( $request ){
                    return Streamtube_Core_Permission::can_upload();
                }
            )
        ); 

        register_rest_route(
            "{$this->namespace}{$this->version}",
            $this->path . '/collection', 
            array(
                'methods'   =>  WP_REST_Server::CREATABLE,
                'callback'  =>  array( $this , 'create_collection' ),                
                'permission_callback'   =>  function( $request ){
                    return Streamtube_Core_Permission::can_upload();
                }
            )
        );                
    }

    /**
     *
     * Get bunny instance
     * 
     */
    private function get_instance(){
    	return $GLOBALS['streamtube']->get();
    }

    /**
     *
     * Update profile
     * 
     * @param WP_Rest_Request $request
     * @return JSON
     *
     * @since 1.0.6
     */
    public function create_token( $request ){

    	$response = $this->get_instance()->bunnycdn->create_resumable_token( array(
            'name'  =>  $request['name'],
            'size'  =>  $request['size'],
            'type'  =>  $request['type']
        ) );

    	if( is_wp_error( $response ) ){
    		wp_send_json_error( $response, 403 );
    	}

    	wp_send_json_success( $response );
    }

    /**
     *
     * Update profile
     * 
     * @param WP_Rest_Request $request
     * @return JSON
     *
     * @since 1.0.6
     */
    public function create_import( $request ){
    	$response = $this->get_instance()->bunnycdn->import_bunny_video( array(
            'guid'          =>  $request['guid'],
            'size'          =>  $request['size'],
            'type'          =>  $request['type'],
            'status'        =>  $request['status'] ?? 'pending',
            'include_tax'   =>  false
        ) );

    	if( is_wp_error( $response ) ){
    		wp_send_json_error( $response, 403 );
    	}

        $post = $this->get_instance()->post->get_post( $response['post_id'] );

    	wp_send_json_success( compact( 'post' ) );
    }

    /**
     *
     * Create collection
     * 
     * @param WP_Rest_Request $request
     */
    public function create_collection( $request ){

        $collection = $this->get_instance()->bunnycdn->create_user_collection();

        if( is_wp_error( $collection ) ){
            wp_send_json_error( $collection, 403 );
        }
       
        wp_send_json_success( $collection );
    }
}